/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.gui.plotter.LabelRotatingPlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.settings.ListeningJCheckBox;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class LocalNormalizationPlotterAdapter
extends LabelRotatingPlotterAdapter {
    private static final long serialVersionUID = -232182954939212825L;
    public static final String PARAMETER_LOCAL_NORMALIZATION = "local_normalization";
    private final ListeningJCheckBox localNormalizationBox = new ListeningJCheckBox("_local_normalization", "Local Normalization", false);
    private boolean isLocalNormalized;

    public LocalNormalizationPlotterAdapter(final PlotterConfigurationModel settings) {
        super(settings);
        this.localNormalizationBox.setToolTipText("Indicates if a local normalization for each dimension should be performed or not.");
        this.localNormalizationBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                settings.setParameterAsBoolean(LocalNormalizationPlotterAdapter.PARAMETER_LOCAL_NORMALIZATION, LocalNormalizationPlotterAdapter.this.localNormalizationBox.isSelected());
            }
        });
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        types.add(new ParameterTypeBoolean(PARAMETER_LOCAL_NORMALIZATION, "Indicates if values should be normalized for each dimension between 0 and 1.", false));
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        super.setAdditionalParameter(key, value);
        if (key.equals(PARAMETER_LOCAL_NORMALIZATION)) {
            this.isLocalNormalized = Boolean.parseBoolean(value);
            this.updatePlotter();
        }
    }

    @Override
    public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
        List<PlotterConfigurationModel.PlotterSettingsChangedListener> list = super.getListeningObjects();
        list.add(this.localNormalizationBox);
        return list;
    }

    public boolean isLocalNormalized() {
        return this.isLocalNormalized;
    }

    protected JComponent getLocalNormalizationComponent() {
        return this.localNormalizationBox;
    }
}

