/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.settings.ListeningJCheckBox;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;

public abstract class LabelRotatingPlotterAdapter
extends PlotterAdapter {
    private static final long serialVersionUID = -8622638833472714672L;
    public static final String PARAMETER_ROTATE_LABELS = "rotate_labels";
    private final ListeningJCheckBox rotateLabels = new ListeningJCheckBox("_rotate_labels", "Rotate Labels", false);
    private boolean rotateLabelsFlag = false;

    public LabelRotatingPlotterAdapter(final PlotterConfigurationModel settings) {
        super(settings);
        this.rotateLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.setParameterAsBoolean(LabelRotatingPlotterAdapter.PARAMETER_ROTATE_LABELS, LabelRotatingPlotterAdapter.this.rotateLabels.isSelected());
            }
        });
    }

    protected abstract void updatePlotter();

    @Override
    public List<ParameterType> getAdditionalParameterKeys(InputPort inputPort) {
        List<ParameterType> types = super.getAdditionalParameterKeys(inputPort);
        types.add(new ParameterTypeBoolean(PARAMETER_ROTATE_LABELS, "Indicates if the domain axis labels should be rotated.", false));
        return types;
    }

    public boolean isLabelRotating() {
        return this.rotateLabelsFlag;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        super.setAdditionalParameter(key, value);
        if (key.equals(PARAMETER_ROTATE_LABELS)) {
            this.rotateLabelsFlag = Boolean.parseBoolean(value);
            this.updatePlotter();
        }
    }

    @Override
    public List<PlotterConfigurationModel.PlotterSettingsChangedListener> getListeningObjects() {
        List<PlotterConfigurationModel.PlotterSettingsChangedListener> list = super.getListeningObjects();
        list.add(this.rotateLabels);
        return list;
    }

    protected JComponent getRotateLabelComponent() {
        return this.rotateLabels;
    }
}

