/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class DensityPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -3723769116082161327L;
    private static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    private static final int POINT_COLOR = 2;
    private static final int MATRIX_WIDTH = 300;
    private static final int MATRIX_HEIGHT = 200;
    private transient DataTable dataTable;
    private List<Point> points = new LinkedList<Point>();
    private int[] axes = new int[]{-1, -1};
    private int pointColorIndex = -1;
    private int densityColorIndex = -1;
    private double minDensityColor;
    private double maxDensityColor;
    private double minPointColor;
    private double maxPointColor;
    private double[] min;
    private double[] max;
    private double[][] colorMatrix;
    private String currentToolTip = null;
    private double toolTipX = 0.0;
    private double toolTipY = 0.0;
    private transient BufferedImage image = null;

    public DensityPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
    }

    public DensityPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.prepareData();
        this.repaint();
    }

    @Override
    public int getNumberOfAxes() {
        return 3;
    }

    @Override
    public int getAxis(int axis) {
        switch (axis) {
            case 0: {
                return this.axes[0];
            }
            case 1: {
                return this.axes[1];
            }
            case 2: {
                return this.pointColorIndex;
            }
        }
        return -1;
    }

    @Override
    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
            case 2: {
                return "Point Color";
            }
        }
        return "none";
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index == 0 || index == 1) {
            this.axes[index] = dimension;
        } else if (index == 2) {
            this.pointColorIndex = dimension;
        }
        this.prepareData();
        this.repaint();
    }

    @Override
    public String getPlotName() {
        return "Density Color";
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.densityColorIndex = index;
        this.prepareData();
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return index == this.densityColorIndex;
    }

    private void prepareData() {
        this.points.clear();
        this.minPointColor = Double.POSITIVE_INFINITY;
        this.maxPointColor = Double.NEGATIVE_INFINITY;
        this.minDensityColor = Double.POSITIVE_INFINITY;
        this.maxDensityColor = Double.NEGATIVE_INFINITY;
        this.min = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        this.max = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        this.colorMatrix = new double[300][200];
        for (int x = 0; x < 300; ++x) {
            for (int y = 0; y < 200; ++y) {
                this.colorMatrix[x][y] = 0.5;
            }
        }
        if (this.axes[0] >= 0 && this.axes[1] >= 0 && this.densityColorIndex >= 0) {
            Iterator<DataTableRow> i = this.dataTable.iterator();
            if (this.pointColorIndex >= 0) {
                while (i.hasNext()) {
                    DataTableRow row = i.next();
                    double pointColor = row.getValue(this.pointColorIndex);
                    if (Double.isNaN(pointColor)) continue;
                    this.minPointColor = MathFunctions.robustMin(this.minPointColor, pointColor);
                    this.maxPointColor = MathFunctions.robustMax(this.maxPointColor, pointColor);
                }
            }
            i = this.dataTable.iterator();
            ColorProvider colorProvider = this.getColorProvider();
            while (i.hasNext()) {
                DataTableRow row = i.next();
                double densityColor = row.getValue(this.densityColorIndex);
                double xValue = row.getValue(this.axes[0]);
                double yValue = row.getValue(this.axes[1]);
                if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
                this.minDensityColor = MathFunctions.robustMin(this.minDensityColor, densityColor);
                this.maxDensityColor = MathFunctions.robustMax(this.maxDensityColor, densityColor);
                this.min[0] = MathFunctions.robustMin(this.min[0], xValue);
                this.max[0] = MathFunctions.robustMax(this.max[0], xValue);
                this.min[1] = MathFunctions.robustMin(this.min[1], yValue);
                this.max[1] = MathFunctions.robustMax(this.max[1], yValue);
                double pointColor = 0.0;
                Color borderColor = Color.BLACK;
                if (this.pointColorIndex >= 0) {
                    pointColor = colorProvider.getPointColorValue(this.dataTable, row, this.pointColorIndex, this.minPointColor, this.maxPointColor);
                    borderColor = colorProvider.getPointBorderColor(this.dataTable, row, this.pointColorIndex);
                }
                this.points.add(new Point(xValue, yValue, densityColor, pointColor, borderColor, row.getId()));
            }
            Collections.shuffle(this.points, new Random(2001L));
            int radius = (int)Math.max(1.0, (double)(2 * Math.max(300, 200)) / Math.sqrt(this.points.size()));
            for (Point point : this.points) {
                double color = (point.densityColor - this.minDensityColor) / (this.maxDensityColor - this.minDensityColor);
                int matrixX = (int)((point.x - this.min[0]) / (this.max[0] - this.min[0]) * 300.0);
                int matrixY = (int)((point.y - this.min[1]) / (this.max[1] - this.min[1]) * 200.0);
                this.changeColor(this.colorMatrix, matrixX, matrixY, color, radius);
            }
            this.image = new BufferedImage(300, 200, 1);
            for (int x = 0; x < 300; ++x) {
                for (int y = 0; y < 200; ++y) {
                    this.image.setRGB(x, 200 - y - 1, colorProvider.getPointColor(this.colorMatrix[x][y]).getRGB());
                }
            }
        }
    }

    private void changeColor(double[][] colorMatrix, int matrixX, int matrixY, double color, int radius) {
        double maxDistance = radius;
        for (int x = matrixX - radius; x < matrixX + radius; ++x) {
            for (int y = matrixY - radius; y < matrixY + radius; ++y) {
                if (x < 0 || x >= 300 || y < 0 || y >= 200) continue;
                int xDiff = x - matrixX;
                int yDiff = y - matrixY;
                double distanceFactor = MathFunctions.robustMax(0.0, (maxDistance - Math.sqrt(xDiff * xDiff + yDiff * yDiff)) / maxDistance);
                double colorDiff = color - colorMatrix[x][y];
                colorMatrix[x][y] = MathFunctions.robustMax(0.0, MathFunctions.robustMin(1.0, colorMatrix[x][y] + distanceFactor * colorDiff));
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.points.size() > 0) {
            if (this.pointColorIndex >= 0) {
                this.drawLegend(graphics, this.dataTable, this.pointColorIndex);
            } else if (this.densityColorIndex >= 0) {
                this.drawLegend(graphics, this.dataTable, this.densityColorIndex);
            }
            int pixWidth = this.getWidth() - 40;
            int pixHeight = this.getHeight() - 40;
            Graphics2D translated = (Graphics2D)graphics.create();
            translated.translate(20, 20);
            this.paintDensity(translated, pixWidth, pixHeight);
            if (this.pointColorIndex >= 0) {
                this.paintPoints(translated, pixWidth, pixHeight);
            }
            this.drawToolTip(translated);
            translated.dispose();
        }
    }

    private void paintDensity(Graphics2D g, int pixWidth, int pixHeight) {
        g.drawImage(this.image, 0, 0, pixWidth, pixHeight, Color.WHITE, null);
    }

    private void paintPoints(Graphics2D g, int pixWidth, int pixHeight) {
        Iterator<Point> p = this.points.iterator();
        ColorProvider colorProvider = this.getColorProvider();
        while (p.hasNext()) {
            Point point = p.next();
            double xPos = (point.x - this.min[0]) / (this.max[0] - this.min[0]) * (double)pixWidth;
            double yPos = (point.y - this.min[1]) / (this.max[1] - this.min[1]) * (double)pixHeight;
            this.drawPoint(g, xPos, (double)pixHeight - yPos, colorProvider.getPointColor(point.pointColor), point.borderColor);
        }
    }

    @Override
    public boolean isProvidingCoordinates() {
        return true;
    }

    @Override
    public Point2D getPositionInDataSpace(java.awt.Point p) {
        double pixWidth = this.getWidth() - 40;
        double pixHeight = this.getHeight() - 40;
        double dataX = (p.getX() - 20.0) * (this.max[0] - this.min[0]) / pixWidth + this.min[0];
        double dataY = (pixHeight - p.getY() - 20.0) * (this.max[1] - this.min[1]) / pixHeight + this.min[1];
        return new Point2D.Double(dataX, dataY);
    }

    @Override
    public String getIdForPos(int x, int y) {
        Point point = this.getPlotterPointForPos(x, y);
        if (point != null) {
            return point.id;
        }
        return null;
    }

    private Point getPlotterPointForPos(int _x, int _y) {
        int x = _x - 20;
        int y = _y - 20;
        double pixWidth = this.getWidth() - 40;
        double pixHeight = this.getHeight() - 40;
        for (Point point : this.points) {
            double xPos = (point.x - this.min[0]) / (this.max[0] - this.min[0]) * pixWidth;
            double yPos = pixHeight - (point.y - this.min[1]) / (this.max[1] - this.min[1]) * pixHeight;
            if (!(Math.abs(xPos - (double)x) < 3.0) || !(Math.abs(yPos - (double)y) < 3.0)) continue;
            return point;
        }
        return null;
    }

    @Override
    public void setMousePosInDataSpace(int x, int y) {
        if (this.pointColorIndex >= 0) {
            Point point = this.getPlotterPointForPos(x, y);
            if (point != null) {
                String id = point.id;
                if (id != null) {
                    double pixWidth = this.getWidth() - 40;
                    double pixHeight = this.getHeight() - 40;
                    double xPos = (point.x - this.min[0]) / (this.max[0] - this.min[0]) * pixWidth;
                    double yPos = pixHeight - (point.y - this.min[1]) / (this.max[1] - this.min[1]) * pixHeight;
                    this.setToolTip(id, xPos, yPos);
                } else {
                    this.setToolTip(null, 0.0, 0.0);
                }
            } else {
                this.setToolTip(null, 0.0, 0.0);
            }
        } else {
            this.setToolTip(null, 0.0, 0.0);
        }
    }

    private void setToolTip(String toolTip, double x, double y) {
        this.currentToolTip = toolTip;
        this.toolTipX = x;
        this.toolTipY = y;
        this.repaint();
    }

    private void drawToolTip(Graphics2D g) {
        if (this.currentToolTip != null) {
            g.setFont(LABEL_FONT);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.currentToolTip, g.getFontRenderContext());
            g.setColor(TOOLTIP_COLOR);
            Rectangle2D.Double bg = new Rectangle2D.Double(this.toolTipX - stringBounds.getWidth() - 15.0, this.toolTipY - stringBounds.getHeight() / 2.0, stringBounds.getWidth() + 6.0, Math.abs(stringBounds.getHeight()) + 4.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.currentToolTip, (float)(this.toolTipX - stringBounds.getWidth() - 12.0), (float)(this.toolTipY + stringBounds.getHeight() * 0.5 + 1.0));
        }
    }

    @Override
    public String getPlotterName() {
        return "Density";
    }

    private static class Point {
        String id;
        double x;
        double y;
        double densityColor;
        double pointColor;
        Color borderColor;

        public Point(double x, double y, double densityColor, double pointColor, Color borderColor, String id) {
            this.x = x;
            this.y = y;
            this.densityColor = densityColor;
            this.pointColor = pointColor;
            this.borderColor = borderColor;
            this.id = id;
        }
    }
}

