/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.ColorQuartilePlotter;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.conditions.ColumnsPlotterCondition;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;
import com.rapidminer.tools.LogService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColorQuartileMatrixPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -3049267947471497204L;
    static final int MAX_NUMBER_OF_COLUMNS = 100;
    private ColorQuartilePlotter[] plotters = new ColorQuartilePlotter[0];
    private int plotterSize;
    private int colorIndex = -1;
    private double maxWeight = Double.NaN;
    private transient DataTable dataTable;

    public ColorQuartileMatrixPlotter(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        String sizeProperty = System.getProperty("rapidminer.gui.plotter.matrixplot.size");
        this.plotterSize = 200;
        try {
            if (sizeProperty != null) {
                this.plotterSize = Integer.parseInt(sizeProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Quartile matrix: cannot parse plotter size (was '" + sizeProperty + "'), using default size (200).", 5);
        }
    }

    public ColorQuartileMatrixPlotter(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.updateMatrix();
    }

    @Override
    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMatrix() {
        int numberOfPlotters = this.dataTable.getNumberOfColumns();
        if (this.colorIndex != -1) {
            --numberOfPlotters;
        }
        this.plotters = new ColorQuartilePlotter[numberOfPlotters];
        int x = 0;
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            for (int i = 0; i < this.dataTable.getNumberOfColumns(); ++i) {
                if (i == this.colorIndex) continue;
                this.plotters[x] = new ColorQuartilePlotter(this.getPlotterSettings(), this.dataTable);
                this.plotters[x].getPlotter().setSize(new Dimension(this.plotterSize, this.plotterSize));
                this.plotters[x].setAxis(0, i);
                this.plotters[x].setPlotColumn(this.colorIndex, true);
                this.plotters[x].setDrawLegend(false);
                this.plotters[x].setKey(this.dataTable.getColumnName(i));
                ++x;
            }
            this.maxWeight = this.getMaxWeight(this.dataTable);
        }
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getMaxNumberPerRow() * this.plotterSize + 40, this.getMaxNumberPerRow() * this.plotterSize + 40);
    }

    private int getMaxNumberPerRow() {
        return (int)Math.ceil(Math.sqrt(this.plotters.length));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int xPos = 0;
        int yPos = 0;
        for (int x = 0; x < this.plotters.length; ++x) {
            if (xPos >= this.getMaxNumberPerRow()) {
                ++yPos;
                xPos = 0;
            }
            Graphics2D newSpace = (Graphics2D)graphics.create();
            newSpace.translate(20 + xPos * this.plotterSize, 20 + yPos * this.plotterSize);
            this.drawWeightRectangle(newSpace, this.dataTable, x, this.maxWeight, this.plotterSize);
            newSpace.translate(7, 7);
            this.plotters[x].paintQuartiles(newSpace, this.plotterSize - 13, this.plotterSize - 13);
            newSpace.dispose();
            ++xPos;
        }
        if (this.colorIndex != -1) {
            this.drawLegend(graphics, this.dataTable, this.colorIndex, 0, 80);
        }
    }

    @Override
    public String getPlotName() {
        return "Color";
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorIndex = index;
        this.updateMatrix();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return index == this.colorIndex;
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    @Override
    public String getPlotterName() {
        return "Quartile Color Matrix";
    }
}

