/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import java.awt.Color;

public class ColorProvider {
    public Color getMinLegendColor() {
        return this.getColorFromProperty("rapidminer.gui.plotter.legend.mincolor", Color.BLUE);
    }

    public Color getMaxLegendColor() {
        return this.getColorFromProperty("rapidminer.gui.plotter.legend.maxcolor", Color.RED);
    }

    private Color getColorFromProperty(String propertyName, Color errorColor) {
        String propertyString = System.getProperty(propertyName);
        if (propertyString != null) {
            String[] colors = propertyString.split(",");
            Color color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
            return color;
        }
        return errorColor;
    }

    public double getPointColorValue(DataTable table, DataTableRow row, int column, double min, double max) {
        double compareValue;
        String otherColumnName;
        int otherColumnIndex;
        int endParIndex;
        String columnName;
        int startParIndex;
        double colorValue = row.getValue(column);
        if (max == min && table.isNominal(column)) {
            return colorValue / (double)(table.getNumberOfValues(column) - 1);
        }
        double normalized = (colorValue - min) / (max - min);
        if (!Double.isNaN(colorValue) && table.isNominal(column) && table.getNumberOfValues(column) == 2 && (startParIndex = (columnName = table.getColumnName(column)).indexOf("(") + 1) >= 0 && (endParIndex = columnName.indexOf(")", startParIndex)) >= 0 && (otherColumnIndex = table.getColumnIndex(otherColumnName = columnName.substring(startParIndex, endParIndex))) >= 0 && table.isNominal(otherColumnIndex) && !Double.isNaN(compareValue = row.getValue(otherColumnIndex))) {
            int compareIndex = (int)compareValue;
            String compareString = table.mapIndex(otherColumnIndex, compareIndex);
            if (colorValue != (double)(compareIndex = table.mapString(column, compareString))) {
                if (normalized > 0.8) {
                    normalized = 0.8;
                } else if (normalized < 0.2) {
                    normalized = 0.2;
                }
            }
        }
        return normalized;
    }

    public Color getPointBorderColor(DataTable table, DataTableRow row, int column) {
        double colorValue;
        Color result = Color.BLACK;
        if (table.isNominal(column) && !Double.isNaN(colorValue = row.getValue(column))) {
            double compareValue;
            String otherColumnName;
            int otherColumnIndex;
            int endParIndex;
            int colorIndex = (int)colorValue;
            String columnName = table.getColumnName(column);
            int startParIndex = columnName.indexOf("(") + 1;
            if (startParIndex >= 0 && (endParIndex = columnName.indexOf(")", startParIndex)) >= 0 && (otherColumnIndex = table.getColumnIndex(otherColumnName = columnName.substring(startParIndex, endParIndex))) >= 0 && table.isNominal(otherColumnIndex) && !Double.isNaN(compareValue = row.getValue(otherColumnIndex))) {
                int compareIndex = (int)compareValue;
                String compareString = table.mapIndex(otherColumnIndex, compareIndex);
                if (colorIndex != (compareIndex = table.mapString(column, compareString))) {
                    result = Color.RED;
                }
            }
        }
        return result;
    }

    public Color getPointColor(double value) {
        return this.getPointColor(value, 255);
    }

    public Color getPointColor(double value, int alpha) {
        if (Double.isNaN(value)) {
            return Color.LIGHT_GRAY;
        }
        Color MIN_LEGEND_COLOR = this.getMinLegendColor();
        Color MAX_LEGEND_COLOR = this.getMaxLegendColor();
        float[] minCol = Color.RGBtoHSB(MIN_LEGEND_COLOR.getRed(), MIN_LEGEND_COLOR.getGreen(), MIN_LEGEND_COLOR.getBlue(), null);
        float[] maxCol = Color.RGBtoHSB(MAX_LEGEND_COLOR.getRed(), MAX_LEGEND_COLOR.getGreen(), MAX_LEGEND_COLOR.getBlue(), null);
        double hColorDiff = maxCol[0] - minCol[0];
        double sColorDiff = maxCol[1] - minCol[1];
        double bColorDiff = maxCol[2] - minCol[2];
        Color color = new Color(Color.HSBtoRGB((float)((double)minCol[0] + hColorDiff * value), (float)((double)minCol[1] + value * sColorDiff), (float)((double)minCol[2] + value * bColorDiff)));
        if (alpha < 255) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        return color;
    }
}

