/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.NameValue;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class BoundDiagram
extends PlotterAdapter
implements MouseListener {
    private static final long serialVersionUID = 3155061651939372589L;
    private List<NameValue> values = new ArrayList<NameValue>();
    private double maxWeight;
    private int radius;
    private String currentToolTip;
    private double toolTipX;
    private double toolTipY;
    private double[] angles;
    private double[] attributeVectorX;
    private double[] attributeVectorY;
    private int plotIndex = -1;
    private transient DataTable dataTable;
    private boolean absolute = false;
    private boolean sorting = false;

    public BoundDiagram(PlotterConfigurationModel settings) {
        super(settings);
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public BoundDiagram(PlotterConfigurationModel settings, DataTable dataTable) {
        this(settings);
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    public void calculateAngles() {
        float totalAngle = 360.0f;
        float delta = totalAngle / (float)this.values.size();
        float angle = 0.0f;
        this.angles = new double[this.values.size()];
        for (int i = 0; i < this.angles.length; ++i) {
            this.angles[i] = angle;
            angle += delta;
        }
    }

    public void calculateAttributeVectors() {
        this.attributeVectorX = new double[this.values.size()];
        this.attributeVectorY = new double[this.values.size()];
        double radius = 1.0;
        double x = 0.0;
        double y = 0.0;
        for (int dimindex = 0; dimindex < this.values.size(); ++dimindex) {
            int angleInt = (int)this.angles[dimindex];
            double angle = this.angles[dimindex];
            if (angleInt / 90 == 0) {
                x = this.sin(angle) * radius;
                y = this.sin(90.0 - angle) * radius;
            } else if (angleInt / 90 == 1) {
                x = this.sin(90.0 - (angle -= 90.0)) * radius;
                y = this.sin(angle) * radius;
                y = -y;
            } else if (angleInt / 90 == 2) {
                x = this.sin(angle -= 180.0) * radius;
                y = this.sin(90.0 - angle) * radius;
                x = -x;
                y = -y;
            } else if (angleInt / 90 == 3) {
                x = this.sin(90.0 - (angle -= 270.0)) * radius;
                y = this.sin(angle) * radius;
                x = -x;
            }
            this.attributeVectorX[dimindex] = x;
            this.attributeVectorY[dimindex] = y;
        }
    }

    private double sin(double angle) {
        while (angle >= 180.0) {
            angle -= 180.0;
        }
        double value = angle / 180.0 * Math.PI;
        return Math.sin(value);
    }

    private void prepareData() {
        this.values.clear();
        if (this.plotIndex >= 0) {
            Iterator<DataTableRow> i = this.dataTable.iterator();
            this.maxWeight = Double.NEGATIVE_INFINITY;
            while (i.hasNext()) {
                DataTableRow row = i.next();
                double value = row.getValue(this.plotIndex);
                if (this.absolute) {
                    value = Math.abs(value);
                }
                this.maxWeight = Math.max(this.maxWeight, Math.abs(value));
                String id = row.getId();
                if (id == null) {
                    id = value + "";
                }
                this.values.add(new NameValue(id, value));
            }
            if (this.sorting) {
                Collections.sort(this.values);
            }
        }
        this.calculateAngles();
        this.calculateAttributeVectors();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.prepareData();
        int width = this.getWidth();
        int height = this.getHeight();
        this.radius = Math.min(width, height);
        this.radius = (this.radius - 20) / 2;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        int centerX = this.radius + 10;
        int centerY = this.radius + 10;
        g.setColor(Color.BLACK);
        double[] r = new double[]{1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1};
        for (int i = 0; i < r.length; ++i) {
            g.drawOval((int)((double)centerX - (double)this.radius * r[i]), (int)((double)centerY - (double)this.radius * r[i]), (int)((double)this.radius * r[i] * 2.0), (int)((double)this.radius * r[i] * 2.0));
        }
        for (int att = 0; att < this.values.size(); ++att) {
            NameValue nameValue = this.values.get(att);
            Polygon polygon = new Polygon();
            polygon.addPoint(centerX, centerY);
            double ratio = Math.abs(nameValue.getValue()) / this.maxWeight;
            int x = centerX + (int)(ratio * (double)this.radius * this.attributeVectorX[att]);
            int y = centerY - (int)(ratio * (double)this.radius * this.attributeVectorY[att]);
            polygon.addPoint(x, y);
            x = centerX + (int)(ratio * (double)this.radius * this.attributeVectorX[(att + 1) % this.values.size()]);
            y = centerY - (int)(ratio * (double)this.radius * this.attributeVectorY[(att + 1) % this.values.size()]);
            polygon.addPoint(x, y);
            polygon.addPoint(centerX, centerY);
            if (nameValue.getValue() < 0.0) {
                g.setColor(this.getColorProvider().getMinLegendColor());
                g.fillPolygon(polygon);
                g.setColor(Color.DARK_GRAY);
                g.drawPolygon(polygon);
                continue;
            }
            g.setColor(this.getColorProvider().getMaxLegendColor());
            g.fillPolygon(polygon);
            g.setColor(Color.DARK_GRAY);
            g.drawPolygon(polygon);
        }
        this.drawToolTip((Graphics2D)g);
    }

    private void drawToolTip(Graphics2D g) {
        if (this.currentToolTip != null) {
            g.setFont(LABEL_FONT);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.currentToolTip, g.getFontRenderContext());
            g.setColor(TOOLTIP_COLOR);
            Rectangle2D.Double bg = new Rectangle2D.Double(this.toolTipX - stringBounds.getWidth() / 2.0 - 4.0, this.toolTipY - stringBounds.getHeight() / 2.0 - 2.0, stringBounds.getWidth() + 5.0, Math.abs(stringBounds.getHeight()) + 3.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.currentToolTip, (float)(this.toolTipX - stringBounds.getWidth() / 2.0) - 2.0f, (float)(this.toolTipY + 3.0));
        }
    }

    private void setToolTip(String toolTip, double x, double y) {
        this.currentToolTip = toolTip;
        this.toolTipX = x;
        this.toolTipY = y;
        this.repaint();
    }

    @Override
    public String getPlotName() {
        return "Plot";
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.plotIndex = index;
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return index == this.plotIndex;
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
        this.repaint();
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return true;
    }

    @Override
    public void setSorting(boolean sorting) {
        this.sorting = sorting;
        this.repaint();
    }

    @Override
    public boolean isSupportingSorting() {
        return true;
    }

    private String getAttributeName(int x, int y) {
        double minDistance = Double.POSITIVE_INFINITY;
        double minDistance2 = Double.POSITIVE_INFINITY;
        int minIndex = 0;
        int minIndex2 = 0;
        for (int att = 0; att < this.values.size(); ++att) {
            double distance;
            double distanceX = (double)this.radius + 10.0 + this.attributeVectorX[att] * (double)this.radius - (double)x;
            double distanceY = (double)this.radius + 10.0 - this.attributeVectorY[att] * (double)this.radius - (double)y;
            if ((distance = Math.sqrt((distanceX *= distanceX) + (distanceY *= distanceY))) < minDistance) {
                minIndex2 = minIndex;
                minIndex = att;
                minDistance2 = minDistance;
                minDistance = distance;
                continue;
            }
            if (!(distance < minDistance2)) continue;
            minIndex2 = att;
            minDistance2 = distance;
        }
        NameValue nameValue = null;
        nameValue = (minIndex2 + 1) % this.values.size() == minIndex ? this.values.get(minIndex2) : this.values.get(minIndex);
        return nameValue.getName() + ": " + Tools.formatNumber(nameValue.getValue());
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        String name = this.getAttributeName(event.getX(), event.getY());
        this.setToolTip(name, event.getX(), event.getY());
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.currentToolTip = null;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public String getPlotterName() {
        return "Bound";
    }
}

