/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree.actions;

import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.actions.ToggleAction;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;

public class ToggleActivationItem
extends ToggleAction {
    private static final long serialVersionUID = -7020868989225535479L;
    private final Actions actions;

    public ToggleActivationItem(Actions actions) {
        super(true, "enable_operator", new Object[0]);
        this.setCondition(2, -1);
        this.setCondition(0, 1);
        this.setCondition(7, 1);
        this.actions = actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionToggled(ActionEvent e) {
        if (this.actions.getSelectedOperators().isEmpty()) {
            return;
        }
        boolean targetState = this.getTargetState();
        for (Operator op : this.actions.getSelectedOperators()) {
            op.setEnabled(targetState);
        }
        if (!targetState && !"false".equals(System.getProperty("rapidminer.gui.disconnect_on_disable"))) {
            for (Operator op : this.actions.getSelectedOperators()) {
                LinkedList<Port> toUnlock = new LinkedList<Port>();
                try {
                    LinkedList<OutputPort> sources = new LinkedList<OutputPort>();
                    for (InputPort inputPort : op.getInputPorts().getAllPorts()) {
                        if (!inputPort.isConnected() || !inputPort.getSource().getPorts().getOwner().getOperator().isEnabled()) continue;
                        sources.add(inputPort.getSource());
                        toUnlock.add(inputPort.getSource());
                        inputPort.getSource().lock();
                    }
                    for (OutputPort outputPort : sources) {
                        outputPort.disconnect();
                    }
                    LinkedList<InputPort> destinations = new LinkedList<InputPort>();
                    for (OutputPort out : op.getOutputPorts().getAllPorts()) {
                        if (!out.isConnected() || !out.getDestination().getPorts().getOwner().getOperator().isEnabled()) continue;
                        destinations.add(out.getDestination());
                        toUnlock.add(out.getDestination());
                        out.getDestination().lock();
                    }
                    for (InputPort in : destinations) {
                        in.getSource().disconnect();
                    }
                    block9: for (OutputPort source : sources) {
                        Iterator i = destinations.iterator();
                        while (i.hasNext()) {
                            InputPort dest = (InputPort)i.next();
                            if (source.getMetaData() == null || !dest.isInputCompatible(source.getMetaData(), CompatibilityLevel.PRE_VERSION_5)) continue;
                            source.connectTo(dest);
                            i.remove();
                            continue block9;
                        }
                    }
                }
                finally {
                    for (Port port : toUnlock) {
                        port.unlock();
                    }
                }
            }
        }
    }

    public JMenuItem createMultipleActivationItem() {
        boolean targetState = this.getTargetState();
        String actionKey = targetState ? "enable_operator_multiple" : "disable_operator_multiple";
        return new JMenuItem(new ResourceAction(actionKey, new Object[]{this.actions.getSelectedOperators().size()}){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ToggleActivationItem.this.actionToggled(e);
            }
        });
    }

    private boolean getTargetState() {
        List<Operator> ops = this.actions.getSelectedOperators();
        if (ops == null || ops.isEmpty()) {
            return false;
        }
        for (Operator op : ops) {
            if (!op.isEnabled()) continue;
            return false;
        }
        return true;
    }
}

