/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree.actions;

import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.templates.SaveAsBuildingBlockDialog;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.ParameterService;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public class SaveBuildingBlockAction
extends ResourceAction {
    private static final long serialVersionUID = 2238740826770976483L;
    private Actions actions;

    public SaveBuildingBlockAction(Actions actions) {
        super(true, "save_building_block", new Object[0]);
        this.setCondition(0, 1);
        this.setCondition(2, -1);
        this.actions = actions;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Operator selectedOperator = this.actions.getSelectedOperator();
        if (selectedOperator != null) {
            SaveAsBuildingBlockDialog dialog = new SaveAsBuildingBlockDialog(selectedOperator);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                BuildingBlock buildingBlock = dialog.getBuildingBlock(selectedOperator);
                String name = buildingBlock.getName();
                try {
                    File buildingBlockFile = ParameterService.getUserConfigFile(name + ".buildingblock");
                    buildingBlock.save(buildingBlockFile);
                }
                catch (IOException ioe) {
                    SwingTools.showSimpleErrorMessage("cannot_write_building_block_file", (Throwable)ioe, new Object[0]);
                }
            }
        }
    }
}

