/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree;

import com.rapidminer.ProcessSetupListener;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.tools.LogService;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ProcessTreeModel
implements TreeModel {
    private final EventListenerList listenerList = new EventListenerList();
    private boolean showDisabled = true;
    private final Operator root;
    private final ProcessSetupListener delegatingListener = new ProcessSetupListener(){

        @Override
        public void operatorAdded(Operator operator) {
            ProcessTreeModel.this.fireTreeNodesInserted(operator);
        }

        @Override
        public void operatorChanged(Operator operator) {
            if (operator.getProcess().getProcessState() != 2) {
                ProcessTreeModel.this.fireTreeNodesChanged(operator);
            }
        }

        @Override
        public void operatorRemoved(Operator operator, int oldIndex, int oldIndexAmongEnabled) {
            ProcessTreeModel.this.fireTreeNodesRemoved(operator, ProcessTreeModel.this.showDisabled ? oldIndex : oldIndexAmongEnabled);
        }

        @Override
        public void executionOrderChanged(ExecutionUnit unit) {
            ProcessTreeModel.this.fireTreeStructureChanged(unit);
        }
    };

    public ProcessTreeModel(Operator root) {
        this.root = root;
        root.getProcess().addProcessSetupListener(this.delegatingListener);
    }

    private List<Operator> getChildren(ExecutionUnit process) {
        if (this.showDisabled) {
            return process.getOperators();
        }
        return process.getEnabledOperators();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (index == -1) {
            throw new IllegalArgumentException("Index -1 not allowed.");
        }
        if (parent instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)parent;
            if (chain.getNumberOfSubprocesses() == 1) {
                return this.getChildren(chain.getSubprocess(0)).get(index);
            }
            return ((OperatorChain)parent).getSubprocess(index);
        }
        if (parent instanceof ExecutionUnit) {
            return this.getChildren((ExecutionUnit)parent).get(index);
        }
        throw new IllegalArgumentException("Illegal tree node: " + parent);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)parent;
            if (chain.getNumberOfSubprocesses() == 1) {
                return this.getChildren(chain.getSubprocess(0)).size();
            }
            return ((OperatorChain)parent).getNumberOfSubprocesses();
        }
        if (parent instanceof ExecutionUnit) {
            return this.getChildren((ExecutionUnit)parent).size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)parent;
            if (chain.getNumberOfSubprocesses() == 1) {
                return this.getChildren(chain.getSubprocess(0)).indexOf(child);
            }
            return ((OperatorChain)parent).getSubprocesses().indexOf(child);
        }
        if (parent instanceof ExecutionUnit) {
            return this.getChildren((ExecutionUnit)parent).indexOf(child);
        }
        LogService.getRoot().warning(child + " is no child of " + parent);
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof OperatorChain) {
            return ((OperatorChain)node).getNumberOfSubprocesses() == 0;
        }
        if (node instanceof ExecutionUnit) {
            return ((ExecutionUnit)node).getNumberOfOperators() == 0;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object leaf = path.getLastPathComponent();
        if (leaf instanceof Operator) {
            Operator op = (Operator)leaf;
            String desiredName = ((String)newValue).trim();
            if (desiredName.length() > 0) {
                if (desiredName.indexOf(46) >= 0) {
                    JOptionPane.showMessageDialog(RapidMinerGUI.getMainFrame(), "Renaming not possible: operator names are now allowed to contain the character '.'", "Renaming failed", 2);
                } else {
                    op.rename(desiredName);
                }
            }
        }
    }

    TreePath getPathTo(ExecutionUnit process) {
        return this.getPathTo(process.getEnclosingOperator()).pathByAddingChild(process);
    }

    public TreePath getPathTo(Operator operator) {
        if (operator.getParent() == null) {
            return new TreePath(operator);
        }
        TreePath pathToParent = operator.getParent().getNumberOfSubprocesses() == 1 ? this.getPathTo(operator.getParent()) : this.getPathTo(operator.getExecutionUnit());
        return pathToParent.pathByAddingChild(operator);
    }

    private TreeModelEvent makeChangeEvent(Operator operator) {
        ExecutionUnit parent = operator.getExecutionUnit();
        if (parent != null) {
            TreePath path = this.getPathTo(operator).getParentPath();
            int index = this.getChildren(operator.getExecutionUnit()).indexOf(operator);
            return new TreeModelEvent((Object)this, path, new int[]{index}, new Object[]{operator});
        }
        return new TreeModelEvent((Object)this, (TreePath)null, null, null);
    }

    private void fireTreeNodesChanged(Operator operator) {
        TreeModelEvent e = this.makeChangeEvent(operator);
        if (e.getChildIndices() != null && e.getChildIndices()[0] != -1) {
            for (TreeModelListener l : (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class)) {
                l.treeNodesChanged(e);
            }
        }
    }

    private void fireTreeNodesInserted(Operator operator) {
        TreeModelEvent e = this.makeChangeEvent(operator);
        for (TreeModelListener l : (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class)) {
            l.treeNodesInserted(e);
        }
    }

    private void fireTreeNodesRemoved(Operator operator, int oldIndex) {
        TreePath path = this.getPathTo(operator).getParentPath();
        TreeModelEvent e = new TreeModelEvent((Object)this, path, new int[]{oldIndex}, new Object[]{operator});
        for (TreeModelListener l : (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class)) {
            l.treeNodesRemoved(e);
        }
    }

    private void fireTreeStructureChanged(ExecutionUnit unit) {
        TreePath path = this.getPathTo(unit).getParentPath();
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        for (TreeModelListener l : (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class)) {
            l.treeStructureChanged(e);
        }
    }

    public void setShowDisabledOperators(boolean showDisabled) {
        this.showDisabled = showDisabled;
    }

    public boolean showDisabledOperators() {
        return this.showDisabled;
    }
}

