/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.PrintingTools;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.operator.Operator;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class OperatorTreePanel
extends JPanel
implements Dockable,
ProcessEditor {
    private static final long serialVersionUID = -6121229143892782298L;
    private final OperatorTree operatorTree;
    private final DockKey DOCK_KEY = new ResourceDockKey("operator_tree");
    private Component component;

    public OperatorTreePanel(MainFrame mainFrame) {
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.operatorTree = new OperatorTree(mainFrame);
        ViewToolBar toolBar = new ViewToolBar();
        toolBar.add(mainFrame.getActions().NEW_OPERATOR_ACTION);
        toolBar.add(mainFrame.getActions().NEW_BUILDING_BLOCK_ACTION);
        toolBar.add(mainFrame.REWIRE_RECURSIVELY);
        JToggleButton toggleAllBreakpointsButton = mainFrame.getActions().TOGGLE_ALL_BREAKPOINTS.createToggleButton();
        toggleAllBreakpointsButton.setText(null);
        toolBar.add(toggleAllBreakpointsButton);
        toolBar.add(this.operatorTree.EXPAND_ALL_ACTION, 1);
        toolBar.add(this.operatorTree.COLLAPSE_ALL_ACTION, 1);
        PrintingTools.makeExportPrintDropDownButton(this, "Tree").addToToolBar(toolBar, 1);
        this.setLayout(new BorderLayout());
        this.add((Component)toolBar, "North");
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.operatorTree);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this;
        }
        return this.component;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }

    @Override
    public void processChanged(Process process) {
        this.operatorTree.processChanged(process);
    }

    @Override
    public void processUpdated(Process process) {
        this.operatorTree.processUpdated(process);
    }

    @Override
    public void setSelection(List<Operator> selection) {
        this.operatorTree.setSelection(selection);
    }

    public OperatorTree getOperatorTree() {
        return this.operatorTree;
    }
}

