/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree;

import com.rapidminer.gui.dnd.OperatorTreeTransferHandler;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;

public class OperatorTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -8256080174651447518L;
    private static final Icon SUBPROCESS_ICON = SwingTools.createIcon("16/element_selection.png");
    private static final Border SUBPROCESS_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Border SUBPROCESS_MARKED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SwingTools.LIGHT_BLUE), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    private final OperatorPanel operatorPanel = new OperatorPanel();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Operator) {
            this.operatorPanel.updateOperator(tree, (Operator)value, selected, hasFocus);
            SwingTools.setEnabledRecursive(this.operatorPanel, this.operatorPanel.isEnabled());
            return this.operatorPanel;
        }
        if (value instanceof ExecutionUnit) {
            Component component = super.getTreeCellRendererComponent(tree, ((ExecutionUnit)value).getName(), selected, expanded, leaf, row, hasFocus);
            OperatorTreeTransferHandler.Position dndMarker = ((OperatorTree)tree).getOperatorTreeTransferHandler().getMarkerPosition((ExecutionUnit)value);
            if (dndMarker != OperatorTreeTransferHandler.Position.UNMARKED) {
                ((JComponent)component).setBorder(SUBPROCESS_MARKED_BORDER);
            } else {
                ((JComponent)component).setBorder(SUBPROCESS_BORDER);
            }
            ((JLabel)component).setIcon(SUBPROCESS_ICON);
            SwingTools.setEnabledRecursive(component, tree.isEnabled());
            return component;
        }
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    private static class OperatorPanel
    extends JPanel {
        private static final String BREAKPOINT_BEFORE = "16/breakpoint_up.png";
        private static final String BREAKPOINT_AFTER = "16/breakpoint_down.png";
        private static final String BREAKPOINTS = "16/breakpoints.png";
        private static final String WARNINGS = "16/sign_warning.png";
        private static final long serialVersionUID = -7680223153786362865L;
        private static final Color SELECTED_COLOR = UIManager.getColor("Tree.selectionBackground");
        private static final Color BORDER_SELECTED_COLOR = UIManager.getColor("Tree.selectionBorderColor");
        private static final Color TEXT_SELECTED_COLOR = UIManager.getColor("Tree.selectionForeground");
        private static final Color TEXT_NON_SELECTED_COLOR = UIManager.getColor("Tree.textForeground");
        private static Icon breakpointBeforeIcon = null;
        private static Icon breakpointAfterIcon = null;
        private static Icon breakpointsIcon = null;
        private static Icon warningsIcon = null;
        private final JLabel iconLabel = new JLabel("");
        private final JLabel nameLabel = new JLabel("");
        private final JLabel classLabel = new JLabel("");
        private final JLabel breakpoint = new JLabel("");
        private final JLabel error = new JLabel("");
        private boolean isSelected = false;
        private boolean hasFocus = false;
        private OperatorTreeTransferHandler.Position dndMarker;
        private final int[] downArrowXPoints = new int[]{4, 4, 6, 3, 0, 2, 2};
        private final int[] downArrowYPoints = new int[]{0, 4, 4, 7, 4, 4, 0};
        private final int[] upArrowXPoints = new int[]{3, 6, 4, 4, 2, 2, 0};
        private final int[] upArrowYPoints = new int[]{0, 3, 3, 7, 7, 3, 3};
        private final Polygon upArrow = new Polygon(this.upArrowXPoints, this.upArrowYPoints, 7);
        private final Polygon downArrow = new Polygon(this.downArrowXPoints, this.downArrowYPoints, 7);

        public OperatorPanel() {
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 21;
            c.fill = 0;
            c.weightx = 0.0;
            layout.setConstraints(this.iconLabel, c);
            this.add(this.iconLabel);
            JPanel namePanel = new JPanel();
            namePanel.setBackground(new Color(0, 0, 0, 0));
            GridBagLayout nameLayout = new GridBagLayout();
            GridBagConstraints nameC = new GridBagConstraints();
            nameC.fill = 1;
            nameC.insets = new Insets(0, 5, 0, 5);
            namePanel.setLayout(nameLayout);
            this.nameLabel.setHorizontalAlignment(2);
            this.nameLabel.setFont(this.getFont().deriveFont(0, 12.0f));
            nameC.gridwidth = 0;
            nameLayout.setConstraints(this.nameLabel, nameC);
            namePanel.add(this.nameLabel);
            this.classLabel.setHorizontalAlignment(2);
            this.classLabel.setFont(this.getFont().deriveFont(0, 10.0f));
            nameLayout.setConstraints(this.classLabel, nameC);
            namePanel.add(this.classLabel);
            c.weightx = 1.0;
            this.add((Component)namePanel, c);
            c.gridwidth = -1;
            c.weightx = 0.0;
            layout.setConstraints(this.breakpoint, c);
            this.add(this.breakpoint);
            c.gridwidth = 0;
            layout.setConstraints(this.error, c);
            this.add(this.error);
        }

        public void updateOperator(JTree tree, Operator operator, boolean selected, boolean focus) {
            this.isSelected = selected;
            this.hasFocus = focus;
            if (selected) {
                this.nameLabel.setForeground(TEXT_SELECTED_COLOR);
                this.classLabel.setForeground(TEXT_SELECTED_COLOR);
            } else {
                this.nameLabel.setForeground(TEXT_NON_SELECTED_COLOR);
                this.classLabel.setForeground(TEXT_NON_SELECTED_COLOR);
            }
            this.dndMarker = ((OperatorTree)tree).getOperatorTreeTransferHandler().getMarkerPosition(operator);
            OperatorDescription descr = operator.getOperatorDescription();
            ImageIcon icon = descr.getSmallIcon();
            if (icon != null) {
                this.iconLabel.setIcon(icon);
            } else {
                this.iconLabel.setIcon(null);
            }
            this.iconLabel.setEnabled(operator.isEnabled());
            this.nameLabel.setText(operator.getName());
            this.nameLabel.setEnabled(operator.isEnabled());
            this.classLabel.setText(descr.getName());
            this.classLabel.setEnabled(operator.isEnabled());
            if (operator.hasBreakpoint(0)) {
                this.breakpoint.setIcon(breakpointBeforeIcon);
            } else if (operator.hasBreakpoint(1)) {
                this.breakpoint.setIcon(breakpointAfterIcon);
            } else {
                this.breakpoint.setIcon(null);
            }
            if (operator.hasBreakpoint(0) && operator.hasBreakpoint(1)) {
                this.breakpoint.setIcon(breakpointsIcon);
            }
            this.breakpoint.setEnabled(operator.isEnabled());
            List<ProcessSetupError> errors = operator.getErrorList();
            if (errors.size() > 0) {
                this.error.setIcon(warningsIcon);
            } else {
                this.error.setIcon(null);
                String descriptionText = descr.getLongDescriptionHTML();
                if (descriptionText == null) {
                    descriptionText = descr.getShortDescription();
                }
            }
            this.error.setEnabled(operator.isEnabled());
            this.setEnabled(operator.isEnabled());
            this.setPreferredSize(new Dimension((int)(Math.max(this.nameLabel.getPreferredSize().getWidth(), this.classLabel.getPreferredSize().getWidth()) + 66.0), (int)(this.nameLabel.getPreferredSize().getHeight() + this.classLabel.getPreferredSize().getHeight() + 4.0)));
        }

        private void paintUpperDropline(Graphics graphics) {
            Graphics g = graphics.create();
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillRect(0, 0, this.getWidth() - 1, 2);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawRect(0, 0, this.getWidth() - 1, 2);
            g.translate(1, 3);
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillPolygon(this.upArrow);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawPolygon(this.upArrow);
            g.translate(this.getWidth() - 10, 0);
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillPolygon(this.upArrow);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawPolygon(this.upArrow);
            g.dispose();
        }

        private void paintLowerDropline(Graphics graphics) {
            Graphics g = graphics.create();
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillRect(0, this.getHeight() - 3, this.getWidth() - 1, 2);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawRect(0, this.getHeight() - 3, this.getWidth() - 1, 2);
            g.translate(1, this.getHeight() - 11);
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillPolygon(this.downArrow);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawPolygon(this.downArrow);
            g.translate(this.getWidth() - 10, 0);
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillPolygon(this.downArrow);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawPolygon(this.downArrow);
            g.dispose();
        }

        @Override
        public void paint(Graphics g) {
            if (this.isSelected) {
                g.setColor(SELECTED_COLOR);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.hasFocus) {
                g.setColor(BORDER_SELECTED_COLOR);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            switch (this.dndMarker) {
                case ABOVE: {
                    this.paintUpperDropline(g);
                    break;
                }
                case BELOW: {
                    this.paintLowerDropline(g);
                    break;
                }
                case INTO: {
                    g.setColor(BORDER_SELECTED_COLOR);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
            super.paint(g);
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        static {
            breakpointBeforeIcon = SwingTools.createIcon(BREAKPOINT_BEFORE);
            breakpointAfterIcon = SwingTools.createIcon(BREAKPOINT_AFTER);
            breakpointsIcon = SwingTools.createIcon(BREAKPOINTS);
            warningsIcon = SwingTools.createIcon(WARNINGS);
        }
    }
}

