/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.dnd.OperatorTreeTransferHandler;
import com.rapidminer.gui.operatortree.OperatorTreeCellEditor;
import com.rapidminer.gui.operatortree.OperatorTreeCellRenderer;
import com.rapidminer.gui.operatortree.ProcessTreeModel;
import com.rapidminer.gui.operatortree.actions.CollapseAllAction;
import com.rapidminer.gui.operatortree.actions.ExpandAllAction;
import com.rapidminer.gui.operatortree.actions.LockTreeStructureAction;
import com.rapidminer.gui.operatortree.actions.RenameOperatorAction;
import com.rapidminer.gui.operatortree.actions.ToggleShowDisabledItem;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.PrintingTools;
import com.rapidminer.gui.tools.components.ToolTipWindow;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.ProcessSetupError;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class OperatorTree
extends JTree
implements TreeSelectionListener,
TreeExpansionListener,
MouseListener,
ProcessEditor {
    private static final long serialVersionUID = -6934683725946634563L;
    public final Action RENAME_OPERATOR_ACTION = new RenameOperatorAction(this, IconSize.SMALL);
    public final ToggleShowDisabledItem TOGGLE_SHOW_DISABLED = new ToggleShowDisabledItem(this, true);
    public final transient Action EXPAND_ALL_ACTION = new ExpandAllAction(this, IconSize.SMALL);
    public final transient Action COLLAPSE_ALL_ACTION = new CollapseAllAction(this, IconSize.SMALL);
    public final transient LockTreeStructureAction TOGGLE_STRUCTURE_LOCK_ACTION = new LockTreeStructureAction(this, IconSize.SMALL);
    private final MainFrame mainFrame;
    private transient ProcessTreeModel treeModel;
    private boolean isStructureLocked = false;
    private final OperatorTreeTransferHandler transferHandler;

    public OperatorTree(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        mainFrame.getActions().TOGGLE_BREAKPOINT[1].addToActionMap(this, 0);
        mainFrame.getActions().TOGGLE_ACTIVATION_ITEM.addToActionMap(this, 0);
        this.setCellRenderer(new OperatorTreeCellRenderer());
        this.setCellEditor(new OperatorTreeCellEditor(this));
        this.setEditable(true);
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setRowHeight(0);
        this.setDragEnabled(true);
        this.transferHandler = new OperatorTreeTransferHandler(this);
        this.setTransferHandler(this.transferHandler);
        this.getSelectionModel().setSelectionMode(4);
        new ToolTipWindow(new ToolTipWindow.TipProvider(){

            @Override
            public String getTip(Object o) {
                Operator op;
                if (o instanceof Operator) {
                    op = (Operator)o;
                } else if (o instanceof ExecutionUnit) {
                    op = ((ExecutionUnit)o).getEnclosingOperator();
                } else {
                    return null;
                }
                StringBuilder b = new StringBuilder();
                b.append("<h3>").append(op.getOperatorDescription().getName()).append("</h3><p>");
                b.append(op.getOperatorDescription().getLongDescriptionHTML()).append("</p>");
                List<ProcessSetupError> errorList = op.getErrorList();
                if (!errorList.isEmpty()) {
                    b.append("<h4>Errors:</h4><ul>");
                    for (ProcessSetupError error : errorList) {
                        b.append("<li>").append(error.getMessage()).append("</li>");
                    }
                    b.append("</ul>");
                }
                return b.toString();
            }

            @Override
            public Object getIdUnder(Point point) {
                TreePath path = OperatorTree.this.getPathForLocation((int)point.getX(), (int)point.getY());
                if (path != null) {
                    return path.getLastPathComponent();
                }
                return null;
            }

            @Override
            public Component getCustomComponent(Object id) {
                return null;
            }
        }, this);
    }

    private void applyExpansionState(Operator operator) {
        if (operator.isExpanded()) {
            this.expandPath(this.treeModel.getPathTo(operator));
            if (operator instanceof OperatorChain) {
                OperatorChain chain = (OperatorChain)operator;
                if (chain.getNumberOfSubprocesses() == 1) {
                    for (Operator op : chain.getSubprocess(0).getOperators()) {
                        this.applyExpansionState(op);
                    }
                } else {
                    for (ExecutionUnit unit : chain.getSubprocesses()) {
                        if (!unit.isExpanded()) continue;
                        if (unit.isExpanded()) {
                            this.expandPath(this.treeModel.getPathTo(unit));
                            for (Operator op : unit.getOperators()) {
                                this.applyExpansionState(op);
                            }
                            continue;
                        }
                        this.collapsePath(this.treeModel.getPathTo(unit));
                    }
                }
            }
        } else {
            this.collapsePath(this.treeModel.getPathTo(operator));
        }
    }

    public List<Operator> getSelectedOperators() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        LinkedList<Operator> selection = new LinkedList<Operator>();
        for (TreePath path : paths) {
            Object selected = path.getLastPathComponent();
            if (selected instanceof Operator) {
                selection.add((Operator)selected);
                continue;
            }
            if (!(selected instanceof ExecutionUnit)) continue;
            selection.add(((ExecutionUnit)selected).getEnclosingOperator());
        }
        return selection;
    }

    public Object getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return path.getLastPathComponent();
    }

    public boolean isStructureLocked() {
        return this.isStructureLocked;
    }

    public void setStructureLocked(boolean locked) {
        this.isStructureLocked = locked;
        this.TOGGLE_STRUCTURE_LOCK_ACTION.updateIcon();
    }

    public void expandAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    public void collapseAll() {
        for (int row = this.getRowCount() - 1; row >= 0; --row) {
            this.collapseRow(row);
        }
    }

    public void renameOperator() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            this.startEditingAtPath(path);
        }
    }

    public void toggleShowDisabledOperators() {
        this.treeModel.setShowDisabledOperators(!this.treeModel.showDisabledOperators());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        List<Operator> selectedOperators;
        if (this.mainFrame != null && (selectedOperators = this.getSelectedOperators()) != null && !selectedOperators.isEmpty()) {
            this.mainFrame.selectOperators(selectedOperators);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int selRow = this.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1 && e.getClickCount() == 2) {
            this.evaluateDoubleClick(selRow, selPath);
            e.consume();
        }
        this.evaluatePopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    private void evaluateDoubleClick(int row, TreePath path) {
        for (Operator op : this.getSelectedOperators()) {
            if (op.hasBreakpoint()) {
                op.setBreakpoint(0, false);
                op.setBreakpoint(1, false);
                continue;
            }
            op.setBreakpoint(1, true);
        }
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createOperatorPopupMenu().show(this, e.getX(), e.getY());
            e.consume();
        }
    }

    private JPopupMenu createOperatorPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        this.mainFrame.getActions().addToOperatorPopupMenu(menu, this.RENAME_OPERATOR_ACTION);
        menu.addSeparator();
        menu.add(this.EXPAND_ALL_ACTION);
        menu.add(this.COLLAPSE_ALL_ACTION);
        menu.addSeparator();
        String name = "Tree";
        if (this.mainFrame.getProcess().getProcessLocation() != null) {
            name = this.mainFrame.getProcess().getProcessLocation().getShortName();
        }
        menu.add(PrintingTools.makeExportPrintMenu(this, name));
        return menu;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        Object last = event.getPath().getLastPathComponent();
        if (last instanceof Operator) {
            ((Operator)last).setExpanded(false);
        } else if (last instanceof ExecutionUnit) {
            ((ExecutionUnit)last).setExpanded(false);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        Object last = event.getPath().getLastPathComponent();
        if (last instanceof Operator) {
            ((Operator)last).setExpanded(true);
        } else if (last instanceof ExecutionUnit) {
            ((ExecutionUnit)last).setExpanded(true);
        }
    }

    @Override
    public void processChanged(Process process) {
        this.treeModel = new ProcessTreeModel(process.getRootOperator());
        this.setModel(this.treeModel);
        this.setRootVisible(true);
        this.applyExpansionState(process.getRootOperator());
    }

    @Override
    public void processUpdated(Process process) {
    }

    @Override
    public void setSelection(List<Operator> selection) {
        TreePath[] paths = new TreePath[selection.size()];
        int i = 0;
        for (Operator op : selection) {
            paths[i++] = this.treeModel.getPathTo(op);
        }
        this.setSelectionPaths(paths);
    }

    protected OperatorTreeTransferHandler getOperatorTreeTransferHandler() {
        return this.transferHandler;
    }
}

