/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatormenu;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.operatormenu.OperatorMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.tools.OperatorService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplaceOperatorMenu
extends OperatorMenu {
    private static final long serialVersionUID = -663404687013352042L;

    protected ReplaceOperatorMenu(boolean onlyChains) {
        super("replace_operator", onlyChains);
    }

    @Override
    public void performAction(OperatorDescription description) {
        try {
            Operator operator = OperatorService.createOperator(description);
            this.replace(operator);
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("cannot_instantiate", (Throwable)e, description.getName());
        }
    }

    private void replace(Operator operator) {
        List<Operator> selection = RapidMinerGUI.getMainFrame().getSelectedOperators();
        if (selection.isEmpty()) {
            return;
        }
        Operator selectedOperator = selection.get(0);
        ExecutionUnit parent = selectedOperator.getExecutionUnit();
        if (parent == null) {
            return;
        }
        HashMap<String, InputPort> inputPortMap = new HashMap<String, InputPort>();
        HashMap<String, OutputPort> outputPortMap = new HashMap<String, OutputPort>();
        for (OutputPort source : selectedOperator.getOutputPorts().getAllPorts()) {
            if (!source.isConnected()) continue;
            inputPortMap.put(source.getName(), source.getDestination());
        }
        for (InputPort sink : selectedOperator.getInputPorts().getAllPorts()) {
            if (!sink.isConnected()) continue;
            outputPortMap.put(sink.getName(), sink.getSource());
        }
        selectedOperator.getOutputPorts().disconnectAll();
        selectedOperator.getInputPorts().disconnectAll();
        int failedReconnects = 0;
        if (selectedOperator instanceof OperatorChain && operator instanceof OperatorChain) {
            OperatorChain oldChain = (OperatorChain)selectedOperator;
            OperatorChain newChain = (OperatorChain)operator;
            int numCommonSubprocesses = Math.min(oldChain.getNumberOfSubprocesses(), newChain.getNumberOfSubprocesses());
            for (int i = 0; i < numCommonSubprocesses; ++i) {
                ExecutionUnit oldSubprocess = oldChain.getSubprocess(i);
                ExecutionUnit newSubprocess = newChain.getSubprocess(i);
                failedReconnects += newSubprocess.stealOperatorsFrom(oldSubprocess);
            }
        }
        int oldPos = parent.getOperators().indexOf(selectedOperator);
        selectedOperator.remove();
        parent.addOperator(operator, oldPos);
        for (Map.Entry entry : inputPortMap.entrySet()) {
            OutputPort mySource = (OutputPort)operator.getOutputPorts().getPortByName((String)entry.getKey());
            if (mySource != null) {
                mySource.connectTo((InputPort)entry.getValue());
                continue;
            }
            ++failedReconnects;
        }
        operator.getOutputPorts().unlockPortExtenders();
        for (Map.Entry entry : outputPortMap.entrySet()) {
            InputPort mySink = (InputPort)operator.getInputPorts().getPortByName((String)entry.getKey());
            if (mySink != null) {
                ((OutputPort)entry.getValue()).connectTo(mySink);
                continue;
            }
            ++failedReconnects;
        }
        operator.getInputPorts().unlockPortExtenders();
        RapidMinerGUI.getMainFrame().selectOperator(operator.getParent());
        if (failedReconnects > 0) {
            SwingTools.showVerySimpleErrorMessage("op_replaced_failed_connections_restored", failedReconnects);
        }
    }
}

