/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatormenu;

import com.rapidminer.gui.operatormenu.NewOperatorMenu;
import com.rapidminer.gui.operatormenu.OperatorGroupMenu;
import com.rapidminer.gui.operatormenu.ReplaceOperatorMenu;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.OperatorService;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class OperatorMenu
extends ResourceMenu {
    private static final long serialVersionUID = 2685621612717488446L;
    public static final OperatorMenu NEW_OPERATOR_MENU = new NewOperatorMenu();
    public static final OperatorMenu REPLACE_OPERATOR_MENU = new ReplaceOperatorMenu(false);
    public static final OperatorMenu REPLACE_OPERATORCHAIN_MENU = new ReplaceOperatorMenu(true);

    protected OperatorMenu(String key, boolean onlyChains) {
        super(key);
        this.addMenu(OperatorService.getGroups(), this, onlyChains);
    }

    public void addMenu(GroupTree group, JMenu menu, boolean onlyChains) {
        for (GroupTree subGroup : group.getSubGroups()) {
            OperatorGroupMenu subMenu = new OperatorGroupMenu(subGroup.getName());
            this.addMenu(subGroup, subMenu, onlyChains);
            if (subMenu.getItemCount() <= 0 || "deprecated".equals(subGroup.getKey())) continue;
            menu.add(subMenu);
        }
        for (final OperatorDescription description : group.getOperatorDescriptions()) {
            if (onlyChains && !OperatorChain.class.isAssignableFrom(description.getOperatorClass())) continue;
            JMenuItem item = null;
            ImageIcon icon = description.getSmallIcon();
            item = icon == null ? new JMenuItem(description.getName()) : new JMenuItem(description.getName(), icon);
            String descriptionText = description.getLongDescriptionHTML();
            if (descriptionText == null) {
                descriptionText = description.getShortDescription();
            }
            StringBuffer toolTipText = new StringBuffer("<b>Description: </b>" + descriptionText);
            Operator operator = null;
            try {
                operator = description.createOperatorInstance();
            }
            catch (OperatorCreationException e1) {
                // empty catch block
            }
            item.setToolTipText(SwingTools.transformToolTipText(toolTipText.toString()));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OperatorMenu.this.performAction(description);
                }
            });
            if (description.getDeprecationInfo() != null || operator != null && operator.getOperatorDescription().getDeprecationInfo() != null) {
                item.setForeground(Color.LIGHT_GRAY);
            }
            menu.add(item);
        }
    }

    public abstract void performAction(OperatorDescription var1);
}

