/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.RapidLookTools;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class ToolBarUI
extends BasicToolBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new ToolBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    @Override
    protected Border createRolloverBorder() {
        return new EmptyBorder(3, 3, 3, 3);
    }

    @Override
    protected Border createNonRolloverBorder() {
        return new EmptyBorder(3, 3, 3, 3);
    }

    public Border createNonRolloverToggleBorder() {
        return new EmptyBorder(3, 3, 3, 3);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c.getParent() instanceof JFileChooser) {
            return;
        }
        super.paint(g, c);
    }

    @Override
    public boolean isRolloverBorders() {
        return true;
    }

    @Override
    protected MouseInputListener createDockingListener() {
        return new RapidLookDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point p) {
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            this.dragWindow.setOffset(p);
        }
    }

    protected class RapidLookDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedToolbarHandler;

        public RapidLookDockingListener(JToolBar t) {
            super(ToolBarUI.this, t);
            this.pressedToolbarHandler = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.pressedToolbarHandler = false;
            Rectangle bumpRect = new Rectangle();
            if (this.toolBar.getOrientation() == 0) {
                int x = RapidLookTools.isLeftToRight(this.toolBar) ? 0 : this.toolBar.getSize().width - 14;
                bumpRect.setBounds(x, 0, 14, this.toolBar.getSize().height);
            } else {
                bumpRect.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (bumpRect.contains(e.getPoint())) {
                this.pressedToolbarHandler = true;
                Point dragOffset = e.getPoint();
                if (!RapidLookTools.isLeftToRight(this.toolBar)) {
                    dragOffset.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                ToolBarUI.this.setDragOffset(dragOffset);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.pressedToolbarHandler) {
                super.mouseDragged(e);
            }
        }
    }
}

