/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.RapidLookTools;
import com.rapidminer.gui.look.ToggleButtonListener;
import com.rapidminer.gui.look.painters.CashedPainter;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class ToggleButtonUI
extends BasicToggleButtonUI {
    private static final ToggleButtonUI TOGGLE_BUTTON_UI = new ToggleButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return TOGGLE_BUTTON_UI;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton c, Rectangle textRect, String text) {
        super.paintText(g, c, textRect, text);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        boolean down = model.isArmed() && model.isPressed() || model.isSelected();
        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        g.setColor(b.getBackground());
        if (down) {
            this.paintButtonPressed(g, b);
        } else if (b.isContentAreaFilled()) {
            if (RapidLookTools.isToolbarButton(b)) {
                RapidLookTools.drawToolbarButton(g, c);
            } else {
                CashedPainter.drawButton(c, g);
            }
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
        CashedPainter.drawButtonBorder(c, g, this.getPropertyPrefix());
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        CashedPainter.drawButtonBorder(b, g, this.getPropertyPrefix());
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            if (RapidLookTools.isToolbarButton(b)) {
                RapidLookTools.drawToolbarButton(g, b);
            } else {
                CashedPainter.drawButton(b, g);
            }
        }
        this.setTextShiftOffset();
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ToggleButtonListener(b);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return new Dimension((int)super.getPreferredSize(c).getWidth() + 6, (int)super.getPreferredSize(c).getHeight() + 6);
        }
        return new Dimension((int)super.getPreferredSize(c).getWidth() + 10, (int)super.getPreferredSize(c).getHeight() + 6);
    }
}

