/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.RapidLookTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalRenderer;
    private TableHeaderRenderer mainRenderer;
    private int highlightedColumn = -1;
    private int pressedColumn = -1;

    public static ComponentUI createUI(JComponent h) {
        return new TableHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.originalRenderer = this.header.getDefaultRenderer();
        if (this.originalRenderer instanceof UIResource) {
            this.mainRenderer = new TableHeaderRenderer();
            this.mainRenderer.setHorizontalAlignment(0);
            this.header.setDefaultRenderer(this.mainRenderer);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof TableHeaderRenderer) {
            this.header.setDefaultRenderer(this.originalRenderer);
            this.mainRenderer = null;
        }
        super.uninstallUI(c);
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
    }

    private void updateRolloverColumn(Point p) {
        int col;
        if (this.header.getDraggedColumn() == null && this.header.contains(p) && (col = this.header.columnAtPoint(p)) != this.highlightedColumn) {
            this.highlightedColumn = col;
            this.header.repaint();
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new BasicTableHeaderUI.MouseInputHandler(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                TableHeaderUI.this.updateRolloverColumn(e.getPoint());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                TableHeaderUI.this.updateRolloverColumn(e.getPoint());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                TableHeaderUI.this.highlightedColumn = -1;
                TableHeaderUI.this.header.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (TableHeaderUI.this.header.contains(e.getPoint())) {
                    if (TableHeaderUI.this.header.getDraggedColumn() != null) {
                        TableHeaderUI.this.pressedColumn = TableHeaderUI.this.header.columnAtPoint(e.getPoint());
                    } else if (TableHeaderUI.this.header.getDraggedColumn() != null) {
                        TableHeaderUI.this.pressedColumn = TableHeaderUI.this.header.getColumnModel().getColumnIndex(TableHeaderUI.this.header.getDraggedColumn());
                    }
                }
                if (TableHeaderUI.this.header.getReorderingAllowed()) {
                    TableHeaderUI.this.highlightedColumn = -1;
                }
                TableHeaderUI.this.header.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                if (TableHeaderUI.this.header.contains(e.getPoint())) {
                    TableHeaderUI.this.pressedColumn = -1;
                }
                TableHeaderUI.this.updateRolloverColumn(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (TableHeaderUI.this.header.contains(e.getPoint())) {
                    TableHeaderUI.this.pressedColumn = -1;
                }
                TableHeaderUI.this.updateRolloverColumn(e.getPoint());
                TableHeaderUI.this.header.repaint();
            }
        };
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension((int)super.getPreferredSize(c).getWidth(), Math.max((int)super.getPreferredSize(c).getHeight(), 20));
    }

    private class TableHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private static final long serialVersionUID = -7300727448162015796L;
        private boolean rollOver;
        private boolean isPressed;

        private TableHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setFont(header.getFont());
            }
            boolean bl = this.rollOver = column == TableHeaderUI.this.highlightedColumn;
            this.isPressed = TableHeaderUI.this.header.getDraggedColumn() != null ? this.viewIndexForColumn(TableHeaderUI.this.header.getDraggedColumn()) == column || column == TableHeaderUI.this.pressedColumn : false;
            this.setText(value == null ? "" : value.toString());
            this.setBorder(null);
            return this;
        }

        @Override
        public Insets getInsets() {
            return new Insets(2, 4, 2, 4);
        }

        private int viewIndexForColumn(TableColumn aColumn) {
            TableColumnModel cm = TableHeaderUI.this.header.getColumnModel();
            for (int column = 0; column < cm.getColumnCount(); ++column) {
                if (cm.getColumn(column) != aColumn) continue;
                return column;
            }
            return -1;
        }

        @Override
        public void paint(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            if (this.isPressed) {
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[0]);
                g.drawLine(0, 0, w - 1, 0);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[1]);
                g.drawLine(0, 1, w - 1, 1);
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 2.0f, RapidLookTools.getColors().getTableHeaderColors()[2], 0.0f, h - 1, RapidLookTools.getColors().getTableHeaderColors()[3]));
                g2.fillRect(0, 2, w, h - 1);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[0]);
                g.drawLine(0, h - 1, w - 1, h - 1);
            } else {
                if (this.rollOver) {
                    g.setColor(RapidLookTools.getColors().getTableHeaderColors()[4]);
                    g.drawLine(0, 0, w - 1, 0);
                    g.setColor(RapidLookTools.getColors().getTableHeaderColors()[5]);
                    g.drawLine(0, h - 2, w - 1, h - 2);
                } else {
                    g.setColor(RapidLookTools.getColors().getTableHeaderColors()[6]);
                    g.drawLine(0, 0, w - 1, 0);
                    g.setColor(RapidLookTools.getColors().getTableHeaderColors()[7]);
                    g.drawLine(0, h - 2, w - 1, h - 2);
                }
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 1.0f, RapidLookTools.getColors().getTableHeaderColors()[8], 0.0f, h - 5, RapidLookTools.getColors().getTableHeaderColors()[9]));
                g2.fillRect(0, 1, w, h - 5);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[10]);
                g.drawLine(0, h - 5, w - 1, h - 5);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[11]);
                g.drawLine(0, h - 4, w - 1, h - 4);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[12]);
                g.drawLine(0, h - 3, w - 1, h - 3);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[13]);
                g.drawLine(0, h - 1, w - 1, h - 1);
            }
            super.paint(g);
        }
    }
}

