/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.ClipboardActionsPopup;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;

public class FormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    private ClipboardActionsPopup popup = null;
    private FormattedTextFieldPopupListener popupListener = new FormattedTextFieldPopupListener();
    private FormattedTextFieldFocusListener focusListener = new FormattedTextFieldFocusListener();

    public static ComponentUI createUI(JComponent c) {
        return new FormattedTextFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.getComponent().addFocusListener(this.focusListener);
        this.getComponent().addMouseListener(this.popupListener);
    }

    @Override
    protected void uninstallDefaults() {
        super.installDefaults();
        this.getComponent().removeFocusListener(this.focusListener);
        this.getComponent().removeMouseListener(this.popupListener);
        this.popup = null;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    private void showPopup(Point p) {
        if (!this.getComponent().isEnabled()) {
            return;
        }
        if (this.popup == null) {
            this.popup = new ClipboardActionsPopup(this.getComponent());
        }
        this.getComponent().requestFocus();
        this.popup.show(this.getComponent(), (int)p.getX(), (int)p.getY());
    }

    private class FormattedTextFieldPopupListener
    extends MouseAdapter {
        private FormattedTextFieldPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.evaluateClick(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.evaluateClick(e);
        }

        private void evaluateClick(MouseEvent e) {
            if (e.isPopupTrigger()) {
                FormattedTextFieldUI.this.showPopup(e.getPoint());
            }
        }
    }

    private static class FormattedTextFieldFocusListener
    implements FocusListener {
        private FormattedTextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ((JComponent)e.getSource()).repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ((JComponent)e.getSource()).repaint();
        }
    }
}

