/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.ButtonListener;
import com.rapidminer.gui.look.RapidLookTools;
import com.rapidminer.gui.look.painters.CashedPainter;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class ExtensionButtonUI
extends BasicButtonUI {
    private static final ExtensionButtonUI BUTTON_UI = new ExtensionButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return BUTTON_UI;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ButtonListener(b);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton c, Rectangle textRect, String text) {
        super.paintText(g, c, textRect, text);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        RapidLookTools.drawToolbarButton(g, c);
        b.setBackground(SwingTools.LIGHTEST_BLUE);
        super.paint(g, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(25, 25);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.isBorderPainted()) {
            CashedPainter.drawButtonBorder(b, g, this.getPropertyPrefix());
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }
}

