/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.RapidLookComboBoxEditor;
import com.rapidminer.gui.look.RapidLookListCellRenderer;
import com.rapidminer.gui.look.borders.Borders;
import com.rapidminer.gui.look.painters.CashedPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class ComboBoxUI
extends BasicComboBoxUI {
    private ComboBoxMouseListener comboBoxListener = new ComboBoxMouseListener();
    private ComboBoxPropertyListener changeListener = new ComboBoxPropertyListener();
    private boolean isDown = false;

    public static ComponentUI createUI(JComponent c) {
        return new ComboBoxUI();
    }

    @Override
    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        if (this.arrowButton != null) {
            this.comboBox.add(this.arrowButton);
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.listBox.setCellRenderer(new RapidLookListCellRenderer());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBox.addMouseListener(this.comboBoxListener);
        this.comboBox.addPropertyChangeListener(this.changeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.comboBox.removeMouseListener(this.comboBoxListener);
        this.comboBox.removePropertyChangeListener(this.changeListener);
        super.uninstallListeners();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        CashedPainter.drawComboBox(c, g, this.isDown);
        CashedPainter.drawComboBoxBorder(c, g, this.isDown, false);
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        c.setBackground(new Color(255, 255, 255, 0));
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    @Override
    protected JButton createArrowButton() {
        return null;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new RapidLookComboBoxEditor.UIResource();
    }

    @Override
    protected ComboPopup createPopup() {
        return new RapidLookComboPopup(this.comboBox);
    }

    private JComboBox getComboBox() {
        return this.comboBox;
    }

    protected void synchronizeEditorStatus(boolean enabled) {
        if (this.comboBox.getEditor() instanceof RapidLookComboBoxEditor) {
            ((RapidLookComboBoxEditor)this.comboBox.getEditor()).setEnable(enabled);
        }
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        return new Rectangle(5, 3, width - 25, height - 6);
    }

    private class ComboBoxMouseListener
    extends MouseAdapter {
        private ComboBoxMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ComboBoxUI.this.isDown = true;
            super.mousePressed(e);
            ComboBoxUI.this.getComboBox().repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            ComboBoxUI.this.getComboBox().repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            ComboBoxUI.this.getComboBox().repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ComboBoxUI.this.isDown = false;
            super.mouseExited(e);
            ComboBoxUI.this.getComboBox().repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ComboBoxUI.this.isDown = false;
            super.mouseReleased(e);
            ComboBoxUI.this.getComboBox().repaint();
        }
    }

    private class ComboBoxPropertyListener
    implements PropertyChangeListener {
        private ComboBoxPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                ComboBoxUI.this.synchronizeEditorStatus((Boolean)evt.getNewValue());
            }
        }
    }

    private class RapidLookComboPopup
    extends BasicComboPopup {
        private static final long serialVersionUID = 1389744017891652801L;

        public RapidLookComboPopup(JComboBox comboBox) {
            super(comboBox);
        }

        @Override
        protected void configureScroller() {
            this.scroller.setFocusable(false);
            this.scroller.getVerticalScrollBar().setFocusable(false);
            this.scroller.setBorder(null);
            this.scroller.setOpaque(false);
        }

        @Override
        protected void configurePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorderPainted(true);
            this.setBorder(Borders.getPopupBorder());
            this.setOpaque(false);
            this.add(this.scroller);
            this.setDoubleBuffered(true);
            this.setFocusable(false);
        }

        protected JList createList() {
            return new JList(this.comboBox.getModel()){
                private static final long serialVersionUID = -2467344849011408539L;

                @Override
                public void processMouseEvent(MouseEvent e) {
                    if (e.isControlDown()) {
                        e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ 2, e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                    }
                    super.processMouseEvent(e);
                }
            };
        }

        @Override
        protected void configureList() {
            super.configureList();
            this.list.setBackground(Color.white);
        }

        @Override
        public void delegateFocus(MouseEvent e) {
            super.delegateFocus(e);
        }

        @Override
        public void hide() {
            MenuElement[] selection;
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            for (MenuElement element : selection = manager.getSelectedPath()) {
                if (element != this) continue;
                manager.clearSelectedPath();
                break;
            }
            ComboBoxUI.this.isDown = false;
            this.comboBox.repaint();
        }

        @Override
        public void show() {
            this.setListSelection(this.comboBox.getSelectedIndex());
            Point location = this.getPopupLocation();
            this.show(this.comboBox, location.x + 3, location.y - 2);
        }

        private void setListSelection(int selectedIndex) {
            if (selectedIndex == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(selectedIndex);
                this.list.ensureIndexIsVisible(selectedIndex);
            }
        }

        private Point getPopupLocation() {
            Dimension popupSize = new Dimension((int)this.comboBox.getSize().getWidth() - 6, (int)this.comboBox.getSize().getHeight());
            Insets insets = this.getInsets();
            popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
            Dimension scrollSize = popupBounds.getSize();
            Point popupLocation = popupBounds.getLocation();
            this.scroller.setMaximumSize(scrollSize);
            this.scroller.setPreferredSize(scrollSize);
            this.scroller.setMinimumSize(scrollSize);
            this.list.revalidate();
            return popupLocation;
        }
    }
}

