/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.ButtonListener;
import com.rapidminer.gui.look.RapidLookTools;
import com.rapidminer.gui.look.painters.CashedPainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class ButtonUI
extends BasicButtonUI {
    private static final ButtonUI BUTTON_UI = new ButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return BUTTON_UI;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ButtonListener(b);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton c, Rectangle textRect, String text) {
        super.paintText(g, c, textRect, text);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (RapidLookTools.isToolbarButton(b)) {
            RapidLookTools.drawToolbarButton(g, c);
        }
        if (b.isContentAreaFilled()) {
            if (RapidLookTools.isToolbarButton(b)) {
                RapidLookTools.drawToolbarButton(g, c);
            } else {
                CashedPainter.drawButton(c, g);
            }
        }
        boolean paintBorder = true;
        if (c instanceof AbstractButton) {
            paintBorder = ((AbstractButton)c).isBorderPainted();
        }
        if (paintBorder) {
            CashedPainter.drawButtonBorder(c, g, this.getPropertyPrefix());
        }
        super.paint(g, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return new Dimension((int)super.getPreferredSize(c).getWidth() + 6, (int)super.getPreferredSize(c).getHeight() + 6);
        }
        return new Dimension((int)super.getPreferredSize(c).getWidth() + 10, (int)super.getPreferredSize(c).getHeight() + 6);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.isBorderPainted()) {
            CashedPainter.drawButtonBorder(b, g, this.getPropertyPrefix());
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }
}

