/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.painters;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

public class Cache {
    private int maxCount;
    private List<SoftReference<Entry>> entries;

    Cache(int maxCount) {
        this.maxCount = maxCount;
        this.entries = new ArrayList<SoftReference<Entry>>(maxCount);
    }

    void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(Object key, GraphicsConfiguration config, int w, int h, Object[] args) {
        Cache cache = this;
        synchronized (cache) {
            Entry entry;
            for (int counter = this.entries.size() - 1; counter >= 0; --counter) {
                entry = this.entries.get(counter).get();
                if (entry == null) {
                    this.entries.remove(counter);
                    continue;
                }
                if (!entry.equals(config, w, h, args)) continue;
                return entry;
            }
            entry = new Entry(config, w, h, args);
            if (this.entries.size() == this.maxCount) {
                this.entries.remove(0);
            }
            this.entries.add(new SoftReference<Entry>(entry));
            return entry;
        }
    }

    public Image getImage(Object key, GraphicsConfiguration config, int w, int h, Object[] args) {
        Entry entry = this.getEntry(key, config, w, h, args);
        return entry.getImage();
    }

    public void setImage(Object key, GraphicsConfiguration config, int w, int h, Object[] args, Image image) {
        Entry entry = this.getEntry(key, config, w, h, args);
        entry.setImage(image);
    }

    private static class Entry {
        private GraphicsConfiguration config;
        private Object[] args;
        private Image image;
        private int w;
        private int h;

        Entry(GraphicsConfiguration config, int w, int h, Object[] args) {
            this.config = config;
            this.args = args;
            this.w = w;
            this.h = h;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Image getImage() {
            return this.image;
        }

        public String toString() {
            StringBuffer value = new StringBuffer(super.toString() + "[ graphicsConfig=" + this.config + ", image=" + this.image + ", w=" + this.w + ", h=" + this.h);
            if (this.args != null) {
                for (Object element : this.args) {
                    value.append(", " + element);
                }
            }
            value.append("]");
            return value.toString();
        }

        public boolean equals(GraphicsConfiguration config, int w, int h, Object[] args) {
            if (this.w == w && this.h == h && (this.config != null && this.config.equals(config) || this.config == null && config == null)) {
                if (this.args == null && args == null) {
                    return true;
                }
                if (this.args != null && args != null && this.args.length == args.length) {
                    for (int counter = args.length - 1; counter >= 0; --counter) {
                        if (this.args[counter].equals(args[counter])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

