/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.RapidLookTools;
import com.rapidminer.gui.look.fc.DragSelectionThread;
import com.rapidminer.gui.look.fc.FileChooserUI;
import com.rapidminer.gui.look.fc.FileList;
import com.rapidminer.gui.look.fc.Item;
import com.rapidminer.gui.look.fc.ItemPanelKeyboardListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;

public class ItemPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -4300786583560333090L;
    private int visiblesCount = 0;
    private DragSelectionThread selectingThread;
    private int mpcy = 0;
    private int mpcx = 0;
    private int mpy = 0;
    private int mpx = 0;
    private int tx = 0;
    private int ty = 0;
    private boolean mouseDownFlag = false;
    private Item tempItem;
    private Rectangle selectionRect;
    protected FileList filePane;
    private boolean pointChanged = false;
    private Rectangle scrollRect = new Rectangle(0, 0, 0, 0);
    private JPopupMenu popup;
    private ItemPanelKeyboardListener keylistener = new ItemPanelKeyboardListener();
    private Enumeration en;
    private Item tc;
    private int totalColumn;
    private int maxWidth;

    public ItemPanel(FileList parent) {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this.keylistener);
        this.setLayout(null);
        this.filePane = parent;
        this.setBackground(Color.white);
        this.popup = this.filePane.getPanePopup();
        this.selectingThread = new DragSelectionThread(this, this.filePane);
    }

    public FileList getFilePane() {
        return this.filePane;
    }

    @Override
    public void paint(Graphics g) {
        this.determinePreferredSize();
        super.paint(g);
        if (this.filePane.fc.isMultiSelectionEnabled()) {
            if (this.pointChanged) {
                if (this.mpcx < 0) {
                    this.tx = this.mpcx + this.mpx;
                    this.mpcx *= -1;
                } else {
                    this.tx = this.mpx;
                }
                if (this.mpcy < 0) {
                    this.ty = this.mpcy + this.mpy;
                    this.mpcy *= -1;
                } else {
                    this.ty = this.mpy;
                }
                this.pointChanged = false;
            }
            this.selectionRect = new Rectangle(this.tx, this.ty, this.mpcx, this.mpcy);
            if (this.mouseDownFlag) {
                g.setColor(new Color(RapidLookTools.getColors().getFileChooserColors()[0].getRed(), RapidLookTools.getColors().getFileChooserColors()[0].getGreen(), RapidLookTools.getColors().getFileChooserColors()[0].getBlue(), 40));
                g.fillRect(this.tx, this.ty, this.mpcx, this.mpcy);
                g.setColor(RapidLookTools.getColors().getFileChooserColors()[0]);
                g.drawRect(this.tx, this.ty, this.mpcx, this.mpcy);
                this.updateSelectionsForDrag();
            }
        }
    }

    private void determinePreferredSize() {
        this.en = this.filePane.visibleItemsList.elements();
        int w = 0;
        int h = 0;
        while (this.en.hasMoreElements()) {
            this.tempItem = (Item)this.en.nextElement();
            if (this.tempItem.getX() + this.tempItem.getWidth() > w) {
                w = this.tempItem.getX() + this.tempItem.getWidth();
            }
            if (this.tempItem.getY() + this.tempItem.getHeight() <= h) continue;
            h = this.tempItem.getY() + this.tempItem.getHeight();
        }
        this.setPreferredSize(new Dimension(w + 20, h + 20));
        this.revalidate();
        this.setPreferredSize(new Dimension(w + 20, h + 20));
        this.setMinimumSize(new Dimension(w + 20, h + 20));
    }

    private void updateSelectionsForDrag() {
        this.selectingThread.startThread(this.selectionRect);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.filePane.clearSelectedItemsList();
        this.requestFocusInWindow();
        this.mpx = e.getX();
        this.mpy = e.getY();
        this.mouseDownFlag = true;
        this.evaluateClick(e);
    }

    private void evaluateClick(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resetPane();
        this.evaluateClick(e);
    }

    private void resetPane() {
        this.mouseDownFlag = false;
        this.mpcx = 0;
        this.mpcy = 0;
        this.mpx = 0;
        this.mpy = 0;
        this.tx = 0;
        this.ty = 0;
        this.repaint();
    }

    public void moveSelectedItems(int difX, int difY) {
        Enumeration<Object> en = this.filePane.selectedFilesVector.elements();
        while (en.hasMoreElements()) {
            this.tempItem = (Item)en.nextElement();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mpcx = e.getX() - this.mpx;
        this.mpcy = e.getY() - this.mpy;
        this.pointChanged = true;
        this.scrollRect = new Rectangle(e.getX(), e.getY(), 1, 1);
        this.scrollRectToVisible(this.scrollRect);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void selectedComponentMousePressed(MouseEvent e) {
        this.en = this.filePane.selectedFilesVector.elements();
        while (this.en.hasMoreElements()) {
            this.tempItem = (Item)this.en.nextElement();
            this.tempItem.componentMousePressed(e);
        }
    }

    public void selectedComponentMouseReleased(MouseEvent e) {
        this.en = this.filePane.selectedFilesVector.elements();
        while (this.en.hasMoreElements()) {
            this.tempItem = (Item)this.en.nextElement();
            this.tempItem.componentMouseReleased(e);
        }
        this.determinePreferredSize();
    }

    public void selectedComponentMouseDragged(Point point) {
        this.en = this.filePane.selectedFilesVector.elements();
        while (this.en.hasMoreElements()) {
            this.tempItem = (Item)this.en.nextElement();
            this.tempItem.componentMouseDragged(point);
        }
        this.scrollRectToVisible(this.filePane.lastSelected.getBounds());
    }

    protected void arrangeTheFiles() {
        this.arrangeTheFiles((int)((JComponent)this.getParent().getParent().getParent()).getSize().getWidth());
    }

    protected void arrangeTheFiles(int w) {
        this.en = this.filePane.visibleItemsList.elements();
        int counter = 0;
        if (this.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL)) {
            this.totalColumn = (w - 30) / 130;
            this.visiblesCount = 0;
            if (this.totalColumn < 1) {
                this.totalColumn = 1;
            }
            while (this.en.hasMoreElements()) {
                this.tc = (Item)this.en.nextElement();
                this.tc.setVisible(true);
                int r = counter / this.totalColumn;
                int c = counter % this.totalColumn;
                this.tc.setLocation(c * 130 + 30, r * 150 + 30);
                ++counter;
                ++this.visiblesCount;
            }
        } else if (this.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_ICON)) {
            this.totalColumn = (w - 30) / 90;
            this.visiblesCount = 0;
            if (this.totalColumn < 1) {
                this.totalColumn = 1;
            }
            while (this.en.hasMoreElements()) {
                this.tc = (Item)this.en.nextElement();
                int r = counter / this.totalColumn;
                int c = counter % this.totalColumn;
                this.tc.setLocation(c * 90 + 20, r * 100 + 20);
                ++counter;
                ++this.visiblesCount;
            }
        } else if (this.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_LIST)) {
            if (this.maxWidth == 0) {
                return;
            }
            this.visiblesCount = 0;
            this.totalColumn = (w - 30) / (this.maxWidth + 30);
            if (this.totalColumn < 1) {
                this.totalColumn = 1;
            }
            while (this.en.hasMoreElements()) {
                this.tc = (Item)this.en.nextElement();
                this.tc.setVisible(true);
                int r = counter / this.totalColumn;
                int c = counter % this.totalColumn;
                this.tc.setLocation(c * (this.maxWidth + 30) + (c + 1) * 10, r * 18 + 10);
                ++counter;
                ++this.visiblesCount;
            }
        }
        this.repaint();
    }

    public void findBestConfig(Item thumb) {
        int r = 0;
        int c = 0;
        int counter = this.filePane.visibleItemsList.size() - 1;
        if (this.filePane.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_LIST)) {
            this.updateForListView(thumb);
            if (this.totalColumn == 0) {
                this.totalColumn = 1;
            }
            r = counter / this.totalColumn;
            c = counter % this.totalColumn;
            thumb.setLocation(c * (this.maxWidth + 30) + (c + 1) * 10, r * 18 + 10);
        } else if (this.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_ICON)) {
            this.updateForIconView(thumb);
            r = counter / this.totalColumn;
            c = counter % this.totalColumn;
            thumb.setLocation(c * 90 + 20, r * 100 + 20);
        } else if (this.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL)) {
            this.updateForThumbnailView(thumb);
            r = counter / this.totalColumn;
            c = counter % this.totalColumn;
            thumb.setLocation(c * 130 + 30, r * 150 + 30);
        }
    }

    public void updateForViewAndArrange() {
        if (this.filePane.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL)) {
            this.en = this.filePane.visibleItemsList.elements();
            while (this.en.hasMoreElements()) {
                this.updateForThumbnailView((Item)this.en.nextElement());
            }
            this.filePane.updateThumbnail();
        } else if (this.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_ICON)) {
            this.en = this.filePane.visibleItemsList.elements();
            while (this.en.hasMoreElements()) {
                this.updateForIconView((Item)this.en.nextElement());
            }
        } else if (this.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_LIST)) {
            this.en = this.filePane.visibleItemsList.elements();
            while (this.en.hasMoreElements()) {
                this.updateForListView((Item)this.en.nextElement());
            }
            this.en = this.filePane.visibleItemsList.elements();
            this.maxWidth = 0;
            while (this.en.hasMoreElements()) {
                this.tc = (Item)this.en.nextElement();
                if (!(this.tc.imageLabel.getPreferredSize().getWidth() + (double)this.tc.nameLabel.getPreferredLineWidth() > (double)this.maxWidth)) continue;
                this.maxWidth = (int)(this.tc.imageLabel.getPreferredSize().getWidth() + (double)this.tc.nameLabel.getPreferredLineWidth());
            }
        }
        this.en = this.filePane.selectedFilesVector.elements();
        while (this.en.hasMoreElements()) {
            this.tempItem = (Item)this.en.nextElement();
            if (!this.filePane.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_LIST)) {
                this.tempItem.nameLabel.setMultiLine(true);
            }
            this.tempItem.updateSelectionMode(true);
        }
        this.arrangeTheFiles();
    }

    public void updateForListView(Item tc) {
        tc.nameLabel.setMultiLine(false);
        tc.setBestSize(tc.nameLabel.getPreferredLineWidth() + 25, 18);
        tc.setSize(tc.getBestSize());
        tc.setLayout(new BorderLayout());
        tc.remove(tc.imageLabel);
        tc.remove(tc.nameLabel);
        tc.setBorder(null);
        tc.imageLabel.setBorder(Item.emptyImageBorder);
        tc.nameLabel.setBorder(Item.emptyImageBorder);
        tc.nameLabel.setHorizontalAlignment(2);
        tc.add((Component)tc.imageLabel, "West");
        tc.add((Component)tc.nameLabel, "Center");
        tc.updateItemIcon();
    }

    private void updateForIconView(Item tc) {
        tc.setBestSize(80, 70);
        tc.setPreferredSize(tc.getBestSize());
        tc.setSize(tc.getBestSize());
        tc.nameLabel.setSize(80, tc.nameLabel.getPreferredLineHeight());
        tc.setLayout(new BorderLayout());
        tc.remove(tc.imageLabel);
        tc.remove(tc.nameLabel);
        tc.imageLabel.setBorder(Item.emptyImageBorder);
        tc.setBorder(Item.defaultThumbBorder);
        tc.nameLabel.setHorizontalAlignment(0);
        tc.imageLabel.setVerticalAlignment(0);
        tc.imageLabel.setHorizontalAlignment(0);
        tc.add((Component)tc.imageLabel, "Center");
        tc.add((Component)tc.nameLabel, "South");
        tc.setSelectionMode(false);
        tc.nameLabel.setMultiLine(false);
        tc.revalidate();
        tc.updateItemIcon();
    }

    private void updateForThumbnailView(Item tc) {
        tc.setBestSize(105, 105 + tc.nameLabel.getPreferredLineHeight());
        tc.setPreferredSize(tc.getBestSize());
        tc.setSize(tc.getBestSize());
        tc.nameLabel.setSize(105, tc.nameLabel.getPreferredLineHeight());
        tc.setLayout(new BorderLayout());
        tc.remove(tc.imageLabel);
        tc.remove(tc.nameLabel);
        tc.nameLabel.setHorizontalAlignment(0);
        tc.imageLabel.setVerticalAlignment(0);
        tc.imageLabel.setHorizontalAlignment(0);
        tc.imageLabel.setBorder(Item.grayImageBorder);
        tc.setBorder(Item.defaultThumbBorder);
        tc.add((Component)tc.imageLabel, "Center");
        tc.add((Component)tc.nameLabel, "South");
        tc.setSelectionMode(false);
        tc.nameLabel.setMultiLine(false);
        tc.revalidate();
        tc.updateItemIcon();
    }

    public void updateViewType() {
        this.updateForViewAndArrange();
    }

    public void useKeyMoves(String str, boolean isCtrl) {
        if (this.filePane.lastSelected == null || this.filePane.visibleItemsList.size() == 0) {
            return;
        }
        Item tempLast = this.filePane.lastSelected;
        Point center = new Point();
        Point mainCenter = this.filePane.lastSelected.getLocation();
        Item res = this.filePane.lastSelected;
        if (str.equals("HOME")) {
            this.filePane.updateFilechooserSelectedItems(this.filePane.visibleItemsList.elementAt(0), isCtrl);
        }
        if (str.equals("END")) {
            this.filePane.updateFilechooserSelectedItems(this.filePane.visibleItemsList.elementAt(this.filePane.visibleItemsList.size() - 1), isCtrl);
        }
        if (str.equals("SPACE")) {
            this.filePane.updateFilechooserSelectedItems(this.filePane.lastSelected, false);
        }
        if (str.equals("PAGE_UP")) {
            int n = this.filePane.visibleItemsList.indexOf(this.filePane.lastSelected);
            if (n < 0) {
                return;
            }
            tempLast = this.filePane.lastSelected;
            boolean flag = true;
            mainCenter = res.getLocation();
            tempLast = res;
            while (flag) {
                res = tempLast;
                mainCenter = tempLast.getLocation();
                this.en = this.filePane.visibleItemsList.elements();
                while (this.en.hasMoreElements()) {
                    this.tc = (Item)this.en.nextElement();
                    center = this.tc.getLocation();
                    if (!(mainCenter.getY() > center.getY()) || res.getLocation().distance(tempLast.getLocation()) != 0.0 && !(this.tc.getLocation().distance(tempLast.getLocation()) < res.getLocation().distance(tempLast.getLocation()))) continue;
                    res = this.tc;
                }
                if (((JViewport)this.getParent()).getViewRect().getHeight() < res.getLocation().distance(this.filePane.lastSelected.getLocation()) || tempLast.getFileName().equals(res.getFileName())) {
                    flag = false;
                    this.filePane.updateFilechooserSelectedItems(tempLast, isCtrl);
                    continue;
                }
                tempLast = res;
            }
        } else if (str.equals("PAGE_DOWN")) {
            int n = this.filePane.visibleItemsList.indexOf(this.filePane.lastSelected);
            if (n < 0) {
                return;
            }
            tempLast = this.filePane.lastSelected;
            boolean flag = true;
            mainCenter = res.getLocation();
            tempLast = res;
            while (flag) {
                res = tempLast;
                mainCenter = tempLast.getLocation();
                this.en = this.filePane.visibleItemsList.elements();
                while (this.en.hasMoreElements()) {
                    this.tc = (Item)this.en.nextElement();
                    center = this.tc.getLocation();
                    if (!(mainCenter.getY() < center.getY()) || res.getLocation().distance(tempLast.getLocation()) != 0.0 && !(this.tc.getLocation().distance(tempLast.getLocation()) < res.getLocation().distance(tempLast.getLocation()))) continue;
                    res = this.tc;
                }
                if (((JViewport)this.getParent()).getViewRect().getHeight() < res.getLocation().distance(this.filePane.lastSelected.getLocation()) || tempLast.getFileName().equals(res.getFileName())) {
                    flag = false;
                    this.filePane.updateFilechooserSelectedItems(tempLast, isCtrl);
                    this.scrollRectToVisible(this.filePane.lastSelected.getBounds());
                    continue;
                }
                tempLast = res;
            }
        } else if (str.equals("DOWN")) {
            this.en = this.filePane.visibleItemsList.elements();
            while (this.en.hasMoreElements()) {
                this.tc = (Item)this.en.nextElement();
                center = this.tc.getLocation();
                if (!(mainCenter.getY() < center.getY()) || res.getLocation().distance(this.filePane.lastSelected.getLocation()) != 0.0 && !(this.tc.getLocation().distance(this.filePane.lastSelected.getLocation()) < res.getLocation().distance(this.filePane.lastSelected.getLocation()))) continue;
                res = this.tc;
            }
            this.filePane.updateFilechooserSelectedItems(res, isCtrl);
        } else if (str.equals("UP")) {
            this.en = this.filePane.visibleItemsList.elements();
            while (this.en.hasMoreElements()) {
                this.tc = (Item)this.en.nextElement();
                center = this.tc.getLocation();
                if (!(mainCenter.getY() > center.getY()) || res.getLocation().distance(this.filePane.lastSelected.getLocation()) != 0.0 && !(this.tc.getLocation().distance(this.filePane.lastSelected.getLocation()) < res.getLocation().distance(this.filePane.lastSelected.getLocation()))) continue;
                res = this.tc;
            }
            this.filePane.updateFilechooserSelectedItems(res, isCtrl);
        } else if (str.equals("LEFT")) {
            this.en = this.filePane.visibleItemsList.elements();
            while (this.en.hasMoreElements()) {
                this.tc = (Item)this.en.nextElement();
                center = this.tc.getLocation();
                if (!(mainCenter.getX() > center.getX()) || res.getLocation().distance(this.filePane.lastSelected.getLocation()) != 0.0 && !(this.tc.getLocation().distance(this.filePane.lastSelected.getLocation()) < res.getLocation().distance(this.filePane.lastSelected.getLocation()))) continue;
                res = this.tc;
            }
            this.filePane.updateFilechooserSelectedItems(res, isCtrl);
        } else if (str.equals("RIGHT")) {
            this.en = this.filePane.visibleItemsList.elements();
            while (this.en.hasMoreElements()) {
                this.tc = (Item)this.en.nextElement();
                center = this.tc.getLocation();
                if (!(mainCenter.getX() < center.getX()) || res.getLocation().distance(this.filePane.lastSelected.getLocation()) != 0.0 && !(this.tc.getLocation().distance(this.filePane.lastSelected.getLocation()) < res.getLocation().distance(this.filePane.lastSelected.getLocation()))) continue;
                res = this.tc;
            }
            this.filePane.updateFilechooserSelectedItems(res, isCtrl);
        }
    }

    public String getCurrentView() {
        return this.filePane.filechooserUI.viewType;
    }

    public Vector getItemsList() {
        return this.filePane.visibleItemsList;
    }

    public void forwardToNearestFor(String pre) {
        int index = this.filePane.visibleItemsList.indexOf(this.filePane.lastSelected) + 1;
        for (int i = 0; i < this.filePane.visibleItemsList.size(); ++i) {
            if (index == this.filePane.visibleItemsList.size()) {
                index = 0;
            }
            if (this.filePane.visibleItemsList.elementAt(index).getFileName().toLowerCase().startsWith(pre)) {
                this.filePane.updateFilechooserSelectedItems(this.filePane.visibleItemsList.elementAt(index), false);
                break;
            }
            ++index;
        }
    }
}

