/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.look.fc.FileChooserUI;
import com.rapidminer.gui.look.fc.FileList;
import com.rapidminer.gui.look.fc.ItemPanel;
import com.rapidminer.gui.look.fc.MultipleLinesLabel;
import com.rapidminer.gui.look.fc.Tools;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ColorUIResource;

public class Item
extends JComponent
implements Comparable,
MouseListener {
    private static final long serialVersionUID = 2227494244271451068L;
    private final transient Action ADD_TO_BOOKMARKS_ACTION = new ResourceAction("file_chooser.add_to_bookmarks", new Object[0]){
        private static final long serialVersionUID = 6397058648283021931L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Item.this.getParentPane().getFilePane().addToBookmarks(Item.this.file);
        }
    };
    private final transient Action RENAME_ACTION = new ResourceAction("file_chooser.rename", new Object[0]){
        private static final long serialVersionUID = -415784022947681215L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Item.this.renameFile();
        }
    };
    private final transient Action SELECT_ACTION = new ResourceAction("file_chooser.select", new Object[0]){
        private static final long serialVersionUID = 2103094536883537758L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Item.this.getFileChooser().setSelectedFile(Item.this.getFile());
            Item.this.getParentPane().getFilePane().filechooserUI.getApproveSelectionAction().actionPerformed(null);
        }
    };
    private final transient Action DELETE_ACTION = new ResourceAction("file_chooser.delete", new Object[0]){
        private static final long serialVersionUID = 435288965907486522L;

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean res = false;
            String itemString = (Item.this.isDirectory() ? "directory" : "file") + " " + Item.this.getItemName();
            int resInt = SwingTools.showConfirmDialog("file_chooser.delete", 1, itemString);
            if (resInt == 0) {
                try {
                    res = Item.this.delete();
                }
                catch (Exception exp) {
                    // empty catch block
                }
                if (!res) {
                    SwingTools.showVerySimpleErrorMessage("file_chooser.delete.error", itemString);
                } else {
                    Item.this.getParentPane().getFilePane().rescanDirectory();
                }
            }
        }
    };
    private final transient Action OPEN_ACTION = new ResourceAction("file_chooser.open", new Object[0]){
        private static final long serialVersionUID = -5651411399479644689L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ((Item)Item.this).parentPane.filePane.filechooserUI.setCurrentDirectoryOfFileChooser(Item.this.getFile());
        }
    };
    private ItemMouseMotionAdapter motionListener = new ItemMouseMotionAdapter();
    protected MultipleLinesLabel nameLabel = new MultipleLinesLabel("");
    protected JLabel imageLabel = new JLabel("");
    private ItemPanel parentPane;
    private int tx;
    private int ty;
    private String fileName = "";
    private long fileSize = 0L;
    private long lastModification;
    private File file;
    private boolean isDirectory = false;
    private boolean isFloppyDrive = false;
    private boolean isDrive = false;
    private JMenuItem addToBookmarksMenuItem;
    private static Border selectedThumbBorder;
    public static Border grayImageBorder;
    public static Border emptyImageBorder;
    public static Border defaultThumbBorder;
    private JPopupMenu popup;
    private JMenuItem pasteMenuItem;
    private String response;
    private String compareType = FileList.ORDER_BY_FILE_NAME;
    private ImageIcon thumbIcon;
    private ImageIcon bigSystemIcon;
    private ImageIcon smallSystemIcon;
    private String fileType;
    private FileSystemView fileSystemView;
    private Point initPosition;
    private boolean selectionStatus = false;
    private Dimension bestSize = new Dimension(10, 10);
    public static Font menuFont;

    public static void updateVirtualItemForTheme(Colors currentTheme) {
        selectedThumbBorder = currentTheme == null ? BorderFactory.createLineBorder(new ColorUIResource(122, 170, 233), 2) : BorderFactory.createLineBorder(currentTheme.getFileChooserColors()[1], 2);
    }

    public void setBestSize(int w, int h) {
        this.bestSize = new Dimension(w, h);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public Dimension getBestSize() {
        return this.bestSize;
    }

    public void setCompare_type(String compare_type) {
        this.compareType = compare_type;
    }

    public ItemPanel getParentPane() {
        return this.parentPane;
    }

    public File getFile() {
        return this.file;
    }

    public long getLastModificationTime() {
        if (this.fileSystemView.isFloppyDrive(this.file)) {
            return 0L;
        }
        if (this.lastModification == 0L) {
            this.lastModification = this.file.lastModified();
        }
        return this.lastModification;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        if (this.fileSystemView.isFloppyDrive(this.file) || this.file.isDirectory()) {
            return 0L;
        }
        if (this.fileSize == 0L) {
            this.fileSize = this.file.length();
        }
        return this.fileSize;
    }

    public String getCompareType() {
        return this.compareType;
    }

    public Item(ItemPanel parent, File f) {
        if (selectedThumbBorder == null) {
            Item.updateVirtualItemForTheme(null);
        }
        try {
            this.fileSystemView = parent.getFilePane().getFSV();
            this.file = f;
            this.parentPane = parent;
            this.getFileData();
            this.addListeners();
            this.setOpaque(false);
            this.setBorder(defaultThumbBorder);
            this.setFocusable(true);
            this.imageLabel.setFocusable(false);
            this.nameLabel.setFocusable(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getFileData() {
        this.fileName = this.fileSystemView.getSystemDisplayName(this.file);
        try {
            this.isDirectory = this.file.isDirectory();
        }
        catch (Exception exp) {
            this.isDirectory = false;
        }
        try {
            this.isFloppyDrive = this.fileSystemView.isFloppyDrive(this.file);
        }
        catch (Exception exp) {
            this.isFloppyDrive = false;
        }
        try {
            this.isDrive = this.fileSystemView.isDrive(this.file);
        }
        catch (Exception exp) {
            this.isDrive = false;
        }
        this.nameLabel.setText(this.fileName);
        this.setToolTipText("");
        this.fileType = this.isDirectory && !this.isDrive ? "File Folder" : this.parentPane.getFilePane().cachSystemDetails(this.file, this.fileName)[1].toString();
        if (this.isFloppyDrive) {
            this.getFloppyData();
        }
    }

    public void finalizeAll() {
        try {
            this.smallSystemIcon = null;
            this.bigSystemIcon = null;
            this.imageLabel.setIcon(null);
            this.thumbIcon = null;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this.motionListener);
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setImageIcon(ImageIcon pic) {
        this.thumbIcon = pic;
        this.imageLabel.setIcon(this.thumbIcon);
    }

    void addListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this.motionListener);
    }

    public void componentMouseDragged(Point point) {
        this.setLocation((int)((double)this.getX() + point.getX() - (double)this.tx), (int)((double)this.getY() + point.getY() - (double)this.ty));
        if (this.getX() > this.getParentPane().getWidth()) {
            this.getParentPane().setSize(this.getParentPane().getWidth() + 20, this.getParentPane().getHeight());
            this.getParentPane().repaint();
        }
        if (this.getY() > this.getParentPane().getHeight()) {
            this.getParentPane().setSize(this.getParentPane().getWidth(), this.getParentPane().getHeight() + 20);
            this.getParentPane().repaint();
        }
    }

    public void componentMousePressed(MouseEvent e) {
        this.tx = e.getX();
        this.ty = e.getY();
        this.initPosition = this.getLocation();
    }

    public void componentMouseReleased(MouseEvent e) {
        if (!this.parentPane.getFilePane().isAutoArrange()) {
            return;
        }
        this.setLocation(this.initPosition);
    }

    public String getItemName() {
        return this.fileName;
    }

    public long getItemFileSize() {
        return this.fileSize;
    }

    public long getItemFileLastModified() {
        return this.lastModification;
    }

    public void updateSelectionMode(boolean isSelected) {
        if (isSelected == this.selectionStatus) {
            return;
        }
        this.selectionStatus = isSelected;
        if (isSelected) {
            if (this.parentPane.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL) || this.parentPane.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_ICON)) {
                this.setBorder(selectedThumbBorder);
                this.nameLabel.setMultiLine(true);
                this.setSize((int)this.bestSize.getWidth(), (int)this.bestSize.getHeight() + this.nameLabel.getLineDiff());
            }
            this.nameLabel.setOpaque(true);
            this.nameLabel.setNeed_update(true);
            this.nameLabel.setForeground(UIManager.getColor("textHighlightText"));
        } else {
            if (this.parentPane.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL) || this.parentPane.filePane.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_ICON)) {
                this.setBorder(defaultThumbBorder);
            }
            this.setSize((int)this.bestSize.getWidth(), (int)this.bestSize.getHeight());
            this.nameLabel.setMultiLine(false);
            this.nameLabel.setOpaque(false);
            this.nameLabel.setForeground(UIManager.getColor("textText"));
        }
        this.repaint();
    }

    public JPopupMenu getPopupMenu() {
        this.getAdditionalFileData();
        this.createPopupMenu();
        return this.popup;
    }

    public void setAddToBookmarksMenuItemStatus(boolean val) {
        if (this.addToBookmarksMenuItem != null) {
            this.addToBookmarksMenuItem.setVisible(val);
        }
    }

    public void createPopupMenu() {
        if (this.popup != null) {
            return;
        }
        this.popup = new JPopupMenu();
        if (this.isDirectory) {
            JMenuItem menuItem = new JMenuItem(this.OPEN_ACTION);
            this.popup.add(menuItem);
            if (this.getFileChooser().isDirectorySelectionEnabled()) {
                menuItem = new JMenuItem(this.SELECT_ACTION);
                menuItem.setFont(menuFont);
                this.popup.add(menuItem);
            }
            this.popup.addSeparator();
            this.addToBookmarksMenuItem = new JMenuItem(this.ADD_TO_BOOKMARKS_ACTION);
            this.addToBookmarksMenuItem.setFont(menuFont);
            if (!new File(this.file.getAbsolutePath()).exists()) {
                this.addToBookmarksMenuItem.setEnabled(false);
            }
            this.popup.add(this.addToBookmarksMenuItem);
            this.popup.getComponent();
            menuItem = new JMenuItem(this.RENAME_ACTION);
            this.popup.add(menuItem);
            menuItem = new JMenuItem(this.DELETE_ACTION);
            this.popup.add(menuItem);
        } else {
            JMenuItem menuItem = new JMenuItem(this.SELECT_ACTION);
            this.popup.add(menuItem);
            this.popup.addSeparator();
            menuItem = new JMenuItem(this.RENAME_ACTION);
            this.popup.add(menuItem);
            menuItem = new JMenuItem(this.DELETE_ACTION);
            this.popup.add(menuItem);
        }
    }

    private void renameFile() {
        this.response = SwingTools.showInputDialog("file_chooser.rename", this.fileName, (this.isDirectory() ? "directory" : "file") + " " + this.fileName);
        try {
            if (this.response.equals("") || this.response == null) {
                SwingTools.showVerySimpleErrorMessage("file_chooser.rename.invalid", new Object[0]);
            } else if (this.file.renameTo(new File(this.file.getParentFile(), this.response))) {
                this.file = new File(this.file.getParentFile(), this.response);
                this.getFileData();
                this.parentPane.filePane.rescanDirectory();
                this.repaint();
            } else {
                SwingTools.showVerySimpleErrorMessage("file_chooser.rename.error", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPasteMenuItemStatus(boolean state) {
        if (this.isDirectory && this.pasteMenuItem != null) {
            this.pasteMenuItem.setEnabled(state);
        }
    }

    public String convertToCorrectFormat(long f) {
        if (this.isDirectory) {
            return "";
        }
        if ((f /= 1024L) < 1024L) {
            return (f == 0L ? 1L : f) + " KB";
        }
        if ((f /= 1024L) < 1024L) {
            return f + " MB";
        }
        return (f /= 1024L) + " GB";
    }

    public int compareTo(Object o) {
        Item other = (Item)o;
        int res = 0;
        boolean isFirstDir = this.getFile().isDirectory();
        boolean isSecondDir = other.getFile().isDirectory();
        if (isFirstDir && !isSecondDir) {
            res = -1;
        } else if (!isFirstDir && isSecondDir) {
            res = 1;
        } else if (this.compareType.equals(FileList.ORDER_BY_FILE_NAME)) {
            res = this.getFileName().toLowerCase().compareTo(other.getFileName().toLowerCase());
        } else if (this.compareType.equals(FileList.ORDER_BY_FILE_SIZE)) {
            res = Long.valueOf(this.getFileSize()).compareTo(other.getFileSize());
        } else if (this.compareType.equals(FileList.ORDER_BY_FILE_MODIFIED)) {
            res = Long.valueOf(this.getLastModificationTime()).compareTo(other.getLastModificationTime());
        } else if (this.compareType.equals(FileList.ORDER_BY_FILE_TYPE)) {
            res = this.getFileType().compareTo(other.getFileType());
        }
        if (res == 0) {
            res = -1;
        }
        return res;
    }

    private boolean delete() {
        return this.delete(this.getFile());
    }

    private boolean delete(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            boolean result = true;
            for (File child : children) {
                result &= this.delete(child);
            }
            return result && file.delete();
        }
        return file.delete();
    }

    public void updateThumbnail() {
        if (this.isImage()) {
            this.imageLabel.setIcon(this.getThumbnailIcon());
        }
    }

    public void updateItemIcon() {
        if (this.parentPane.filePane.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL) || this.parentPane.filePane.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_ICON)) {
            this.imageLabel.setIcon(this.getBigSystemIcon());
        } else if (this.parentPane.filePane.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_LIST) || this.parentPane.filePane.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_DETAILS)) {
            this.imageLabel.setIcon(this.getSmallSystemIcon());
        }
    }

    private ImageIcon getThumbnailIcon() {
        if (this.thumbIcon == null) {
            if (this.isDirectory) {
                this.thumbIcon = this.getBigSystemIcon();
            } else {
                try {
                    this.thumbIcon = new ImageIcon(Tools.getScaledInstance(this.file));
                    if (this.thumbIcon == null) {
                        this.thumbIcon = this.getBigSystemIcon();
                    }
                }
                catch (Exception ex) {
                    this.thumbIcon = this.getBigSystemIcon();
                }
            }
        }
        return this.thumbIcon;
    }

    public ImageIcon getSmallSystemIcon() {
        if (this.smallSystemIcon == null) {
            try {
                this.smallSystemIcon = this.parentPane.getFilePane().getSystemIcon(this.file, this.fileName, this.isDirectory, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.smallSystemIcon;
    }

    private ImageIcon getBigSystemIcon() {
        if (this.bigSystemIcon == null) {
            try {
                this.bigSystemIcon = this.parentPane.getFilePane().getSystemIcon(this.file, this.fileName, this.isDirectory, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.bigSystemIcon;
    }

    public String getFileType() {
        return this.fileType;
    }

    private boolean isImage() {
        String file_original_name = this.file.getName().toLowerCase();
        return file_original_name.endsWith("jpeg") || file_original_name.endsWith("jpg") || file_original_name.endsWith("png") || file_original_name.endsWith("gif") || file_original_name.endsWith("bmp") || file_original_name.endsWith("tif") || file_original_name.endsWith("tiff") || file_original_name.endsWith("png");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (this.isDirectory) {
                this.updateChooserPath();
            } else {
                this.parentPane.filePane.fc.setSelectedFile(this.getFile());
                this.getParentPane().getFilePane().filechooserUI.getApproveSelectionAction().actionPerformed(null);
            }
        }
    }

    protected void updateChooserPath() {
        this.parentPane.filePane.filechooserUI.setCurrentDirectoryOfFileChooser(this.file);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.getAdditionalFileData();
    }

    private void getFloppyData() {
        this.fileSize = 0L;
        this.lastModification = 0L;
        this.setToolTipText("<html><body><strong>" + this.fileName + "</strong><br>" + "Last modified : " + DateFormat.getDateInstance().format(new Date(this.lastModification)) + "<br>" + (this.isDirectory ? "" : "File size : " + this.convertToCorrectFormat(this.fileSize) + "<br>") + "File Description : " + this.fileType + "</body></html>");
    }

    protected void getAdditionalFileData() {
        if (this.getToolTipText().equals("")) {
            if (this.isFloppyDrive) {
                this.fileSize = 0L;
                this.lastModification = 0L;
            } else {
                this.fileSize = this.file.length();
                this.lastModification = this.file.lastModified();
            }
            if (new File(this.file.getAbsolutePath()).exists()) {
                this.setToolTipText("<html><body><strong>" + this.fileName + "</strong><br>" + "Last modified : " + DateFormat.getDateInstance().format(new Date(this.lastModification)) + "<br>" + (this.isDirectory ? "" : "File size : " + this.convertToCorrectFormat(this.fileSize) + "<br>") + "File Description : " + this.fileType + "<br>" + this.file.getPath() + "</body></html>");
            } else {
                this.setToolTipText("<html><body><strong>" + this.fileName + "</strong>" + "</body></html>");
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.processEvent(e);
        this.getParentPane().selectedComponentMousePressed(e);
        this.evaluateClick(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.getParentPane().selectedComponentMouseReleased(e);
        this.evaluateClick(e);
    }

    private void evaluateClick(MouseEvent e) {
        if (e.isPopupTrigger()) {
            try {
                this.createPopupMenu();
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setSelectionMode(boolean b) {
        this.selectionStatus = b;
    }

    public boolean getSelectionMode() {
        return this.selectionStatus;
    }

    private void processEvent(MouseEvent e) {
        this.getParentPane().getFilePane().updateFilechooserSelectedItems(this, e.isControlDown());
    }

    private JFileChooser getFileChooser() {
        return this.getParentPane().getFilePane().fc;
    }

    static {
        grayImageBorder = BorderFactory.createLineBorder(Color.lightGray);
        emptyImageBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        defaultThumbBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        menuFont = new Font("SansSerif", 0, 12);
    }

    private class ItemMouseMotionAdapter
    extends MouseMotionAdapter {
        private ItemMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Item.this.requestFocusInWindow();
            if (Item.this.getSelectionMode()) {
                Item.this.getParentPane().selectedComponentMouseDragged(e.getPoint());
            }
        }
    }
}

