/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.RapidLookTools;
import com.rapidminer.gui.look.fc.FileList;
import com.rapidminer.gui.look.fc.FileTableLabel;
import com.rapidminer.gui.look.fc.Item;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FileTable
extends JTable
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -8700859510439797254L;
    private boolean mouseDownFlag = false;
    private boolean pointChanged = false;
    private int mpx;
    private int mpy;
    private int mpcx;
    private int mpcy;
    private int tx;
    private int ty;
    private Rectangle selectionRect;
    private Rectangle scrollRect;
    private JPopupMenu panePopup;
    private JPopupMenu headerPopup;
    private JMenuItem menuItem = new JMenuItem();
    private int row;
    private int column;
    private int counter;
    private FileList fileList;
    private DefaultTableModel model;
    private Vector<Comparable> columnNames = new Vector();
    private Vector<Integer> originalColumsWidth = new Vector();
    private TableHeaderMouseListener tableHeaderListener = new TableHeaderMouseListener();
    private TableKeyListener tablekeylistener = new TableKeyListener();
    private Item tempItem;
    private int mainColumnIndex;
    private Enumeration en;
    private HeaderActionListener hal = new HeaderActionListener();
    private boolean mouseDragging = false;
    protected int[] columnsWidth;

    public FileTable(FileList chooser) {
        this.fileList = chooser;
        this.init();
    }

    public int getHeaderHeight() {
        return (int)this.tableHeader.getHeaderRect(0).getHeight();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        this.row = this.rowAtPoint(event.getPoint());
        this.column = this.columnAtPoint(event.getPoint());
        if (this.column == this.mainColumnIndex && this.row > -1) {
            this.fileList.visibleItemsList.elementAt(this.row).getAdditionalFileData();
            return String.valueOf(this.fileList.visibleItemsList.elementAt(this.row).getToolTipText());
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    private void init() {
        this.model = (DefaultTableModel)this.getModel();
        this.columnNames.removeAllElements();
        this.columnNames.add((Comparable)((Object)"File Name"));
        this.columnNames.add((Comparable)((Object)"Size"));
        this.columnNames.add((Comparable)((Object)"Type"));
        this.columnNames.add((Comparable)((Object)"Last Modified"));
        this.originalColumsWidth.add(0);
        this.originalColumsWidth.add(0);
        this.originalColumsWidth.add(0);
        this.originalColumsWidth.add(0);
        this.setBackground(Color.white);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setSelectionBackground(Color.white);
        this.setFont(Item.menuFont);
        this.setRowHeight(Math.max(this.getFont().getSize(), 18) + 2);
        this.getTableHeader().setPreferredSize(new Dimension(20, 20));
        this.getTableHeader().setSize(new Dimension(20, 20));
        this.createPopupMenu();
        this.getTableHeader().addMouseListener(this.tableHeaderListener);
        this.getTableHeader().addMouseMotionListener(this.tableHeaderListener);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this.tablekeylistener);
        this.setSelectionMode(2);
        this.setCellSelectionEnabled(true);
        this.clearSelection();
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
    }

    private void createPopupMenu() {
        this.panePopup = this.fileList.getPanePopup();
        this.headerPopup = new JPopupMenu();
        String col = "";
        this.en = this.columnNames.elements();
        while (this.en.hasMoreElements()) {
            col = this.en.nextElement().toString();
            this.menuItem = new JCheckBoxMenuItem(col);
            this.menuItem.setSelected(true);
            this.menuItem.addActionListener(this.hal);
            this.headerPopup.add(this.menuItem);
        }
    }

    private void synchFilechooser() {
        this.fileList.selectedFilesVector.removeAllElements();
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.tempItem = this.fileList.visibleItemsList.elementAt(i);
            if (this.getSelectionModel().isSelectedIndex(i)) {
                this.tempItem.updateSelectionMode(true);
                this.fileList.selectedFilesVector.add(this.tempItem);
                continue;
            }
            this.tempItem.updateSelectionMode(false);
            if (!this.fileList.selectedFilesVector.contains(this.tempItem)) continue;
            this.fileList.selectedFilesVector.remove(this.tempItem);
        }
        this.fileList.synchFilechoserSelection();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.fileList.fc.isMultiSelectionEnabled()) {
            if (this.pointChanged) {
                if (this.mpcx < 0) {
                    this.tx = this.mpcx + this.mpx;
                    this.mpcx *= -1;
                } else {
                    this.tx = this.mpx;
                }
                if (this.mpcy < 0) {
                    this.ty = this.mpcy + this.mpy;
                    this.mpcy *= -1;
                } else {
                    this.ty = this.mpy;
                }
                this.selectionRect = new Rectangle(this.tx, this.ty, this.mpcx, this.mpcy);
                this.testFor(this.selectionRect);
                this.pointChanged = false;
            }
            if (this.mouseDownFlag) {
                g.setColor(new Color(RapidLookTools.getColors().getFileChooserColors()[0].getRed(), RapidLookTools.getColors().getFileChooserColors()[0].getGreen(), RapidLookTools.getColors().getFileChooserColors()[0].getBlue(), 40));
                g.fillRect(this.tx, this.ty, this.mpcx, this.mpcy);
                g.setColor(RapidLookTools.getColors().getFileChooserColors()[0]);
                g.drawRect(this.tx, this.ty, this.mpcx, this.mpcy);
            }
        }
    }

    private void testFor(Rectangle rect) {
        this.clearSelection();
        int x = (int)this.tableHeader.getHeaderRect(this.mainColumnIndex).getX();
        int y = 0;
        ++this.counter;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Dimension d;
            y = (i - 1) * this.getRowHeight() + this.getHeaderHeight();
            Rectangle r = new Rectangle(x, y, Math.min((int)(d = ((FileTableLabel)this.getValueAt(i, this.mainColumnIndex)).getPreferredSize()).getWidth(), this.getColumnModel().getColumn(this.mainColumnIndex).getWidth()), this.getRowHeight(i));
            if (r.intersects(rect)) {
                if (this.getSelectionModel().isSelectedIndex(i)) continue;
                this.updateSelectionInterval(i, true);
                continue;
            }
            if (this.getSelectionModel().isSelectedIndex(i)) continue;
            this.getSelectionModel().removeIndexInterval(i, i);
        }
        this.synchFilechooser();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mpcx = e.getX() - this.mpx;
        this.mpcy = e.getY() - this.mpy;
        this.pointChanged = true;
        this.mouseDragging = true;
        this.scrollRect = new Rectangle(e.getX(), e.getY(), 1, 1);
        this.scrollRectToVisible(this.scrollRect);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void resetPane() {
        this.mouseDownFlag = false;
        this.mpcx = 0;
        this.mpcy = 0;
        this.mpx = 0;
        this.mpy = 0;
        this.tx = 0;
        this.ty = 0;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.synchFilechooser();
        if (e.getClickCount() == 2 && !(e.getSource() instanceof JTableHeader)) {
            this.row = ((JTable)e.getComponent()).rowAtPoint(e.getPoint());
            this.column = ((JTable)e.getComponent()).columnAtPoint(e.getPoint());
            if (this.getColumnName(this.column).equals(this.getColumnName(this.mainColumnIndex)) && this.row > -1) {
                this.tempItem = this.fileList.visibleItemsList.elementAt(this.row);
                if (this.tempItem.isDirectory()) {
                    this.fileList.filechooserUI.setCurrentDirectoryOfFileChooser(this.tempItem.getFile());
                } else {
                    this.fileList.fc.setSelectedFile(this.tempItem.getFile());
                    this.fileList.filechooserUI.getApproveSelectionAction().actionPerformed(null);
                }
            }
        }
    }

    private void doActionPerformed() {
        if (this.fileList.selectedFilesVector.contains(this.fileList.lastSelected)) {
            this.tempItem = this.fileList.lastSelected;
            if (this.tempItem.isDirectory()) {
                this.fileList.filechooserUI.setCurrentDirectoryOfFileChooser(this.tempItem.getFile());
            } else {
                this.fileList.fc.setSelectedFile(this.tempItem.getFile());
                this.fileList.filechooserUI.getApproveSelectionAction().actionPerformed(null);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mpx = e.getX();
        this.mpy = e.getY();
        this.mouseDownFlag = true;
        this.evaluateClick(e);
        if (e.getSource() instanceof JTable && !this.mouseDragging) {
            Dimension d;
            this.row = ((JTable)e.getComponent()).rowAtPoint(e.getPoint());
            this.column = ((JTable)e.getComponent()).columnAtPoint(e.getPoint());
            if (this.row < 0) {
                return;
            }
            int x = (int)this.tableHeader.getHeaderRect(this.mainColumnIndex).getX();
            int y = 0;
            ++this.counter;
            y = (this.row - 1) * this.getRowHeight() + this.getHeaderHeight();
            Rectangle r = new Rectangle(x, y, Math.min((int)(d = ((FileTableLabel)this.getValueAt(this.row, this.mainColumnIndex)).getPreferredSize()).getWidth(), this.getColumnModel().getColumn(this.mainColumnIndex).getWidth()), this.getRowHeight(this.row));
            if (r.contains(e.getPoint())) {
                if (e.isControlDown()) {
                    if (this.isCellSelected(this.row, this.mainColumnIndex)) {
                        if (!e.isPopupTrigger()) {
                            this.getSelectionModel().removeSelectionInterval(this.row, this.row);
                        }
                    } else {
                        this.updateSelectionInterval(this.row, true);
                    }
                } else if (!this.isCellSelected(this.row, this.mainColumnIndex)) {
                    this.updateSelectionInterval(this.row, false);
                }
            } else {
                this.clearSelection();
            }
        }
        this.synchFilechooser();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseDownFlag = false;
        this.mouseDragging = false;
        this.resetPane();
        this.evaluateClick(e);
        this.repaint();
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        this.getColumnModel().getSelectionModel().setSelectionInterval(this.mainColumnIndex, this.mainColumnIndex);
    }

    private void evaluateClick(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (e.getComponent() instanceof JTableHeader) {
                this.headerPopup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                Dimension d;
                int y;
                this.row = ((JTable)e.getComponent()).rowAtPoint(e.getPoint());
                this.column = ((JTable)e.getComponent()).columnAtPoint(e.getPoint());
                if (this.row < 0) {
                    this.panePopup.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                int x = (int)this.tableHeader.getHeaderRect(this.mainColumnIndex).getX();
                Rectangle r = new Rectangle(x, y = (this.row - 1) * this.getRowHeight() + this.getHeaderHeight(), Math.min((int)(d = ((FileTableLabel)this.getValueAt(this.row, this.mainColumnIndex)).getPreferredSize()).getWidth(), this.getColumnModel().getColumn(this.mainColumnIndex).getWidth()), this.getRowHeight(this.row));
                if (r.contains(e.getPoint())) {
                    this.tempItem = this.fileList.visibleItemsList.elementAt(this.row);
                    this.tempItem.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    this.fileList.lastSelected = this.tempItem;
                } else {
                    this.panePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    public void updateData(Object[][] vals) {
        this.en = this.getColumnModel().getColumns();
        Vector<String> vec = new Vector<String>();
        while (this.en.hasMoreElements()) {
            vec.add(((TableColumn)this.en.nextElement()).getHeaderValue().toString());
        }
        if (vec.size() <= 0) {
            this.model.setDataVector(vals, this.columnNames.toArray());
        } else {
            this.model.setDataVector(vals, vec.toArray());
        }
        if (this.shouldRecalculateColumnSize()) {
            this.columnsWidth = new int[]{(int)((double)this.getWidth() * 0.5), (int)((double)this.getWidth() * 0.1), (int)((double)this.getWidth() * 0.21), (int)((double)this.getWidth() * 0.19)};
        }
        this.en = this.getColumnModel().getColumns();
        int i = 0;
        while (this.en.hasMoreElements()) {
            TableColumn tempColumn = (TableColumn)this.en.nextElement();
            int cw = this.columnsWidth[i];
            if (cw == 0) {
                tempColumn.setMinWidth(cw);
            }
            tempColumn.setPreferredWidth(cw);
            tempColumn.setWidth(cw);
            ++i;
        }
        this.mainColumnIndex = this.getColumnModel().getColumnIndex("File Name");
        this.getColumnModel().getColumn(this.mainColumnIndex).setCellRenderer(new LabelRenderer());
        this.setSize(this.getPreferredSize());
        this.clearSelection();
    }

    private void captureColumnsWidth() {
        this.columnsWidth = new int[]{this.getColumnModel().getColumn(0).getWidth(), this.getColumnModel().getColumn(1).getWidth(), this.getColumnModel().getColumn(2).getWidth(), this.getColumnModel().getColumn(3).getWidth()};
    }

    private boolean shouldRecalculateColumnSize() {
        if (this.columnsWidth == null || this.columnsWidth.length < 4) {
            return true;
        }
        return this.columnsWidth[0] == 0 && this.columnsWidth[1] == 0 && this.columnsWidth[2] == 0 && this.columnsWidth[3] == 0;
    }

    public int getInitialHeight() {
        int height = 0;
        int rowCount = this.getRowCount();
        if (rowCount > 0 && this.getColumnCount() > 0) {
            Rectangle r = this.getCellRect(rowCount - 1, 0, true);
            height = r.y + r.height;
        }
        return height + this.getTableHeader().getHeight();
    }

    private void updateLastSelected() {
        int tempNum = this.fileList.visibleItemsList.indexOf(this.fileList.lastSelected);
        this.updateSelectionInterval(tempNum, false);
        this.synchFilechooser();
    }

    @Override
    public void selectAll() {
        if (this.fileList.fc.isMultiSelectionEnabled()) {
            this.clearSelection();
            this.getSelectionModel().addSelectionInterval(0, this.getRowCount() - 1);
            this.synchFilechooser();
        }
    }

    private void updateMainColumnIndex() {
        this.mainColumnIndex = this.getColumnModel().getColumnIndex(this.columnNames.elementAt(0));
    }

    protected void updateSelectionInterval(int row, boolean add) {
        if (add && this.fileList.fc.isMultiSelectionEnabled()) {
            this.getSelectionModel().addSelectionInterval(row, row);
        } else {
            this.clearSelection();
            this.getSelectionModel().addSelectionInterval(row, row);
        }
        this.fileList.lastSelected = this.fileList.visibleItemsList.elementAt(row);
        if (!this.mouseDownFlag) {
            this.scrollRectToVisible(this.getCellRect(row, this.mainColumnIndex, false));
        }
    }

    private void headerMenuChanged(String col, JCheckBoxMenuItem source) {
        int index = this.getColumnModel().getColumnIndex(col);
        if (!source.isSelected()) {
            int tv = 0;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                tv += this.getColumnModel().getColumn(i).getWidth();
            }
            if (tv == this.getColumn(col).getWidth()) {
                source.setSelected(true);
                return;
            }
            this.originalColumsWidth.set(this.columnNames.indexOf(col), new Integer(this.getColumnModel().getColumn(index).getWidth()));
            this.getColumnModel().getColumn(index).setMaxWidth(0);
            this.getColumnModel().getColumn(index).setMinWidth(0);
            this.getColumnModel().getColumn(index).setWidth(0);
            this.getColumnModel().getColumn(index).setPreferredWidth(0);
            this.getTableHeader().resizeAndRepaint();
        } else {
            this.getColumnModel().getColumn(index).setMaxWidth(Integer.MAX_VALUE);
            this.getColumnModel().getColumn(index).setPreferredWidth(this.originalColumsWidth.get(this.columnNames.indexOf(col)));
            this.getColumnModel().getColumn(index).setWidth(this.originalColumsWidth.get(this.columnNames.indexOf(col)));
            this.originalColumsWidth.set(this.columnNames.indexOf(col), 0);
            this.getTableHeader().resizeAndRepaint();
        }
    }

    private void forwardToNearestFor(String pre) {
        int index = this.fileList.visibleItemsList.indexOf(this.fileList.lastSelected) + 1;
        for (int i = 0; i < this.fileList.visibleItemsList.size(); ++i) {
            if (index == this.fileList.visibleItemsList.size()) {
                index = 0;
            }
            if (this.fileList.visibleItemsList.elementAt(index).getFileName().toLowerCase().startsWith(pre)) {
                this.updateSelectionInterval(index, false);
                this.scrollRectToVisible(this.getCellRect(index, this.mainColumnIndex, false));
                this.updateLastSelected();
                return;
            }
            ++index;
        }
    }

    private class TableKeyListener
    extends KeyAdapter {
        private FileTable table;
        private int tempNum = 0;

        private TableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.table == null) {
                this.table = (FileTable)e.getSource();
            }
            if (e.getKeyCode() == 27) {
                ((FileTable)FileTable.this).fileList.filechooserUI.getCancelSelectionAction().actionPerformed(null);
            } else if (e.getKeyCode() == 32) {
                FileTable.this.updateLastSelected();
            } else if (e.getKeyCode() == 38) {
                this.tempNum = ((FileTable)FileTable.this).fileList.visibleItemsList.indexOf(((FileTable)FileTable.this).fileList.lastSelected);
                if (this.tempNum < ((FileTable)FileTable.this).fileList.visibleItemsList.size() && this.tempNum > 0) {
                    ((FileTable)FileTable.this).fileList.lastSelected = ((FileTable)FileTable.this).fileList.visibleItemsList.elementAt(this.tempNum - 1);
                    FileTable.this.updateLastSelected();
                }
            } else if (e.getKeyCode() == 40) {
                this.tempNum = ((FileTable)FileTable.this).fileList.visibleItemsList.indexOf(((FileTable)FileTable.this).fileList.lastSelected);
                if (this.tempNum < ((FileTable)FileTable.this).fileList.visibleItemsList.size() - 1) {
                    ((FileTable)FileTable.this).fileList.lastSelected = ((FileTable)FileTable.this).fileList.visibleItemsList.elementAt(this.tempNum + 1);
                    FileTable.this.updateLastSelected();
                }
            } else if (e.getKeyCode() == 36) {
                ((FileTable)FileTable.this).fileList.lastSelected = ((FileTable)FileTable.this).fileList.visibleItemsList.elementAt(0);
                FileTable.this.updateLastSelected();
            } else if (e.getKeyCode() == 35) {
                ((FileTable)FileTable.this).fileList.lastSelected = ((FileTable)FileTable.this).fileList.visibleItemsList.elementAt(((FileTable)FileTable.this).fileList.visibleItemsList.size() - 1);
                FileTable.this.updateLastSelected();
            } else if (e.getKeyCode() == 10) {
                FileTable.this.doActionPerformed();
            } else if (e.getKeyCode() == 33) {
                this.tempNum = ((FileTable)FileTable.this).fileList.visibleItemsList.indexOf(((FileTable)FileTable.this).fileList.lastSelected);
                int diff = (int)(((JViewport)this.table.getParent()).getViewRect().getHeight() / this.table.getCellRect(this.tempNum, 0, true).getHeight()) - 1;
                if (this.tempNum - diff < 0) {
                    ((FileTable)FileTable.this).fileList.lastSelected = ((FileTable)FileTable.this).fileList.visibleItemsList.elementAt(0);
                    FileTable.this.updateLastSelected();
                } else {
                    ((FileTable)FileTable.this).fileList.lastSelected = ((FileTable)FileTable.this).fileList.visibleItemsList.elementAt(this.tempNum - diff);
                    FileTable.this.updateLastSelected();
                }
            } else if (e.getKeyCode() == 34) {
                this.tempNum = ((FileTable)FileTable.this).fileList.visibleItemsList.indexOf(((FileTable)FileTable.this).fileList.lastSelected);
                int diff = (int)(((JViewport)this.table.getParent()).getViewRect().getHeight() / this.table.getCellRect(this.tempNum, 0, true).getHeight()) - 1;
                if (this.tempNum + diff >= ((FileTable)FileTable.this).fileList.visibleItemsList.size()) {
                    ((FileTable)FileTable.this).fileList.lastSelected = ((FileTable)FileTable.this).fileList.visibleItemsList.elementAt(((FileTable)FileTable.this).fileList.visibleItemsList.size() - 1);
                    FileTable.this.updateLastSelected();
                } else {
                    ((FileTable)FileTable.this).fileList.lastSelected = ((FileTable)FileTable.this).fileList.visibleItemsList.elementAt(this.tempNum + diff);
                    FileTable.this.updateLastSelected();
                }
            } else {
                if (KeyEvent.getKeyText(e.getKeyCode()).toLowerCase().equals("a") && e.getModifiersEx() == 128) {
                    this.table.selectAll();
                }
                if (e.getModifiersEx() == 0) {
                    this.table.forwardToNearestFor(String.valueOf(e.getKeyChar()).toLowerCase());
                }
            }
        }
    }

    private class TableHeaderMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumn;
            JTableHeader h;
            TableColumnModel columnModel;
            int column;
            if (!e.isPopupTrigger() && (column = (columnModel = (h = (JTableHeader)e.getSource()).getColumnModel()).getColumn(viewColumn = columnModel.getColumnIndexAtX(e.getX())).getModelIndex()) != -1) {
                if (columnModel.getColumn(viewColumn).getHeaderValue().equals("File Name")) {
                    FileTable.this.fileList.orderBy(FileList.ORDER_BY_FILE_NAME, false);
                    FileTable.this.fileList.updateTableData();
                } else if (columnModel.getColumn(viewColumn).getHeaderValue().equals("Type")) {
                    FileTable.this.fileList.orderBy(FileList.ORDER_BY_FILE_TYPE, false);
                    FileTable.this.fileList.updateTableData();
                } else if (columnModel.getColumn(viewColumn).getHeaderValue().equals("Last Modified")) {
                    FileTable.this.fileList.orderBy(FileList.ORDER_BY_FILE_MODIFIED, false);
                    FileTable.this.fileList.updateTableData();
                } else if (columnModel.getColumn(viewColumn).getHeaderValue().equals("Size")) {
                    FileTable.this.fileList.orderBy(FileList.ORDER_BY_FILE_SIZE, false);
                    FileTable.this.fileList.updateTableData();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            FileTable.this.evaluateClick(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            FileTable.this.evaluateClick(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            FileTable.this.updateMainColumnIndex();
            FileTable.this.captureColumnsWidth();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class HeaderActionListener
    implements ActionListener {
        private HeaderActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileTable.this.headerMenuChanged(e.getActionCommand(), (JCheckBoxMenuItem)e.getSource());
            FileTable.this.captureColumnsWidth();
        }
    }

    private static class LabelRenderer
    extends FileTableLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 8972168539366862236L;

        private LabelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            FileTableLabel label = (FileTableLabel)value;
            label.setOpaque(false);
            label.setSelected(isSelected);
            if (isSelected) {
                label.setForeground(UIManager.getColor("textHighlightText"));
            } else {
                label.setForeground(UIManager.getColor("textText"));
            }
            return label;
        }
    }
}

