/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.RapidLookTools;
import com.rapidminer.gui.look.fc.Bookmark;
import com.rapidminer.gui.look.fc.BookmarkDialog;
import com.rapidminer.gui.look.fc.BookmarkIO;
import com.rapidminer.gui.look.fc.BookmarkList;
import com.rapidminer.gui.look.fc.BookmarkListModel;
import com.rapidminer.gui.look.fc.FileChooserUI;
import com.rapidminer.gui.look.fc.FileTable;
import com.rapidminer.gui.look.fc.FileTableLabel;
import com.rapidminer.gui.look.fc.Item;
import com.rapidminer.gui.look.fc.ItemPanel;
import com.rapidminer.gui.look.fc.ItemPanelKeyboardListener;
import com.rapidminer.gui.look.fc.ThumbGeneratorThread;
import com.rapidminer.gui.look.fc.Tools;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class FileList
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 8893252970970228545L;
    private static final ImageIcon SMALL_FILE_IMAGE = SwingTools.createImage("plaf/unknown_file_small.png");
    private static final ImageIcon SMALL_FOLDER_IMAGE = SwingTools.createImage("plaf/unknown_folder_small.png");
    private static final ImageIcon BIG_FILE_IMAGE = SwingTools.createImage("plaf/unknown_file_big.png");
    private static final ImageIcon BIG_FOLDER_IMAGE = SwingTools.createImage("plaf/unknown_folder_big.png");
    private final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private final Cursor normalCursor = Cursor.getPredefinedCursor(0);
    private ButtonGroup viewButtonGroup;
    private ButtonGroup orderButtonGroup;
    protected ItemPanel itemPanel;
    private ThumbGeneratorThread thumbGenerator = new ThumbGeneratorThread(this.itemPanel);
    private final FileSystemView fsv = FileSystemView.getFileSystemView();
    private final BookmarkIO bookmarksIO = new BookmarkIO();
    private final BookmarkListModel bookmarkListModel = new BookmarkListModel();
    private final JList bookmarkList = new BookmarkList(this.bookmarkListModel, this);
    private final JSplitPane mainSplitPane = new JSplitPane();
    private JMenuItem menuItem;
    private Window window;
    protected JPanel cardPanel = new JPanel(new CardLayout());
    private final JScrollPane tableScrollPane = new JScrollPane();
    protected FileTable tablePanel;
    protected JScrollPane browseScrollPane = new JScrollPane();
    private final TreeMap<String, Object[]> systemInfoCach = new TreeMap();
    protected ItemPanelKeyboardListener keyListener = new ItemPanelKeyboardListener();
    protected Vector<Object> completeItemsList = new Vector(20);
    protected Vector<Item> visibleItemsList = new Vector(20);
    protected Vector<Object> tempList = new Vector(20);
    private final TreeMap<Item, Item> tempCompareTree = new TreeMap();
    protected Item lastSelected;
    protected JPopupMenu panePopup;
    private MenuListener mal;
    private String tempExtension;
    protected JFileChooser fc;
    protected FileChooserUI filechooserUI;
    protected File tempFile;
    protected File currentFile = null;
    private Object[] tempArray;
    private File[] selectedFilesArray;
    protected Vector<Object> selectedFilesVector = new Vector();
    private boolean tempFlag = false;
    public static String ORDER_BY_FILE_NAME = I18N.getMessage(I18N.getGUIBundle(), "gui.menu.file_chooser.sort_by.file_name", new Object[0]);
    public static String ORDER_BY_FILE_TYPE = I18N.getMessage(I18N.getGUIBundle(), "gui.menu.file_chooser.sort_by.file_type", new Object[0]);
    public static String ORDER_BY_FILE_SIZE = I18N.getMessage(I18N.getGUIBundle(), "gui.menu.file_chooser.sort_by.file_size", new Object[0]);
    public static String ORDER_BY_FILE_MODIFIED = I18N.getMessage(I18N.getGUIBundle(), "gui.menu.file_chooser.sort_by.last_modified", new Object[0]);
    protected String ORDER_BY = ORDER_BY_FILE_NAME;
    private JCheckBoxMenuItem autoArrangeCheckBox;
    private final transient Action REFRESH_ACTION = new ResourceAction("file_chooser.refresh", new Object[0]){
        private static final long serialVersionUID = 2591227051998175245L;

        @Override
        public void actionPerformed(ActionEvent e) {
            FileList.this.rescanDirectory();
        }
    };
    private final transient Action SELECT_ALL_ACTION = new ResourceAction("file_chooser.select_all", new Object[0]){
        private static final long serialVersionUID = 732148144067893679L;

        @Override
        public void actionPerformed(ActionEvent e) {
            FileList.this.selectAll();
        }
    };
    private final transient Action ORDER_BY_ACTION = new ResourceActionAdapter("file_chooser.sort_by", new Object[0]);

    protected ImageIcon getSystemIcon(File file, String filename, boolean isDir, boolean bigIcon) throws Exception {
        if (!isDir) {
            this.tempExtension = filename.indexOf(46) > -1 ? filename.substring(1 + file.getName().indexOf(46)) : "Type is : ." + this.fsv.getSystemTypeDescription(file);
            if (this.systemInfoCach.containsKey(this.tempExtension)) {
                this.cachSystemDetails(file, filename);
            }
            this.tempArray = this.systemInfoCach.get(this.tempExtension);
            if (bigIcon) {
                if (this.tempArray[3] == null) {
                    Image image = this.getShellFolder(file).getIcon(true);
                    this.tempArray[3] = image == null ? BIG_FILE_IMAGE : Tools.getBigSystemIcon(image);
                    this.systemInfoCach.put(this.tempExtension, this.tempArray);
                }
                return (ImageIcon)this.tempArray[3];
            }
            if (this.tempArray[2] == null) {
                Image image = null;
                try {
                    image = this.getShellFolder(file).getIcon(false);
                }
                catch (Exception exp) {
                    // empty catch block
                }
                this.tempArray[2] = image == null ? SMALL_FILE_IMAGE : Tools.getSmallSystemIcon(image);
                this.systemInfoCach.put(this.tempExtension, this.tempArray);
            }
            return (ImageIcon)this.tempArray[2];
        }
        if (bigIcon) {
            Image image = this.getShellFolder(file).getIcon(true);
            if (image == null) {
                return BIG_FOLDER_IMAGE;
            }
            return Tools.getBigSystemIcon(image);
        }
        Image tempImage = this.getShellFolder(file).getIcon(false);
        if (tempImage == null) {
            return SMALL_FOLDER_IMAGE;
        }
        return Tools.getSmallSystemIcon(tempImage);
    }

    private void updateViewMenuItemsGroup() {
        Enumeration<AbstractButton> en = this.viewButtonGroup.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbm = (JRadioButtonMenuItem)en.nextElement();
            if (!rbm.getActionCommand().equals("viewType:" + this.filechooserUI.getView())) continue;
            this.viewButtonGroup.setSelected(rbm.getModel(), true);
        }
    }

    protected void changeCardForView() {
        this.stopThumbnailGeneration();
        if (this.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_DETAILS)) {
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, "tableScrollPane");
            this.updateTableData();
            this.tableScrollPane.getViewport().setViewPosition(new Point());
            this.tablePanel.requestFocusInWindow();
        } else {
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, "browseScrollPane");
            this.itemPanel.updateViewType();
            this.browseScrollPane.getViewport().setViewPosition(new Point());
            this.itemPanel.requestFocusInWindow();
        }
        this.updateViewMenuItemsGroup();
    }

    protected Object[] cachSystemDetails(File file, String filename) {
        this.tempExtension = filename.indexOf(46) > -1 ? filename.substring(1 + file.getName().indexOf(46)) : "Type is : ." + this.fsv.getSystemTypeDescription(file);
        if (!this.systemInfoCach.containsKey(this.tempExtension)) {
            try {
                String tempDesc = null;
                try {
                    tempDesc = this.fsv.getSystemTypeDescription(file);
                }
                catch (Exception exp) {
                    // empty catch block
                }
                if (tempDesc == null) {
                    tempDesc = filename;
                }
                this.systemInfoCach.put(this.tempExtension, new Object[]{this.tempExtension, tempDesc, null, null});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.systemInfoCach.get(this.tempExtension);
    }

    private ShellFolder getShellFolder(File f) {
        try {
            return ShellFolder.getShellFolder(f);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (InternalError e) {
            return null;
        }
    }

    public void addToBookmarks() {
        this.addToBookmarks(this.fc.getCurrentDirectory());
    }

    public void addToBookmarks(File f) {
        String name = SwingTools.showInputDialog("file_chooser.bookmark_name", this.fsv.getSystemDisplayName(f), this.fsv.getSystemDisplayName(f));
        if (name != null && !name.trim().equals("")) {
            try {
                this.bookmarksIO.addToList(name, f.getCanonicalFile().getPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.updateBookmarks();
        }
    }

    private void updateBookmarks() {
        this.bookmarkListModel.removeAllBookmarks();
        Collection<Bookmark> bookmarks = this.bookmarksIO.getBookmarks();
        for (Bookmark bookmark : bookmarks) {
            this.bookmarkListModel.addBookmark(bookmark);
        }
    }

    public void deleteBookmark(Bookmark bookmark) {
        this.bookmarksIO.deleteBookmark(bookmark);
        this.updateBookmarks();
    }

    public void renameBookmark(Bookmark bookmark) {
        this.window = Tools.getWindowForComponent(this);
        BookmarkDialog dialog = this.window instanceof Frame ? new BookmarkDialog((Frame)this.window, true) : new BookmarkDialog((Dialog)this.window, true);
        dialog.setLocationRelativeTo(this.window);
        dialog.updateDefaults(bookmark.getName(), bookmark.getPath());
        dialog.setVisible(true);
        if (dialog.isNameChanged()) {
            this.bookmarksIO.renameBookmark(bookmark, dialog.getNewName());
            this.updateBookmarks();
        }
    }

    public FileList(FileChooserUI tfcui, JFileChooser fc) {
        try {
            this.fc = fc;
            this.filechooserUI = tfcui;
            this.init();
            this.updateBookmarks();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.mainSplitPane.setName("");
        this.mainSplitPane.setAutoscrolls(true);
        this.mainSplitPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        this.mainSplitPane.setMinimumSize(new Dimension(40, 25));
        this.mainSplitPane.setOpaque(true);
        this.mainSplitPane.setContinuousLayout(false);
        this.mainSplitPane.setDividerLocation(170);
        this.mainSplitPane.setLastDividerLocation(170);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.tableScrollPane.getViewport().setBackground(Color.white);
        this.tableScrollPane.setFocusable(false);
        this.tableScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.tableScrollPane.setBorder(null);
        this.browseScrollPane.setName("");
        this.browseScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.browseScrollPane.setBorder(null);
        JPanel bookmarkPanel = new JPanel(new BorderLayout());
        JLabel bookmarkLabel = new JLabel(I18N.getMessage(I18N.getGUIBundle(), "gui.label.file_chooser.bookmarks.label", new Object[0]), 0){
            private static final long serialVersionUID = -5903685281066236757L;
            {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
            }

            @Override
            public void paint(Graphics g) {
                int h = this.getHeight();
                int w = this.getWidth();
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[6]);
                g.drawLine(0, 0, w - 1, 0);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[7]);
                g.drawLine(0, h - 2, w - 1, h - 2);
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(new GradientPaint(0.0f, 1.0f, RapidLookTools.getColors().getTableHeaderColors()[8], 0.0f, h - 5, RapidLookTools.getColors().getTableHeaderColors()[9]));
                g2.fillRect(0, 1, w, h - 5);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[10]);
                g.drawLine(0, h - 5, w - 1, h - 5);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[11]);
                g.drawLine(0, h - 4, w - 1, h - 4);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[12]);
                g.drawLine(0, h - 3, w - 1, h - 3);
                g.setColor(RapidLookTools.getColors().getTableHeaderColors()[13]);
                g.drawLine(0, h - 1, w - 1, h - 1);
                super.paint(g);
            }
        };
        bookmarkPanel.add((Component)bookmarkLabel, "North");
        JScrollPane bookmarkPane = new JScrollPane(this.bookmarkList);
        bookmarkPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        bookmarkPanel.add((Component)bookmarkPane, "Center");
        this.add((Component)this.mainSplitPane, "Center");
        this.tablePanel = new FileTable(this);
        this.itemPanel = new ItemPanel(this);
        this.cardPanel.add((Component)this.browseScrollPane, "browseScrollPane");
        this.browseScrollPane.setActionMap(null);
        this.cardPanel.add((Component)this.tableScrollPane, "tableScrollPane");
        this.tableScrollPane.setActionMap(null);
        this.tableScrollPane.getViewport().add(this.tablePanel);
        this.browseScrollPane.getViewport().add(this.itemPanel);
        this.mainSplitPane.add((Component)this.cardPanel, "right");
        this.mainSplitPane.add((Component)bookmarkPanel, "left");
        this.fc.setPreferredSize(new Dimension(780, 510));
        this.updateTablePanelSize();
        this.cardPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FileList.this.itemPanel.arrangeTheFiles((int)FileList.this.cardPanel.getSize().getWidth());
            }
        });
        this.tableScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FileList.this.updateTablePanelSize();
                if (FileList.this.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_DETAILS)) {
                    FileList.this.tablePanel.requestFocusInWindow();
                }
            }
        });
    }

    protected void updateTablePanelSize() {
        if ((double)this.tablePanel.getInitialHeight() < this.tableScrollPane.getSize().getHeight()) {
            this.tablePanel.setPreferredSize(new Dimension(this.tablePanel.getWidth(), this.tableScrollPane.getHeight() - this.tablePanel.getTableHeader().getHeight()));
            this.tablePanel.setMinimumSize(this.tablePanel.getPreferredSize());
            this.tablePanel.setSize(this.tablePanel.getPreferredSize());
        } else {
            this.tablePanel.setPreferredSize(new Dimension(this.tablePanel.getWidth(), this.tablePanel.getInitialHeight()));
            this.tablePanel.setMinimumSize(this.tablePanel.getPreferredSize());
            this.tablePanel.setSize(this.tablePanel.getPreferredSize());
        }
    }

    public void generateThumbs() {
        this.thumbGenerator = new ThumbGeneratorThread(this.itemPanel);
        this.thumbGenerator.start();
    }

    public void setSelectedFile(File f) {
        this.filechooserUI.setCurrentDirectoryOfFileChooser(f);
    }

    public void updatePath(File file) {
        this.fc.setCursor(this.waitCursor);
        this.clearEveryThing();
        this.exploreFolder(file);
        this.fc.setCursor(this.normalCursor);
    }

    protected void updateThumbnail() {
        if (this.itemPanel.getCurrentView().equals(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL)) {
            this.thumbGenerator.stop();
            this.thumbGenerator = new ThumbGeneratorThread(this.itemPanel);
            this.thumbGenerator.start();
        }
    }

    public void rescanDirectory() {
        this.tempFile = this.fc.getCurrentDirectory();
        try {
            this.tempFile = this.tempFile.getCanonicalFile();
        }
        catch (IOException ex) {
            // empty catch block
        }
        File[] files = this.tempFile.listFiles();
        TreeMap<File, File> filesMap = new TreeMap<File, File>();
        Enumeration<Object> en = this.completeItemsList.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            filesMap.put(item.getFile(), item.getFile());
        }
        File[] arr$ = files;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File element;
            this.tempFile = element = arr$[i$];
            try {
                this.tempFile = this.tempFile.getCanonicalFile();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (filesMap.containsKey(this.tempFile)) continue;
            Item item = new Item(this.itemPanel, this.tempFile);
            this.completeItemsList.add(item);
            this.visibleItemsList.add(item);
            item.addKeyListener(this.keyListener);
            this.itemPanel.add(item);
            this.itemPanel.findBestConfig(item);
            this.itemPanel.repaint();
            this.scrollRectToVisible(item.getBounds());
        }
        Vector<Item> removingItems = new Vector<Item>();
        filesMap.clear();
        File[] arr$2 = files;
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            File element;
            this.tempFile = element = arr$2[i$];
            try {
                this.tempFile = this.tempFile.getCanonicalFile();
            }
            catch (Exception exp) {
                // empty catch block
            }
            filesMap.put(this.tempFile, this.tempFile);
        }
        for (int j = 0; j < this.completeItemsList.size(); ++j) {
            Item item = (Item)this.completeItemsList.elementAt(j);
            if (filesMap.containsKey(item.getFile())) continue;
            removingItems.add(item);
        }
        Enumeration n = removingItems.elements();
        while (n.hasMoreElements()) {
            Item item = (Item)n.nextElement();
            this.completeItemsList.remove(item);
            this.visibleItemsList.remove(item);
            this.itemPanel.remove(item);
            if (!this.selectedFilesVector.contains(item)) continue;
            this.selectedFilesVector.remove(item);
        }
        if (this.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_DETAILS)) {
            this.updateTableData();
        } else if (this.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL)) {
            this.stopThumbnailGeneration();
            this.generateThumbs();
        }
        this.orderBy(this.ORDER_BY, true);
        this.arrangeTheFiles();
        this.repaint();
    }

    private void exploreFolder(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.currentFile != null) {
            this.filechooserUI.backPathVector.add(this.currentFile.getPath());
            this.filechooserUI.getGoBackAction().setEnabled(true);
        } else {
            this.filechooserUI.getGoBackAction().setEnabled(false);
        }
        this.currentFile = file;
        File[] files = file.listFiles();
        if (files != null) {
            File[] arr$ = files;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                File element;
                this.tempFile = element = arr$[i$];
                try {
                    this.tempFile = element.getCanonicalFile();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                if ((this.currentFile.toString().equals("My Computer") || !this.tempFile.exists() || !this.tempFile.canRead()) && !this.currentFile.toString().equals("My Computer")) continue;
                Item item = new Item(this.itemPanel, this.tempFile);
                item.addKeyListener(this.keyListener);
                this.completeItemsList.add(item);
            }
        }
        this.doDefaults();
        this.requestFocus();
        this.repaint();
    }

    public FileSystemView getFSV() {
        return this.fsv;
    }

    public void stopThumbnailGeneration() {
        this.thumbGenerator.stop();
        this.thumbGenerator = new ThumbGeneratorThread(this.itemPanel);
    }

    public void clearEveryThing() {
        this.itemPanel.removeAll();
        this.lastSelected = null;
        this.completeItemsList.removeAllElements();
        this.visibleItemsList.removeAllElements();
        this.selectedFilesVector.removeAllElements();
        this.completeItemsList.removeAllElements();
        Enumeration<Object> en = this.completeItemsList.elements();
        while (en.hasMoreElements()) {
            Item t = (Item)en.nextElement();
            t.finalizeAll();
            t = null;
        }
    }

    public void clearSelectedItemsList() {
        Enumeration<Object> en = this.selectedFilesVector.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            item.updateSelectionMode(false);
            item.repaint();
        }
        this.selectedFilesVector.clear();
        this.fc.setSelectedFiles(null);
        this.repaint();
    }

    public boolean isItemSelected(Item item) {
        return this.selectedFilesVector.contains(item);
    }

    protected void updateFilechooserSelectedItems(Item t, boolean ctrl) {
        if (!ctrl || !this.fc.isMultiSelectionEnabled()) {
            Enumeration<Object> en = this.completeItemsList.elements();
            while (en.hasMoreElements()) {
                ((Item)en.nextElement()).updateSelectionMode(false);
            }
            this.selectedFilesVector.removeAllElements();
        }
        t.updateSelectionMode(!t.getSelectionMode());
        if (t.getSelectionMode()) {
            this.itemPanel.scrollRectToVisible(t.getBounds());
            if (!this.selectedFilesVector.contains(t)) {
                this.selectedFilesVector.add(t);
            }
        } else if (this.selectedFilesVector.contains(t)) {
            this.selectedFilesVector.remove(t);
        }
        this.lastSelected = t;
        this.synchFilechoserSelection();
    }

    @Override
    public void requestFocus() {
        if (this.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_DETAILS)) {
            this.tablePanel.requestFocus();
        } else {
            this.itemPanel.requestFocus();
        }
    }

    protected void synchFilechoserSelection() {
        int counter = 0;
        this.selectedFilesArray = new File[this.selectedFilesVector.size()];
        Vector<Item> tempVector = new Vector<Item>();
        Enumeration<Object> en = this.selectedFilesVector.elements();
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            if ((!this.fc.isDirectorySelectionEnabled() || !item.isDirectory()) && (!this.fc.isFileSelectionEnabled() || item.isDirectory())) continue;
            tempVector.add(item);
        }
        this.selectedFilesArray = new File[tempVector.size()];
        en = tempVector.elements();
        counter = 0;
        while (en.hasMoreElements()) {
            this.selectedFilesArray[counter] = ((Item)en.nextElement()).getFile();
            ++counter;
        }
        this.fc.setSelectedFiles(this.selectedFilesArray);
    }

    protected JPopupMenu getPanePopup() {
        if (this.panePopup != null) {
            return this.panePopup;
        }
        this.mal = new MenuListener(this);
        this.panePopup = new JPopupMenu();
        this.menuItem = new JMenuItem(this.filechooserUI.NEW_FOLDER_ACTION);
        this.panePopup.add(this.menuItem);
        this.menuItem = new JMenuItem(this.filechooserUI.ADD_TO_BOOKMARKS_ACTION);
        this.panePopup.add(this.menuItem);
        this.panePopup.addSeparator();
        this.menuItem = new JMenuItem(this.REFRESH_ACTION);
        this.panePopup.add(this.menuItem);
        this.menuItem = new JMenuItem(this.SELECT_ALL_ACTION);
        this.panePopup.add(this.menuItem);
        JMenu orderMenuItem = new JMenu(this.ORDER_BY_ACTION);
        this.panePopup.add(orderMenuItem);
        this.orderButtonGroup = new ButtonGroup();
        this.menuItem = new JRadioButtonMenuItem(ORDER_BY_FILE_NAME);
        this.menuItem.setSelected(true);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("ORDER:" + ORDER_BY_FILE_NAME);
        orderMenuItem.add(this.menuItem);
        this.orderButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(ORDER_BY_FILE_TYPE);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("ORDER:" + ORDER_BY_FILE_TYPE);
        orderMenuItem.add(this.menuItem);
        this.orderButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(ORDER_BY_FILE_SIZE);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("ORDER:" + ORDER_BY_FILE_SIZE);
        orderMenuItem.add(this.menuItem);
        this.orderButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(ORDER_BY_FILE_MODIFIED);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("ORDER:" + ORDER_BY_FILE_MODIFIED);
        orderMenuItem.add(this.menuItem);
        this.orderButtonGroup.add(this.menuItem);
        this.panePopup.addSeparator();
        JMenu viewMenuItem = new JMenu(this.filechooserUI.CHANGE_VIEW_ACTION);
        this.panePopup.add(viewMenuItem);
        this.viewButtonGroup = new ButtonGroup();
        this.menuItem = new JRadioButtonMenuItem(FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("viewType:" + FileChooserUI.FILECHOOSER_VIEW_THUMBNAIL);
        viewMenuItem.add(this.menuItem);
        this.viewButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(FileChooserUI.FILECHOOSER_VIEW_ICON);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("viewType:" + FileChooserUI.FILECHOOSER_VIEW_ICON);
        viewMenuItem.add(this.menuItem);
        this.viewButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(FileChooserUI.FILECHOOSER_VIEW_LIST);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setSelected(true);
        this.menuItem.setActionCommand("viewType:" + FileChooserUI.FILECHOOSER_VIEW_LIST);
        viewMenuItem.add(this.menuItem);
        this.viewButtonGroup.add(this.menuItem);
        this.menuItem = new JRadioButtonMenuItem(FileChooserUI.FILECHOOSER_VIEW_DETAILS);
        this.menuItem.addActionListener(this.mal);
        this.menuItem.setActionCommand("viewType:" + FileChooserUI.FILECHOOSER_VIEW_DETAILS);
        viewMenuItem.add(this.menuItem);
        this.viewButtonGroup.add(this.menuItem);
        viewMenuItem.addSeparator();
        this.autoArrangeCheckBox = new JCheckBoxMenuItem(new ResourceActionAdapter("file_chooser.auto_arrange", new Object[0]));
        this.autoArrangeCheckBox.setSelected(true);
        viewMenuItem.add(this.autoArrangeCheckBox);
        return this.panePopup;
    }

    public boolean isAutoArrange() {
        return this.autoArrangeCheckBox.isSelected();
    }

    public void orderBy(String str, boolean newPath) {
        if (!newPath && this.ORDER_BY.equals(str)) {
            this.tempList.clear();
            for (int i = this.completeItemsList.size() - 1; i >= 0; --i) {
                this.tempList.add(this.completeItemsList.elementAt(i));
            }
            this.completeItemsList.clear();
            this.completeItemsList = (Vector)this.tempList.clone();
        } else {
            this.tempCompareTree.clear();
            Enumeration<Object> en = this.completeItemsList.elements();
            while (en.hasMoreElements()) {
                Item item = (Item)en.nextElement();
                item.setCompare_type(str);
                this.tempCompareTree.put(item, item);
            }
            this.completeItemsList.clear();
            this.completeItemsList = new Vector<Item>(this.tempCompareTree.values());
        }
        this.ORDER_BY = str;
        Enumeration<AbstractButton> en = this.orderButtonGroup.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbm = (JRadioButtonMenuItem)en.nextElement();
            if (!rbm.getActionCommand().equals("ORDER:" + this.getOrder())) continue;
            this.orderButtonGroup.setSelected(rbm.getModel(), true);
        }
        this.findVisibleItems();
    }

    private void arrangeTheFiles() {
        if (this.filechooserUI.viewType.equals(FileChooserUI.FILECHOOSER_VIEW_DETAILS)) {
            this.changeCardForView();
        } else {
            this.itemPanel.arrangeTheFiles();
        }
    }

    public void doFilterChanged() {
        this.findVisibleItems();
        this.changeCardForView();
        if (this.visibleItemsList.size() > 0) {
            this.lastSelected = this.visibleItemsList.get(0);
        }
    }

    public void selectAll() {
        if (this.fc.isMultiSelectionEnabled()) {
            if (this.filechooserUI.getView().equals(FileChooserUI.FILECHOOSER_VIEW_DETAILS)) {
                this.tablePanel.selectAll();
            } else {
                this.clearSelectedItemsList();
                Enumeration<Item> tempEn = this.visibleItemsList.elements();
                while (tempEn.hasMoreElements()) {
                    Item item = tempEn.nextElement();
                    item.updateSelectionMode(true);
                    this.selectedFilesVector.add(item);
                    item.repaint();
                }
                this.synchFilechoserSelection();
            }
        }
    }

    public void doDefaults() {
        this.orderBy(this.ORDER_BY, true);
        this.changeCardForView();
        if (this.visibleItemsList.size() > 0) {
            this.lastSelected = this.visibleItemsList.get(0);
        }
    }

    protected void findVisibleItems() {
        this.visibleItemsList.clear();
        this.itemPanel.removeAll();
        Enumeration<Object> en = this.completeItemsList.elements();
        while (en.hasMoreElements()) {
            this.tempFlag = true;
            Item item = (Item)en.nextElement();
            if (item.getFile().isHidden() && this.fc.isFileHidingEnabled()) {
                this.tempFlag = false;
            }
            if (this.tempFlag && this.fc.getFileFilter() != null && !this.fc.getFileFilter().accept(item.getFile())) {
                this.tempFlag = false;
            }
            if (this.tempFlag && !this.fc.isFileSelectionEnabled() && item.getFile().isFile()) {
                this.tempFlag = false;
            }
            if (this.tempFlag) {
                item.setVisible(true);
            } else {
                item.setVisible(false);
            }
            if (!this.tempFlag) continue;
            this.visibleItemsList.add(item);
            this.itemPanel.add(item);
        }
    }

    protected void updateTableData() {
        Enumeration<Item> els = this.visibleItemsList.elements();
        Vector<Object> vec2 = new Vector<Object>();
        int ni = 0;
        int si = 1;
        int ti = 2;
        int li = 3;
        try {
            ni = this.tablePanel.getColumnModel().getColumnIndex("File Name");
        }
        catch (Exception exp) {
            // empty catch block
        }
        try {
            si = this.tablePanel.getColumnModel().getColumnIndex("Size");
        }
        catch (Exception exp) {
            // empty catch block
        }
        try {
            ti = this.tablePanel.getColumnModel().getColumnIndex("Type");
        }
        catch (Exception exp) {
            // empty catch block
        }
        try {
            li = this.tablePanel.getColumnModel().getColumnIndex("Last Modified");
        }
        catch (Exception exp) {
            // empty catch block
        }
        while (els.hasMoreElements()) {
            Item tc = els.nextElement();
            Object[] arr = new Object[4];
            arr[ni] = new FileTableLabel(tc.getFileName(), tc.getSmallSystemIcon(), 2);
            arr[si] = tc.convertToCorrectFormat(tc.getFileSize());
            arr[ti] = tc.getFileType();
            arr[li] = DateFormat.getDateInstance().format(new Date(tc.getLastModificationTime()));
            vec2.add(arr.clone());
        }
        Object[][] res = new Object[vec2.size()][];
        Enumeration<Object> en = vec2.elements();
        int c = 0;
        while (en.hasMoreElements()) {
            res[c] = (Object[])en.nextElement();
            ++c;
        }
        this.updateTablePanelSize();
        this.tablePanel.updateData(res);
        this.updateTablePanelSize();
        en = this.selectedFilesVector.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            Item item = (Item)en.nextElement();
            this.tablePanel.updateSelectionInterval(this.visibleItemsList.indexOf(item), true);
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FILECHOOSER_VIEW_TYPE")) {
            this.filechooserUI.updateView(evt.getNewValue().toString());
        }
    }

    public String getOrder() {
        return this.ORDER_BY;
    }

    private static class MenuListener
    implements ActionListener {
        private final FileList fileList;

        public MenuListener(FileList fileList) {
            this.fileList = fileList;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getActionCommand().startsWith("ORDER")) {
                    this.fileList.orderBy(e.getActionCommand().substring(e.getActionCommand().lastIndexOf(58) + 1), false);
                    this.fileList.arrangeTheFiles();
                } else if (e.getActionCommand().startsWith("viewType")) {
                    this.fileList.filechooserUI.updateView(e.getActionCommand().substring(e.getActionCommand().lastIndexOf(58) + 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

