/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.borders.Borders;
import com.rapidminer.gui.look.fc.FileList;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.ResourceActionTransmitter;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.DropDownButton;
import com.rapidminer.tools.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class FileChooserUI
extends BasicFileChooserUI {
    public static final String FILECHOOSER_VIEW_TYPE = "FILECHOOSER_VIEW_TYPE";
    public static final String FILECHOOSER_VIEW_THUMBNAIL = I18N.getMessage(I18N.getGUIBundle(), "gui.menu.file_chooser.view.thumbnails.label", new Object[0]);
    public static final String FILECHOOSER_VIEW_ICON = I18N.getMessage(I18N.getGUIBundle(), "gui.menu.file_chooser.view.icons.label", new Object[0]);
    public static final String FILECHOOSER_VIEW_LIST = I18N.getMessage(I18N.getGUIBundle(), "gui.menu.file_chooser.view.list.label", new Object[0]);
    public static final String FILECHOOSER_VIEW_DETAILS = I18N.getMessage(I18N.getGUIBundle(), "gui.menu.file_chooser.view.details.label", new Object[0]);
    public static final Icon FILECHOOSER_OPEN_ICON = SwingTools.createIcon("24/folder.png");
    public static final Icon FILECHOOSER_SELECT_ICON = SwingTools.createIcon("24/folder.png");
    public static final Icon FILECHOOSER_SAVE_ICON = SwingTools.createIcon("24/floppy_disk.png");
    public static final Icon FILECHOOSER_CLOSE_ICON = SwingTools.createIcon("24/delete.png");
    public final transient Action NEW_FOLDER_ACTION = new NewFolderAction();
    public final Action CHANGE_VIEW_ACTION = new ChangeViewAction();
    public final Action ADD_TO_BOOKMARKS_ACTION = new BookmarkAction();
    public final Action GO_BACK_ACTION = new GoBackAction();
    public final Action GO_HOME_ACTION = new ResourceActionTransmitter("file_chooser.go_home", super.getGoHomeAction(), new Object[0]);
    public final Action CHANGE_TO_PARENT_DIRECTORY = new ChangeToParentDirectoryAction();
    private static File userHomeDirectory;
    private static final int INDENT_SPACE = 10;
    private ButtonGroup changeViewButtonGroup;
    public String viewType = FILECHOOSER_VIEW_DETAILS;
    protected Vector<String> backPathVector = new Vector();
    protected JButton bookmarksButton;
    private JPopupMenu changeViewPopup;
    private final Border roundComboboxListRendererBorder = Borders.getComboBoxListCellRendererFocusBorder();
    private DropDownButton changeViewButton;
    protected FileList fileList;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private BasicFileChooserUI.BasicFileView fileView = new RapidLookFileView();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action approveSelectionAction = new ExtendedApproveSelectionAction();
    private boolean selected = false;
    private LinkedList<ChangeListener> listeners = new LinkedList();

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    protected ActionMap createActions() {
        AbstractAction escAction = new AbstractAction(){
            private static final long serialVersionUID = -3976059968191425942L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserUI.this.fileList.stopThumbnailGeneration();
                FileChooserUI.this.getFileChooser().cancelSelection();
            }

            @Override
            public boolean isEnabled() {
                return FileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        return map;
    }

    @Override
    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public String getView() {
        return this.viewType;
    }

    public static ComponentUI createUI(JComponent c) {
        return new FileChooserUI((JFileChooser)c);
    }

    public FileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
        this.fileList = null;
        super.uninstallComponents(fc);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        FileSystemView fsv = fc.getFileSystemView();
        userHomeDirectory = fsv.getHomeDirectory();
        this.changeViewPopup = this.createViewPopupMenu();
        fc.setLayout(new BorderLayout());
        ExtendedJToolBar topPanel = new ExtendedJToolBar();
        topPanel.setFloatable(false);
        topPanel.setBorder(null);
        topPanel.setOpaque(false);
        JPanel panel = new JPanel(new BorderLayout(0, 6));
        panel.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.setOpaque(false);
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setMaximumRowCount(9);
        topPanel.add(this.directoryComboBox);
        topPanel.addSeparator();
        JButton backButton = new JButton(this.GO_BACK_ACTION);
        backButton.setText(null);
        backButton.setRolloverEnabled(true);
        backButton.setIcon((Icon)this.GO_BACK_ACTION.getValue("SmallIcon"));
        backButton.setToolTipText((String)this.GO_BACK_ACTION.getValue("ShortDescription"));
        backButton.getAccessibleContext().setAccessibleName((String)this.GO_BACK_ACTION.getValue("AcceleratorKey"));
        backButton.setAlignmentX(0.0f);
        backButton.setAlignmentY(0.5f);
        backButton.setBackground((Color)UIManager.get("control"));
        backButton.setOpaque(false);
        backButton.setFocusable(false);
        topPanel.add(backButton);
        JButton upFolderButton = new JButton(this.CHANGE_TO_PARENT_DIRECTORY);
        upFolderButton.setText(null);
        upFolderButton.setRolloverEnabled(true);
        upFolderButton.setIcon((Icon)this.CHANGE_TO_PARENT_DIRECTORY.getValue("SmallIcon"));
        upFolderButton.setToolTipText((String)this.CHANGE_TO_PARENT_DIRECTORY.getValue("ShortDescription"));
        upFolderButton.getAccessibleContext().setAccessibleName((String)this.CHANGE_TO_PARENT_DIRECTORY.getValue("AcceleratorKey"));
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setBackground((Color)UIManager.get("control"));
        upFolderButton.setFocusable(false);
        upFolderButton.setOpaque(false);
        topPanel.add(upFolderButton);
        this.bookmarksButton = new JButton(this.ADD_TO_BOOKMARKS_ACTION);
        this.bookmarksButton.setText(null);
        this.bookmarksButton.setRolloverEnabled(true);
        this.bookmarksButton.setOpaque(false);
        this.bookmarksButton.setIcon((Icon)this.ADD_TO_BOOKMARKS_ACTION.getValue("SmallIcon"));
        this.bookmarksButton.setFocusable(false);
        this.bookmarksButton.setToolTipText((String)this.ADD_TO_BOOKMARKS_ACTION.getValue("ShortDescription"));
        this.bookmarksButton.getAccessibleContext().setAccessibleName((String)this.ADD_TO_BOOKMARKS_ACTION.getValue("AcceleratorKey"));
        this.bookmarksButton.setAlignmentX(0.0f);
        this.bookmarksButton.setAlignmentY(0.5f);
        this.bookmarksButton.setBackground((Color)UIManager.get("control"));
        topPanel.add(this.bookmarksButton);
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = (String)this.GO_HOME_ACTION.getValue("ShortDescription");
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.GO_HOME_ACTION);
        b.setText("");
        b.setRolloverEnabled(true);
        b.setIcon((Icon)this.GO_HOME_ACTION.getValue("SmallIcon"));
        b.setToolTipText(toolTipText);
        b.getAccessibleContext().setAccessibleName((String)this.GO_HOME_ACTION.getValue("AcceleratorKey"));
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setFocusable(false);
        b.setOpaque(false);
        topPanel.add(b);
        b = new JButton(this.NEW_FOLDER_ACTION);
        b.setText(null);
        b.setRolloverEnabled(true);
        b.setIcon((Icon)this.NEW_FOLDER_ACTION.getValue("SmallIcon"));
        b.setOpaque(false);
        b.setFocusable(false);
        b.setToolTipText((String)this.NEW_FOLDER_ACTION.getValue("ShortDescription"));
        b.getAccessibleContext().setAccessibleName((String)this.NEW_FOLDER_ACTION.getValue("AcceleratorKey"));
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        topPanel.add(b);
        this.changeViewButton = new DropDownButton(this.CHANGE_VIEW_ACTION){
            private static final long serialVersionUID = -2115601230879074911L;

            @Override
            protected JPopupMenu getPopupMenu() {
                return FileChooserUI.this.changeViewPopup;
            }
        };
        this.changeViewButton.setText(null);
        this.changeViewButton.setRolloverEnabled(true);
        this.changeViewButton.setIcon((Icon)this.CHANGE_VIEW_ACTION.getValue("SmallIcon"));
        this.changeViewButton.setToolTipText((String)this.CHANGE_VIEW_ACTION.getValue("ShortDescription"));
        this.changeViewButton.getAccessibleContext().setAccessibleName((String)this.CHANGE_VIEW_ACTION.getValue("AcceleratorKey"));
        this.changeViewButton.setAlignmentX(0.0f);
        this.changeViewButton.setAlignmentY(0.5f);
        this.changeViewButton.setBackground((Color)UIManager.get("control"));
        this.changeViewButton.setOpaque(false);
        this.changeViewButton.setFocusable(false);
        this.changeViewButton.addToToolBar(topPanel);
        topPanel.setBackground((Color)UIManager.get("control"));
        this.fileList = new FileList(this, fc);
        fc.addPropertyChangeListener(this.fileList);
        this.fileList.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        panel.add((Component)this.fileList, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBorder(null);
        panel.add((Component)bottomPanel, "South");
        fc.add((Component)panel, "Center");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setOpaque(false);
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(new Dimension(1, 6)));
        AlignedLabel fileNameLabel = new AlignedLabel(this.fileNameLabelText);
        fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fileNamePanel.add(fileNameLabel);
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.setPreferredSize(new Dimension(this.fileNameTextField.getWidth(), 26));
        this.fileNameTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FileChooserUI.this.setFileSelected();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        fileNamePanel.add(this.fileNameTextField);
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setOpaque(false);
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.setPreferredSize(new Dimension(this.filterComboBox.getWidth(), 26));
        this.filterComboBox.setOpaque(false);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        fc.add((Component)this.getBottomPanel(), "South");
        this.getButtonPanel().setLayout(new FlowLayout(2));
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.setOpaque(false);
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.approveButton.setIcon(this.getApproveButtonIcon(fc));
        this.approveButton.setEnabled(false);
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText, FILECHOOSER_CLOSE_ICON);
        this.cancelButton.setOpaque(false);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        FileChooserUI.groupLabels(new AlignedLabel[]{fileNameLabel, filesOfTypeLabel});
        this.updateView(FILECHOOSER_VIEW_DETAILS);
    }

    @Override
    public Action getNewFolderAction() {
        NewFolderAction newFolderAction = new NewFolderAction();
        if (UIManager.getBoolean("FileChooser.readOnly")) {
            newFolderAction.setEnabled(false);
        }
        return newFolderAction;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.buttonPanel.setOpaque(false);
            this.buttonPanel.setBorder(null);
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.bottomPanel.setOpaque(false);
            this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
            this.bottomPanel.setBorder(null);
        }
        return this.bottomPanel;
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActions();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActions() {
        return this.createActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void setFileSelected() {
        this.selected = this.fileNameTextField.getText() != null && !"".equals(this.fileNameTextField.getText());
        this.approveButton.setEnabled(this.selected);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean isFileSelected() {
        return this.selected;
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        } else {
            this.setFileName("");
        }
        this.setFileSelected();
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        this.fileList.updatePath(currentDirectory);
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            this.getGoHomeAction().setEnabled(!userHomeDirectory.equals(currentDirectory));
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
                this.setFileSelected();
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.fileList.doFilterChanged();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.doFilterChanged(e);
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
        this.setFileSelected();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (!this.getFileChooser().isMultiSelectionEnabled()) {
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private Icon getApproveButtonIcon(JFileChooser fc) {
        if (fc.getDialogType() == 0) {
            return FILECHOOSER_OPEN_ICON;
        }
        if (fc.getDialogType() == 1) {
            return FILECHOOSER_SAVE_ICON;
        }
        if (fc.getDialogType() == 2) {
            return FILECHOOSER_SELECT_ICON;
        }
        return FILECHOOSER_SELECT_ICON;
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        this.approveButton.setIcon(this.getApproveButtonIcon(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        this.approveButton.setIcon(this.getApproveButtonIcon(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    FileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    FileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    FileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    FileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    FileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    FileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    FileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    FileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    FileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    FileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    FileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("FileHidingChanged")) {
                    FileChooserUI.this.fileList.doFilterChanged();
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    FileChooserUI.this.fileNameTextField.selectAll();
                    FileChooserUI.this.fileList.itemPanel.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    public JButton getApproveButton() {
        return this.approveButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.fileList.rescanDirectory();
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    @Override
    public String getDirectoryName() {
        return null;
    }

    @Override
    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
            this.setFileSelected();
        }
    }

    protected void setCurrentDirectoryOfFileChooser(File f) {
        this.getFileChooser().setCurrentDirectory(f);
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] group) {
        for (AlignedLabel element : group) {
            AlignedLabel.access$2602(element, group);
        }
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    public void goBack() {
        if (this.backPathVector.size() > 0) {
            this.setCurrentDirectoryOfFileChooser(new File(this.backPathVector.elementAt(this.backPathVector.size() - 1)));
            if (this.backPathVector.size() > 1) {
                this.backPathVector.setSize(this.backPathVector.size() - 2);
            } else {
                this.backPathVector.setSize(this.backPathVector.size() - 1);
            }
            if (this.backPathVector.size() <= 0) {
                this.getGoBackAction().setEnabled(false);
            }
        }
    }

    public Action getGoBackAction() {
        return this.GO_BACK_ACTION;
    }

    @Override
    public Action getGoHomeAction() {
        return this.GO_HOME_ACTION;
    }

    @Override
    public Action getChangeToParentDirectoryAction() {
        return this.CHANGE_TO_PARENT_DIRECTORY;
    }

    public JPopupMenu createViewPopupMenu() {
        changeViewActionListener mal = new changeViewActionListener();
        this.changeViewPopup = new JPopupMenu();
        this.changeViewButtonGroup = new ButtonGroup();
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(FILECHOOSER_VIEW_THUMBNAIL);
        this.changeViewButtonGroup.add(menuItem);
        menuItem.setActionCommand(FILECHOOSER_VIEW_THUMBNAIL);
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem(FILECHOOSER_VIEW_ICON);
        menuItem.setActionCommand(FILECHOOSER_VIEW_ICON);
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem(FILECHOOSER_VIEW_LIST);
        menuItem.setActionCommand(FILECHOOSER_VIEW_LIST);
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        menuItem.setSelected(true);
        this.changeViewPopup.add(menuItem);
        menuItem = new JRadioButtonMenuItem(FILECHOOSER_VIEW_DETAILS);
        menuItem.setActionCommand(FILECHOOSER_VIEW_DETAILS);
        this.changeViewButtonGroup.add(menuItem);
        menuItem.addActionListener(mal);
        this.changeViewPopup.add(menuItem);
        return this.changeViewPopup;
    }

    protected void updateView(String s) {
        if (!(s.equals(FILECHOOSER_VIEW_DETAILS) || s.equals(FILECHOOSER_VIEW_ICON) || s.equals(FILECHOOSER_VIEW_LIST) || s.equals(FILECHOOSER_VIEW_THUMBNAIL))) {
            return;
        }
        this.viewType = s;
        this.fileList.changeCardForView();
        Enumeration<AbstractButton> en = this.changeViewButtonGroup.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbm = (JRadioButtonMenuItem)en.nextElement();
            if (!rbm.getActionCommand().equals(this.getView())) continue;
            this.changeViewButtonGroup.setSelected(rbm.getModel(), true);
        }
    }

    private static class ChangeViewAction
    extends ResourceActionAdapter {
        private static final long serialVersionUID = 6720057807081456009L;

        public ChangeViewAction() {
            super("file_chooser.view", new Object[0]);
        }
    }

    private class changeViewActionListener
    implements ActionListener {
        private changeViewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.updateView(e.getActionCommand());
        }
    }

    private class ChangeToParentDirectoryAction
    extends ResourceAction {
        private static final long serialVersionUID = -3805300411336163058L;

        protected ChangeToParentDirectoryAction() {
            super("file_chooser.change_to_parent_directory", new Object[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.getFileChooser().changeToParentDirectory();
        }
    }

    private class ExtendedApproveSelectionAction
    extends BasicFileChooserUI.ApproveSelectionAction {
        private static final long serialVersionUID = 4061933557078579689L;

        private ExtendedApproveSelectionAction() {
            super(FileChooserUI.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.fileList.stopThumbnailGeneration();
            super.actionPerformed(e);
        }
    }

    private class CancelSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 2080395201063859907L;

        private CancelSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.fileList.stopThumbnailGeneration();
            FileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    private class GoBackAction
    extends ResourceAction {
        private static final long serialVersionUID = 5132122622014626886L;

        protected GoBackAction() {
            super("file_chooser.go_back", new Object[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.goBack();
        }
    }

    private class BookmarkAction
    extends ResourceAction {
        private static final long serialVersionUID = -654304868192207741L;

        public BookmarkAction() {
            super("file_chooser.add_to_bookmarks", new Object[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserUI.this.fileList.addToBookmarks();
        }
    }

    private class RapidLookFileView
    extends BasicFileChooserUI.BasicFileView {
        private RapidLookFileView() {
            super(FileChooserUI.this);
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (f != null) {
                icon = FileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f);
            }
            if (icon == null) {
                icon = super.getIcon(f);
            }
            this.cacheIcon(f, icon);
            return icon;
        }
    }

    private class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4597909127976297943L;
        private IndentIcon indentIcon = new IndentIcon();

        private DirectoryComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(FileChooserUI.this.getFileChooser().getName(directory));
            Icon icon = FileChooserUI.this.getFileChooser().getIcon(directory);
            if (icon == null) {
                icon = UIManager.getIcon("FileChooser.defaultDirectoryIcon");
            }
            this.indentIcon.icon = icon;
            this.indentIcon.depth = FileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.indentIcon);
            if (isSelected && index > -1) {
                this.setBorder(FileChooserUI.this.roundComboboxListRendererBorder);
            }
            return this;
        }
    }

    private static class IndentIcon
    implements Icon {
        private Icon icon;
        private int depth = 0;

        private IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(c, g, x + this.depth * 10, y);
                } else {
                    this.icon.paintIcon(c, g, x, y);
                }
            }
        }

        @Override
        public int getIconWidth() {
            if (this.icon == null) {
                return this.depth * 10;
            }
            return this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            if (this.icon == null) {
                return 0;
            }
            return this.icon.getIconHeight();
        }
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = -7566898679781533334L;
        private Vector<File> directories = new Vector();
        private int[] depths = null;
        private File selectedDirectory = null;
        private JFileChooser chooser = FileChooserUI.this.getFileChooser();
        private FileSystemView fileSystemView = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = FileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = this.fileSystemView.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                ShellFolder sf;
                File f = sf = ShellFolder.getShellFolder(canonical);
                Vector<ShellFolder> path = new Vector<ShellFolder>(10);
                do {
                    path.addElement((ShellFolder)f);
                } while ((f = ((File)f).getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    private class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 7024419790190737084L;

        private FilterComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            if (isSelected && index > -1) {
                this.setBorder(FileChooserUI.this.roundComboboxListRendererBorder);
            }
            return this;
        }
    }

    private class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private static final long serialVersionUID = -7578988904254755349L;
        private FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = FileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                FileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                FileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = FileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (FileFilter element : this.filters) {
                    if (element != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    FileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return FileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return FileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    private class DirectoryComboBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = -6851838331146924117L;

        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = (File)FileChooserUI.this.directoryComboBox.getSelectedItem();
            FileChooserUI.this.setCurrentDirectoryOfFileChooser(f);
            FileChooserUI.this.fileNameTextField.requestFocus();
        }
    }

    private static class AlignedLabel
    extends JLabel {
        private static final long serialVersionUID = 4912090609095372381L;
        private AlignedLabel[] group;
        private int maxWidth = 0;

        AlignedLabel(String text) {
            super(text);
            this.setAlignmentX(0.0f);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth(), d.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int max = 0;
                for (AlignedLabel element : this.group) {
                    max = Math.max(element.getSuperPreferredWidth(), max);
                }
                for (AlignedLabel element : this.group) {
                    element.maxWidth = max;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            if (this.getText() == null) {
                return super.getPreferredSize().width;
            }
            return super.getPreferredSize().width + 11;
        }

        static /* synthetic */ AlignedLabel[] access$2602(AlignedLabel x0, AlignedLabel[] x1) {
            x0.group = x1;
            return x1;
        }
    }

    private class NewFolderAction
    extends ResourceAction {
        private static final long serialVersionUID = -119998626996460617L;

        protected NewFolderAction() {
            super("file_chooser.new_folder", new Object[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UIManager.getBoolean("FileChooser.readOnly")) {
                return;
            }
            JFileChooser fc = FileChooserUI.this.getFileChooser();
            File currentDirectory = fc.getCurrentDirectory();
            File newFolder = null;
            String name = SwingTools.showInputDialog("file_chooser.new_folder", "", new Object[0]);
            try {
                if (name != null && !"".equals(name)) {
                    newFolder = fc.getFileSystemView().createNewFolder(currentDirectory);
                    if (newFolder.renameTo(new File(newFolder.getParentFile(), name))) {
                        newFolder = new File(newFolder.getParentFile(), name);
                    } else {
                        SwingTools.showVerySimpleErrorMessage("file_chooser.new_folder.rename", name);
                    }
                }
            }
            catch (IOException exc) {
                SwingTools.showVerySimpleErrorMessage("file_chooser.new_folder.create", name);
                return;
            }
            catch (Exception exp) {
                // empty catch block
            }
            if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(new File[]{newFolder});
            } else {
                fc.setSelectedFile(newFolder);
            }
            fc.rescanCurrentDirectory();
        }
    }
}

