/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.fc.Bookmark;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileSystemView;

public class BookmarkIO {
    public static final String PROPERTY_BOOKMARKS_DIR = "bookmarks.dir";
    public static final String PROPERTY_BOOKMARKS_FILE = ".bookmarks";
    private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private File bookmarkFile;
    private List<Bookmark> bookmarks = new LinkedList<Bookmark>();

    public BookmarkIO() {
        File applicationSpecifiedDir;
        File tempFile = this.fileSystemView.getHomeDirectory();
        tempFile = tempFile.getAbsoluteFile();
        File parentTempFile = tempFile.getParentFile();
        String bookmarksDirProperty = System.getProperty(PROPERTY_BOOKMARKS_DIR);
        if (bookmarksDirProperty != null && bookmarksDirProperty.length() > 0 && (applicationSpecifiedDir = new File(bookmarksDirProperty)).exists()) {
            parentTempFile = applicationSpecifiedDir;
        }
        try {
            parentTempFile = parentTempFile.getCanonicalFile();
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (parentTempFile != null && parentTempFile.exists() && this.fileSystemView.isTraversable(parentTempFile).booleanValue()) {
            this.bookmarkFile = new File(parentTempFile, PROPERTY_BOOKMARKS_FILE);
            try {
                this.bookmarkFile.createNewFile();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            if (!this.bookmarkFile.exists()) {
                this.bookmarkFile.delete();
                this.bookmarkFile = new File(tempFile, PROPERTY_BOOKMARKS_FILE);
            }
        } else {
            this.bookmarkFile = new File(tempFile, PROPERTY_BOOKMARKS_FILE);
        }
        if (!this.bookmarkFile.exists()) {
            try {
                this.bookmarkFile.createNewFile();
            }
            catch (IOException ex) {}
        } else {
            this.bookmarks = BookmarkIO.readBookmarks(this.bookmarkFile);
        }
    }

    public Collection<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public void addToList(String name, String path) {
        Bookmark bookmark = new Bookmark(name, path);
        this.bookmarks.add(bookmark);
        Collections.sort(this.bookmarks);
        BookmarkIO.writeBookmarks(this.bookmarks, this.bookmarkFile);
    }

    public void deleteBookmark(Bookmark bookmark) {
        this.bookmarks.remove(bookmark);
        if (bookmark != null) {
            BookmarkIO.writeBookmarks(this.bookmarks, this.bookmarkFile);
        }
    }

    public void renameBookmark(Bookmark bookmark, String name) {
        if (bookmark != null) {
            bookmark.setName(name);
            BookmarkIO.writeBookmarks(this.bookmarks, this.bookmarkFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Bookmark> readBookmarks(File bookmarkFile) {
        LinkedList<Bookmark> bookmarks = new LinkedList<Bookmark>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(bookmarkFile));
            String line = in.readLine();
            if (line != null) {
                int numberOfBookmarks = Integer.parseInt(line);
                for (int i = 0; i < numberOfBookmarks; ++i) {
                    String name = in.readLine();
                    String path = in.readLine();
                    if (name == null || path == null) continue;
                    bookmarks.add(new Bookmark(name, path));
                }
            }
            in.close();
            Collections.sort(bookmarks);
        }
        catch (Exception e) {
            bookmarks.clear();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBookmarks(Collection<Bookmark> bookmarks, File bookmarkFile) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(bookmarkFile));
            out.println(bookmarks.size());
            for (Bookmark bookmark : bookmarks) {
                out.println(bookmark.getName());
                out.println(bookmark.getPath());
            }
            out.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

