/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.fc.FileChooserUI;
import com.rapidminer.gui.look.fc.Item;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class AutomaticTextField
extends JTextField
implements KeyListener,
CaretListener,
InputMethodListener {
    private static final long serialVersionUID = 9138792080755085206L;
    private FileChooserUI fileChooserUI;
    private JList itemList = new JList<Object>(new Object[0]);
    private JPopupMenu popupMenu = new JPopupMenu();
    private Vector<String> fileList = new Vector();
    private int caretPosition = 0;
    private String mainText;

    public AutomaticTextField(FileChooserUI fcui) {
        this.fileChooserUI = fcui;
        this.addCaretListener(this);
        this.addKeyListener(this);
    }

    private Vector findItems() {
        if (this.mainText == null) {
            this.mainText = this.getText();
        }
        this.fileList.removeAllElements();
        Enumeration<Item> en = this.fileChooserUI.fileList.visibleItemsList.elements();
        while (en.hasMoreElements()) {
            Item vi = en.nextElement();
            if (!vi.getFileName().toLowerCase().startsWith(this.mainText.toLowerCase().substring(0, Math.min(this.caretPosition, this.mainText.length())))) continue;
            this.fileList.add(vi.getFileName());
        }
        return this.fileList;
    }

    private void generatePopup(boolean help) {
        this.popupMenu.setVisible(false);
        this.popupMenu.removeAll();
        final AutomaticTextField t = this;
        this.popupMenu.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().toLowerCase().equals("visible") && e.getNewValue().toString().toLowerCase().equals("false")) {
                    AutomaticTextField.this.mainText = t.getText();
                }
            }
        });
        this.itemList = new JList(this.findItems());
        this.itemList.setSelectionMode(0);
        this.itemList.setBorder(null);
        this.itemList.setAutoscrolls(true);
        this.itemList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AutomaticTextField.this.popupMenu.setVisible(false);
                t.setSelectionEnd(0);
                t.setCaretPosition(t.getText().length());
            }
        });
        this.itemList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    AutomaticTextField.this.popupMenu.setVisible(false);
                    t.setSelectionEnd(0);
                    t.setText(AutomaticTextField.this.mainText);
                    t.setCaretPosition(t.getText().length());
                } else if (e.getKeyCode() == 10) {
                    AutomaticTextField.this.popupMenu.setVisible(false);
                    t.setSelectionEnd(0);
                    t.setCaretPosition(t.getText().length());
                }
            }
        });
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AutomaticTextField.this.itemList.scrollRectToVisible(AutomaticTextField.this.itemList.getCellBounds(AutomaticTextField.this.itemList.getSelectedIndex(), AutomaticTextField.this.itemList.getSelectedIndex()));
                String cpt = AutomaticTextField.this.mainText;
                try {
                    cpt = t.getText(AutomaticTextField.this.caretPosition, t.getText().length() - AutomaticTextField.this.caretPosition);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (!AutomaticTextField.this.itemList.getModel().getElementAt(AutomaticTextField.this.itemList.getSelectedIndex()).toString().equals(cpt)) {
                    t.setText(AutomaticTextField.this.itemList.getModel().getElementAt(AutomaticTextField.this.itemList.getSelectedIndex()).toString());
                    t.setCaretPosition(AutomaticTextField.this.caretPosition);
                    if (AutomaticTextField.this.caretPosition == 0 || !t.getText().toLowerCase().startsWith(AutomaticTextField.this.mainText.toLowerCase())) {
                        t.select(0, t.getText().length());
                    } else {
                        t.select(AutomaticTextField.this.mainText.length(), t.getText().length());
                    }
                }
            }
        });
        JScrollPane scroller = new JScrollPane(this.itemList);
        scroller.setBorder(null);
        scroller.setFocusable(false);
        this.popupMenu.add(scroller);
        int h = 30;
        try {
            if (this.itemList.getModel().getSize() > 0) {
                h = (int)((double)this.itemList.getModel().getSize() * this.itemList.getCellBounds(0, 0).getHeight()) + 10;
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        this.popupMenu.setPopupSize(this.getWidth() - 6, Math.min(100, h));
        if (this.itemList.getModel().getSize() > 0) {
            this.popupMenu.show(this, 3, this.getHeight() - 2);
            if (help) {
                this.itemList.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.popupMenu.setVisible(false);
            this.setSelectionEnd(0);
            this.setCaretPosition(this.getText().length());
            this.mainText = this.getText();
        } else if (e.getKeyCode() == 27) {
            if (this.popupMenu.isVisible()) {
                this.setText(this.mainText);
                this.popupMenu.setVisible(false);
                this.setSelectionEnd(0);
                this.setCaretPosition(this.getText().length());
                e.consume();
            }
        } else if (e.getKeyCode() == 37) {
            this.caretPosition = this.getCaretPosition();
            this.generatePopup(false);
            this.requestFocus();
        } else if (e.getKeyCode() == 39) {
            this.caretPosition = this.getCaretPosition();
            this.generatePopup(false);
            if (!this.popupMenu.isVisible()) {
                this.setText(this.mainText);
                this.setCaretPosition(this.caretPosition);
            }
            this.requestFocus();
        } else if (e.getKeyCode() == 38) {
            if (!this.popupMenu.isVisible()) {
                this.generatePopup(true);
            }
            int n = this.itemList.getSelectedIndex();
            if (--n < 0) {
                n = 0;
            }
            this.itemList.setSelectedIndex(n);
            this.requestFocus();
        } else if (e.getKeyCode() == 40) {
            if (!this.popupMenu.isVisible()) {
                this.generatePopup(true);
            }
            int n = this.itemList.getSelectedIndex();
            if (++n >= this.itemList.getModel().getSize()) {
                n = this.itemList.getModel().getSize() - 1;
            }
            this.itemList.setSelectedIndex(n);
            this.requestFocus();
        } else if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
            e.consume();
            this.mainText = this.getText();
            this.requestFocus();
        }
        if (e.isActionKey() && this.popupMenu.isVisible()) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 8) {
            e.consume();
        } else if (!e.isActionKey()) {
            this.mainText = this.getText();
            this.generatePopup(true);
            this.requestFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 8) {
            e.consume();
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.caretPosition = e.getDot();
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
    }
}

