/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.borders;

import com.rapidminer.gui.look.RoundedPopupFactory;
import com.rapidminer.gui.look.borders.ShadowedPopupMenuBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class PopupBorder
extends AbstractBorder
implements UIResource {
    private static final long serialVersionUID = -6179692340222478237L;
    private Image bottomLeft;
    private Image bottomRight;
    private Image right;
    private Image bottom;

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        JComponent popup = (JComponent)c;
        g.translate(x, y);
        try {
            this.bottomLeft = (Image)popup.getClientProperty(RoundedPopupFactory.BOTTOM_LEFT_PIC);
            if (this.bottomLeft != null) {
                g.drawImage(this.bottomLeft, 0, h - 5, c);
            }
            this.bottomRight = (Image)popup.getClientProperty(RoundedPopupFactory.BOTTOM_RIGHT_PIC);
            if (this.bottomRight != null) {
                g.drawImage(this.bottomRight, w - 5, h - 5, c);
            }
            this.right = (Image)popup.getClientProperty(RoundedPopupFactory.RIGHT_PIC);
            if (this.right != null) {
                g.drawImage(this.right, w - 1, 0, c);
            }
            this.bottom = (Image)popup.getClientProperty(RoundedPopupFactory.BOTTOM_PIC);
            if (this.bottom != null) {
                g.drawImage(this.bottom, 5, h - 1, c);
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        if (ShadowedPopupMenuBorder.POPUP_BOTTOM_LEFT != null) {
            g.drawImage(ShadowedPopupMenuBorder.POPUP_BOTTOM_LEFT, 0, h - 5, popup);
        }
        if (ShadowedPopupMenuBorder.POPUP_BOTTOM_RIGHT != null) {
            g.drawImage(ShadowedPopupMenuBorder.POPUP_BOTTOM_RIGHT, w - 5, h - 5, popup);
        }
        ColorUIResource c1 = new ColorUIResource(150, 150, 150);
        Color c4 = new Color(160, 160, 160, 100);
        ColorUIResource c2 = new ColorUIResource(135, 135, 135);
        g.setColor(UIManager.getColor("MenuItem.background"));
        g.drawLine(1, 0, w - 4, 0);
        g.drawLine(1, 1, w - 4, 1);
        g.drawLine(1, 0, 1, h - 7);
        g.drawLine(5, h - 3, w - 6, h - 3);
        g.setColor(UIManager.getColor("MenuItem.fadingColor"));
        g.drawLine(w - 3, 2, w - 3, h - 5);
        g.setColor(c1);
        g.drawLine(0, 0, 0, h - 6);
        g.setColor(c4);
        g.drawLine(5, h - 1, w - 6, h - 1);
        g.drawLine(w - 1, 2, w - 1, h - 6);
        g.setColor(c2);
        g.drawLine(w - 2, 0, w - 2, h - 6);
        g.drawLine(5, h - 2, w - 6, h - 2);
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 3, 3);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = 2;
        insets.top = 2;
        insets.bottom = 3;
        insets.right = 3;
        return insets;
    }
}

