/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look;

import com.rapidminer.gui.look.RapidLookAndFeel;
import com.rapidminer.gui.look.ToolbarHandlerBuffer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;

public class ToolbarHandlerIcon
implements Icon {
    private int xBumps;
    private int yBumps;
    private Color topColor;
    private Color shadowColor;
    private static List<ToolbarHandlerBuffer> buffers = new LinkedList<ToolbarHandlerBuffer>();
    private ToolbarHandlerBuffer buffer;

    public ToolbarHandlerIcon(Dimension bumpArea) {
        this(bumpArea.width, bumpArea.height);
    }

    public ToolbarHandlerIcon(int width, int height) {
        this(width, height, RapidLookAndFeel.getPrimaryControlHighlight(), RapidLookAndFeel.getPrimaryControlDarkShadow());
    }

    public ToolbarHandlerIcon(int width, int height, Color newTopColor, Color newShadowColor) {
        this.setBumpArea(width, height);
        this.setBumpColors(newTopColor, newShadowColor);
    }

    private ToolbarHandlerBuffer getBuffer(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(gc, aTopColor, aShadowColor)) {
            return this.buffer;
        }
        ToolbarHandlerBuffer result = null;
        for (ToolbarHandlerBuffer toolbarHandlerBuffer : buffers) {
            if (!toolbarHandlerBuffer.hasSameConfiguration(gc, aTopColor, aShadowColor)) continue;
            result = toolbarHandlerBuffer;
            break;
        }
        if (result == null) {
            result = new ToolbarHandlerBuffer(gc, this.topColor, this.shadowColor);
            buffers.add(result);
        }
        return result;
    }

    public void setBumpArea(Dimension bumpArea) {
        this.setBumpArea(bumpArea.width, bumpArea.height);
    }

    public void setBumpArea(int width, int height) {
        this.xBumps = width / 2;
        this.yBumps = height / 2;
    }

    public void setBumpColors(Color newTopColor, Color newShadowColor) {
        this.topColor = newTopColor;
        this.shadowColor = newShadowColor;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        GraphicsConfiguration gc = g instanceof Graphics2D ? ((Graphics2D)g).getDeviceConfiguration() : null;
        this.buffer = this.getBuffer(gc, this.topColor, this.shadowColor);
        int bufferWidth = this.buffer.getImageSize().width;
        int bufferHeight = this.buffer.getImageSize().height;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x2 = x + iconWidth;
        int y2 = y + iconHeight;
        int savex = x;
        while (y < y2) {
            int h = Math.min(y2 - y, bufferHeight);
            for (x = savex; x < x2; x += bufferWidth) {
                int w = Math.min(x2 - x, bufferWidth);
                g.drawImage(this.buffer.getImage(), x, y, x + w, y + h, 0, 0, w, h, null);
            }
            y += bufferHeight;
        }
    }

    @Override
    public int getIconWidth() {
        return this.xBumps * 2;
    }

    @Override
    public int getIconHeight() {
        return this.yBumps * 2;
    }
}

