/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

public class ToolbarHandlerBuffer {
    private static final int IMAGE_SIZE = 64;
    private static Dimension imageSize = new Dimension(64, 64);
    private transient Image image;
    private Color topColor;
    private Color shadowColor;
    private GraphicsConfiguration gc;

    public ToolbarHandlerBuffer(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor) {
        this.gc = gc;
        this.topColor = aTopColor;
        this.shadowColor = aShadowColor;
        this.createImage();
        this.fillBumpBuffer();
    }

    public boolean hasSameConfiguration(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor) {
        if (this.gc != null ? !this.gc.equals(gc) : gc != null) {
            return false;
        }
        return this.topColor.equals(aTopColor) && this.shadowColor.equals(aShadowColor);
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    private void fillBumpBuffer() {
        int y;
        int x;
        Graphics g = this.image.getGraphics();
        g.setColor(this.topColor);
        for (x = 0; x < 64; x += 2) {
            for (y = 0; y < 64; y += 4) {
                g.drawLine(x, y, x, y);
            }
        }
        g.setColor(this.shadowColor);
        for (x = 0; x < 64; x += 2) {
            for (y = 0; y < 64; y += 4) {
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
            }
        }
        g.dispose();
    }

    private void createImage() {
        if (this.gc != null) {
            this.image = this.gc.createCompatibleImage(64, 64, 2);
        } else {
            int[] cmap = new int[]{this.topColor.getRGB(), this.shadowColor.getRGB()};
            IndexColorModel icm = new IndexColorModel(8, 3, cmap, 0, false, -1, 0);
            this.image = new BufferedImage(64, 64, 13, icm);
        }
    }
}

