/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look;

import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public final class TextActions {
    public static final String CLEAR_ALL_ACTION = "Clear All";
    public static final String SELECT_ALL_ACTION = "Select All";
    public static final String DELETE_TEXT_ACTION = "Delete";

    public static class ClearAction
    extends TextAction {
        private static final long serialVersionUID = -8717559424063560794L;

        public ClearAction() {
            super(TextActions.CLEAR_ALL_ACTION);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            boolean beep = true;
            if (target != null && target.isEditable()) {
                try {
                    Document doc = target.getDocument();
                    int ss = 0;
                    int se = doc.getLength();
                    if (ss != se) {
                        doc.remove(ss, se - ss);
                        beep = false;
                    }
                }
                catch (BadLocationException bl) {
                    // empty catch block
                }
            }
            if (beep) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
            }
        }
    }

    public static class DeleteTextAction
    extends TextAction {
        private static final long serialVersionUID = 6412033584635198994L;

        public DeleteTextAction() {
            super(TextActions.DELETE_TEXT_ACTION);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            boolean beep = true;
            if (target != null && target.isEditable()) {
                try {
                    Document doc = target.getDocument();
                    int ss = target.getSelectionStart();
                    int se = target.getSelectionEnd();
                    if (ss != se) {
                        doc.remove(ss, se - ss);
                        beep = false;
                    }
                }
                catch (BadLocationException bl) {
                    // empty catch block
                }
            }
            if (beep) {
                UIManager.getLookAndFeel().provideErrorFeedback(target);
            }
        }
    }

    public static class SelectAllAction
    extends TextAction {
        private static final long serialVersionUID = 7009424030828006069L;

        public SelectAllAction() {
            super(TextActions.SELECT_ALL_ACTION);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                Document doc = target.getDocument();
                target.setCaretPosition(0);
                target.moveCaretPosition(doc.getLength());
            }
        }
    }
}

