/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look;

import com.rapidminer.gui.look.RoundedPopupFactory;
import com.rapidminer.gui.look.borders.Borders;
import com.rapidminer.gui.look.borders.DummyBorder;
import com.rapidminer.gui.look.borders.PopupBorder;
import com.rapidminer.gui.look.borders.ShadowedPopupMenuBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public final class RoundedRectanglePopup
extends Popup {
    private static final Rectangle rectangle = new Rectangle();
    private BufferedImage topRight;
    private BufferedImage topLeft;
    private BufferedImage bottomRight;
    private BufferedImage bottomLeft;
    private BufferedImage bottom;
    private BufferedImage right;
    private Dimension size;
    private Component contents;
    private int x;
    private int y;
    private Popup popup;
    private Robot robot;
    private Component owner;
    private static final Point point = new Point();
    private static Rectangle bufferRectangle = new Rectangle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Popup getInstance(Component owner, Component contents, int x, int y, Popup delegate) {
        Class<RoundedRectanglePopup> clazz = RoundedRectanglePopup.class;
        synchronized (RoundedRectanglePopup.class) {
            RoundedRectanglePopup popup = new RoundedRectanglePopup();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            popup.initPopup(owner, contents, x, y, delegate);
            return popup;
        }
    }

    @Override
    public void hide() {
        this.popup.hide();
        ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.BOTTOM_LEFT_PIC, null);
        ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.BOTTOM_RIGHT_PIC, null);
        ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.TOP_LEFT_PIC, null);
        ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.TOP_RIGHT_PIC, null);
        ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.RIGHT_PIC, null);
        ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.BOTTOM_PIC, null);
        this.contents = null;
        this.popup = null;
    }

    @Override
    public void show() {
        if (((JComponent)this.contents).getBorder() instanceof PopupBorder || ((JComponent)this.contents).getBorder() instanceof ShadowedPopupMenuBorder) {
            this.updatePics();
        }
        this.popup.show();
    }

    private void initPopup(Component owner, Component contents, int x, int y, Popup popup) {
        this.owner = owner;
        this.contents = contents;
        this.popup = popup;
        this.x = x;
        this.y = y;
        boolean mac = false;
        try {
            mac = System.getProperty("os.name").toLowerCase().startsWith("mac");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (mac) {
            ((JComponent)contents).setBorder(Borders.getPopupMenuBorder());
        } else if (((JComponent)contents).getBorder() instanceof DummyBorder) {
            if (!(owner instanceof JMenu && ((JMenu)owner).isTopLevelMenu() || owner.getParent() != null && owner.getParent() instanceof JToolBar || owner != null && owner instanceof JComboBox)) {
                ((JComponent)contents).setBorder(Borders.getShadowedPopupMenuBorder());
            } else {
                ((JComponent)contents).setBorder(Borders.getPopupBorder());
            }
        }
    }

    private void updatePics() {
        try {
            this.contents.requestFocus();
            this.robot = new Robot();
            this.size = this.contents.getPreferredSize();
            int w = this.size.width;
            int h = this.size.height;
            rectangle.setBounds(this.x, this.y, 5, 5);
            this.topLeft = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x + w - 5, this.y, 5, 5);
            this.topRight = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x, this.y + h - 5, 5, 5);
            this.bottomLeft = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x + w - 5, this.y + h - 5, 5, 5);
            this.bottomRight = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x + w - 1, this.y, 1, h - 5);
            this.right = this.robot.createScreenCapture(rectangle);
            rectangle.setBounds(this.x + 5, this.y + h - 1, w - 10, 1);
            this.bottom = this.robot.createScreenCapture(rectangle);
            Component layeredPane = this.getLayeredPane();
            if (layeredPane == null) {
                return;
            }
            RoundedRectanglePopup.point.x = this.x;
            RoundedRectanglePopup.point.y = this.y;
            SwingUtilities.convertPointFromScreen(point, layeredPane);
            bufferRectangle = new Rectangle(RoundedRectanglePopup.point.x, RoundedRectanglePopup.point.y, 5, 5);
            this.drawRemaining(bufferRectangle, layeredPane, this.topLeft);
            bufferRectangle = new Rectangle(RoundedRectanglePopup.point.x + w - 5, RoundedRectanglePopup.point.y, 5, 5);
            this.drawRemaining(bufferRectangle, layeredPane, this.topRight);
            bufferRectangle = new Rectangle(RoundedRectanglePopup.point.x, RoundedRectanglePopup.point.y + h - 5, 5, 5);
            this.drawRemaining(bufferRectangle, layeredPane, this.bottomLeft);
            bufferRectangle = new Rectangle(RoundedRectanglePopup.point.x + w - 5, RoundedRectanglePopup.point.y + h - 5, 5, 5);
            this.drawRemaining(bufferRectangle, layeredPane, this.bottomRight);
            bufferRectangle = new Rectangle(RoundedRectanglePopup.point.x + w - 1, RoundedRectanglePopup.point.y, 1, h - 5);
            this.drawRemaining(bufferRectangle, layeredPane, this.right);
            bufferRectangle = new Rectangle(RoundedRectanglePopup.point.x + 5, RoundedRectanglePopup.point.y + h - 1, w - 10, 1);
            this.drawRemaining(bufferRectangle, layeredPane, this.bottom);
            ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.BOTTOM_LEFT_PIC, this.bottomLeft);
            ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.BOTTOM_RIGHT_PIC, this.bottomRight);
            ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.TOP_LEFT_PIC, this.topLeft);
            ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.TOP_RIGHT_PIC, this.topRight);
            ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.RIGHT_PIC, this.right);
            ((JComponent)this.contents).putClientProperty(RoundedPopupFactory.BOTTOM_PIC, this.bottom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawRemaining(Rectangle rectangle, Component lp, BufferedImage pic) {
        if (rectangle.x + rectangle.width > lp.getWidth()) {
            rectangle.width = lp.getWidth() - rectangle.x;
        }
        if (rectangle.y + rectangle.height > lp.getHeight()) {
            rectangle.height = lp.getHeight() - rectangle.y;
        }
        if (!rectangle.isEmpty()) {
            Graphics2D g = pic.createGraphics();
            ((Graphics)g).translate(-rectangle.x, -rectangle.y);
            g.setClip(rectangle);
            boolean doubleBuffered = lp.isDoubleBuffered();
            if (lp instanceof JComponent) {
                ((JComponent)lp).setDoubleBuffered(false);
                lp.paint(g);
                ((JComponent)lp).setDoubleBuffered(doubleBuffered);
            } else {
                lp.paint(g);
            }
            g.dispose();
        }
    }

    private Component getLayeredPane() {
        Container parent = null;
        if (this.owner != null) {
            parent = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
        }
        for (Container p = parent; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                if (p.getParent() instanceof JInternalFrame) continue;
                parent = ((JRootPane)p).getLayeredPane();
                continue;
            }
            if (p instanceof Window) {
                if (parent != null) break;
                parent = p;
                break;
            }
            if (p instanceof JApplet) break;
        }
        return parent;
    }
}

