/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look;

import com.rapidminer.gui.look.TextActions;
import com.rapidminer.gui.tools.ResourceActionTransmitter;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class ClipboardActionsPopup
extends JPopupMenu {
    private static final long serialVersionUID = -6304527692064490218L;
    private JTextComponent parent;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem selectAllMenuItem;

    public ClipboardActionsPopup(JTextComponent parent) {
        this.parent = parent;
        this.cutMenuItem = new JMenuItem(new ResourceActionTransmitter("editor.cut", (Action)new DefaultEditorKit.CutAction(), new Object[0]));
        this.copyMenuItem = new JMenuItem(new ResourceActionTransmitter("editor.copy", (Action)new DefaultEditorKit.CopyAction(), new Object[0]));
        this.pasteMenuItem = new JMenuItem(new ResourceActionTransmitter("editor.paste", (Action)new DefaultEditorKit.PasteAction(), new Object[0]));
        this.deleteMenuItem = new JMenuItem(new ResourceActionTransmitter("editor.delete", (Action)new TextActions.DeleteTextAction(), new Object[0]));
        this.selectAllMenuItem = new JMenuItem(new ResourceActionTransmitter("editor.select_all", (Action)new TextActions.SelectAllAction(), new Object[0]));
        this.add(this.cutMenuItem);
        this.add(this.copyMenuItem);
        this.add(this.pasteMenuItem);
        this.add(this.deleteMenuItem);
        this.addSeparator();
        this.add(this.selectAllMenuItem);
    }

    protected final JTextComponent getTextComponent(Component c) {
        if (c != null && c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    @Override
    public void show(Component invoker, int x, int y) {
        JTextComponent target = this.getTextComponent(invoker);
        if (target == null) {
            return;
        }
        if (target instanceof JPasswordField) {
            this.copyMenuItem.setEnabled(false);
            this.cutMenuItem.setEnabled(false);
        } else {
            if (target.getSelectionStart() != target.getSelectionEnd()) {
                this.copyMenuItem.setEnabled(true);
            } else {
                this.copyMenuItem.setEnabled(false);
            }
            if (target.getSelectionStart() != target.getSelectionEnd() && target.isEditable()) {
                this.cutMenuItem.setEnabled(true);
            } else {
                this.cutMenuItem.setEnabled(false);
            }
        }
        if (target.isEditable()) {
            this.pasteMenuItem.setEnabled(true);
        } else {
            this.pasteMenuItem.setEnabled(false);
        }
        if (target.isEditable() && target.getSelectionStart() != target.getSelectionEnd()) {
            this.deleteMenuItem.setEnabled(true);
        } else {
            this.deleteMenuItem.setEnabled(false);
        }
        if (this.getTextLength(target) > 0) {
            this.selectAllMenuItem.setEnabled(true);
        } else {
            this.selectAllMenuItem.setEnabled(false);
        }
        super.show(invoker, x, y);
        this.parent.requestFocus();
    }

    private int getTextLength(JTextComponent c) {
        if (c == null) {
            return 0;
        }
        if (c.getText() == null) {
            return 0;
        }
        return c.getText().length();
    }

    @Override
    public void setVisible(boolean val) {
        try {
            super.setVisible(val);
            this.parent.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

