/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.gui.graphs.TreeModelGraphCreator;
import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeModel;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TreeModelNodeRenderer<V, E>
implements Renderer.Vertex<V, E> {
    private static final int FREQUENCY_BAR_MIN_HEIGHT = 2;
    private static final int FREQUENCY_BAR_MAX_HEIGHT = 12;
    private static final int FREQUENCY_BAR_OFFSET_X = 3;
    private static final int FREQUENCY_BAR_OFFSET_Y = 3;
    private TreeModelGraphCreator graphCreator;
    private TreeModel model;
    private int maxLeafSize = 0;

    public TreeModelNodeRenderer(TreeModelGraphCreator graphCreator, int maxLeafSize) {
        this.graphCreator = graphCreator;
        this.model = graphCreator.getModel();
        this.maxLeafSize = maxLeafSize;
    }

    public void paintVertex(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        Graph graph = layout.getGraph();
        if (rc.getVertexIncludePredicate().evaluate((Object)Context.getInstance((Object)graph, v))) {
            this.paintIconForVertex(rc, v, layout);
        }
    }

    protected void paintIconForVertex(RenderContext<V, E> rc, V v, Layout<V, E> layout) {
        float y;
        GraphicsDecorator g = rc.getGraphicsContext();
        boolean vertexHit = true;
        Shape shape = (Shape)rc.getVertexShapeTransformer().transform(v);
        Point2D p = (Point2D)layout.transform(v);
        p = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
        float x = (float)p.getX();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y = (float)p.getY());
        shape = xform.createTransformedShape(shape);
        vertexHit = this.vertexHit(rc, shape);
        if (vertexHit) {
            if (rc.getVertexIconTransformer() != null) {
                Icon icon = (Icon)rc.getVertexIconTransformer().transform(v);
                if (icon != null) {
                    g.draw(icon, (Component)rc.getScreenDevice(), shape, (int)x, (int)y);
                } else {
                    this.paintShapeForVertex(rc, v, shape);
                }
            } else {
                this.paintShapeForVertex(rc, v, shape);
            }
        }
    }

    protected boolean vertexHit(RenderContext<V, E> rc, Shape s) {
        JComponent vv = rc.getScreenDevice();
        Rectangle deviceRectangle = null;
        if (vv != null) {
            Dimension d = vv.getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        if (deviceRectangle != null) {
            MutableTransformer vt = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW);
            if (vt instanceof MutableTransformerDecorator) {
                vt = ((MutableTransformerDecorator)vt).getDelegate();
            }
            return vt.transform(s).intersects(deviceRectangle);
        }
        return false;
    }

    protected void paintShapeForVertex(RenderContext<V, E> rc, V v, Shape shape) {
        Paint drawPaint;
        GraphicsDecorator g = rc.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        Paint fillPaint = (Paint)rc.getVertexFillPaintTransformer().transform(v);
        if (fillPaint != null) {
            g.setPaint(fillPaint);
            g.fill(shape);
            g.setPaint(oldPaint);
        }
        if ((drawPaint = (Paint)rc.getVertexDrawPaintTransformer().transform(v)) != null) {
            g.setPaint(drawPaint);
            Stroke oldStroke = g.getStroke();
            Stroke stroke = (Stroke)rc.getVertexStrokeTransformer().transform(v);
            if (stroke != null) {
                g.setStroke(stroke);
            }
            g.draw(shape);
            g.setPaint(oldPaint);
            g.setStroke(oldStroke);
        }
        if (this.graphCreator.isLeaf((String)v)) {
            Tree tree = this.graphCreator.getTree((String)v);
            Map<String, Integer> countMap = tree.getCounterMap();
            int numberOfLabels = countMap.size();
            int frequencySum = tree.getFrequencySum();
            double height = (double)tree.getFrequencySum() / (double)this.maxLeafSize * 10.0 + 2.0;
            double width = shape.getBounds().getWidth() - 6.0 - 1.0;
            double xPos = shape.getBounds().getX() + 3.0;
            double yPos = shape.getBounds().getY() + shape.getBounds().getHeight() - 3.0 - height;
            ColorProvider colorProvider = new ColorProvider();
            for (String labelValue : countMap.keySet()) {
                int count = tree.getCount(labelValue);
                double currentWidth = (double)count / (double)frequencySum * width;
                Rectangle2D.Double frequencyRect = new Rectangle2D.Double(xPos, yPos, currentWidth, height);
                int counter = this.model.getTrainingHeader().getAttributes().getLabel().getMapping().mapString(labelValue);
                g.setColor(colorProvider.getPointColor((double)counter / (double)(numberOfLabels - 1)));
                g.fill((Shape)frequencyRect);
                g.setColor(Color.BLACK);
                xPos += currentWidth;
            }
            g.setColor(Color.BLACK);
            g.draw((Shape)new Rectangle2D.Double(shape.getBounds().getX() + 3.0, yPos, width, height));
            g.setPaint(oldPaint);
        }
    }
}

