/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

public class SortableEdge
implements Comparable<SortableEdge> {
    public static final int DIRECTION_INCREASE = -1;
    public static final int DIRECTION_DECREASE = 1;
    private String vertex1;
    private String vertex2;
    private double strength;
    private String edgeName;
    private int direction;

    public SortableEdge(String v1, String v2, String edgeName, double strength, int direction) {
        this.vertex1 = v1;
        this.vertex2 = v2;
        this.strength = strength;
        this.edgeName = edgeName;
        this.direction = direction;
    }

    public int hashCode() {
        return Double.valueOf(this.strength).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SortableEdge)) {
            return false;
        }
        return ((SortableEdge)o).strength == this.strength;
    }

    @Override
    public int compareTo(SortableEdge o) {
        return this.direction * Double.compare(this.strength, o.strength);
    }

    public double getEdgeValue() {
        return this.strength;
    }

    public String getFirstVertex() {
        return this.vertex1;
    }

    public String getSecondVertex() {
        return this.vertex2;
    }

    public String getEdgeName() {
        return this.edgeName;
    }

    public String toString() {
        return this.vertex1 + " --> " + this.vertex2 + " [" + this.edgeName + ", w = " + this.strength + "]";
    }
}

