/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.graphs.BasicVertexShapeTransformer;
import com.rapidminer.gui.graphs.ExtendedVertexShapeTransformer;
import com.rapidminer.gui.graphs.GraphCreator;
import com.rapidminer.gui.graphs.LayoutSelection;
import com.rapidminer.gui.graphs.actions.PickingModeAction;
import com.rapidminer.gui.graphs.actions.TransformingModeAction;
import com.rapidminer.gui.graphs.actions.ZoomInAction;
import com.rapidminer.gui.graphs.actions.ZoomOutAction;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.report.Renderable;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ConstantDirectionalEdgeValueTransformer;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.commons.collections15.Transformer;
import org.freehep.util.export.ExportDialog;

public class GraphViewer<V, E>
extends JPanel
implements Renderable {
    private static final long serialVersionUID = -7501422172633548861L;
    public static final int MARGIN = 10;
    public static final Font EDGE_FONT = new Font("SansSerif", 0, 10);
    public static final Font VERTEX_BOLD_FONT = new Font("SansSerif", 1, 11);
    public static final Font VERTEX_PLAIN_FONT = new Font("SansSerif", 0, 11);
    private static final String INSTRUCTIONS = "<html><h3>General Info:</h3><ul><li>Mousewheel scales the view</li></ul><h3>Transforming Mode:</h3><ul><li>Mouse1+drag pans the graph<li>Mouse1+Shift+drag rotates the graph<li>Mouse1+CTRL(or Command)+drag shears the graph</ul><h3>Picking Mode:</h3><ul><li>Mouse1 on a node selects the node<li>Mouse1 elsewhere unselects all nodes<li>Mouse1+Shift on a node adds/removes node selection<li>Mouse1+drag on a node moves all selected nodes<li>Mouse1+drag elsewhere selects modes in a region<li>Mouse1+Shift+drag adds selection of modes in a new region<li>Mouse1+CTRL on a mode selects the mode and centers the display on it</ul></html>";
    private final transient Action transformAction = new TransformingModeAction(this, IconSize.SMALL);
    private final transient Action pickingAction = new PickingModeAction(this, IconSize.SMALL);
    private VisualizationViewer<V, E> vv;
    private transient Layout<V, E> layout;
    private transient GraphCreator<V, E> graphCreator;
    private LayoutSelection<V, E> layoutSelection;
    private transient ScalingControl scaler = new CrossoverScalingControl();
    private transient DefaultModalGraphMouse graphMouse;
    private boolean showEdgeLabels = true;
    private boolean showVertexLabels = true;
    private transient JSplitPane objectViewerSplitPane;
    private transient ModalGraphMouse.Mode currentMode = ModalGraphMouse.Mode.TRANSFORMING;

    public GraphViewer(final GraphCreator<V, E> graphCreator) {
        try {
            if (!RapidMiner.getExecutionMode().isHeadless()) {
                this.graphMouse = new DefaultModalGraphMouse(0.9090909f, 1.1f);
            }
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        this.graphCreator = graphCreator;
        this.setLayout(new BorderLayout());
        Graph<V, E> graph = graphCreator.createGraph();
        this.layoutSelection = new LayoutSelection<V, E>(this, graph);
        this.layout = new ISOMLayout(graph);
        this.vv = new VisualizationViewer<V, E>(this.layout){
            private static final long serialVersionUID = 8247229781249216143L;
            private boolean initialized;
            {
                this.initialized = false;
            }

            public void paint(Graphics g) {
                super.paint(g);
                if (!this.initialized) {
                    this.initialized = true;
                    GraphViewer.this.updateLayout();
                    if (GraphViewer.this.objectViewerSplitPane != null) {
                        GraphViewer.this.objectViewerSplitPane.setDividerLocation(0.9);
                    }
                }
            }
        };
        this.vv.setBackground(Color.white);
        int edgeShapeType = graphCreator.getEdgeShape();
        switch (edgeShapeType) {
            case 0: {
                this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
                break;
            }
            case 1: {
                this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.QuadCurve());
                break;
            }
            case 2: {
                this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.CubicCurve());
                break;
            }
            case 3: {
                this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.BentLine());
                break;
            }
            case 4: {
                this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Wedge(5));
                break;
            }
            default: {
                this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
            }
        }
        this.vv.getRenderContext().setEdgeFontTransformer(new Transformer<E, Font>(){

            public Font transform(E arg0) {
                return EDGE_FONT;
            }
        });
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new Transformer<E, Paint>(){

            public Paint transform(E edge) {
                double edgeStrength = graphCreator.getEdgeStrength(edge);
                int value = (int)Math.max(140.0, Math.min(230.0, 230.0 - edgeStrength * 90.0));
                return new Color(value, value, value);
            }
        });
        this.vv.getRenderContext().setArrowDrawPaintTransformer(new Transformer<E, Paint>(){

            public Paint transform(E edge) {
                double edgeStrength = graphCreator.getEdgeStrength(edge);
                int value = (int)Math.max(140.0, Math.min(230.0, 230.0 - edgeStrength * 90.0));
                return new Color(value, value, value).darker();
            }
        });
        this.vv.getRenderContext().setArrowFillPaintTransformer(new Transformer<E, Paint>(){

            public Paint transform(E edge) {
                double edgeStrength = graphCreator.getEdgeStrength(edge);
                int value = (int)Math.max(140.0, Math.min(230.0, 230.0 - edgeStrength * 90.0));
                return new Color(value, value, value);
            }
        });
        this.vv.getRenderContext().setEdgeLabelClosenessTransformer((Transformer)new ConstantDirectionalEdgeValueTransformer(0.5, 0.5));
        int labelOffset = graphCreator.getLabelOffset();
        if (labelOffset >= 0) {
            this.vv.getRenderContext().setLabelOffset(labelOffset);
        }
        this.vv.getRenderContext().setEdgeLabelTransformer(new Transformer<E, String>(){

            public String transform(E object) {
                return graphCreator.getEdgeName(object);
            }
        });
        Renderer.EdgeLabel<V, E> edgeLabelRenderer = graphCreator.getEdgeLabelRenderer();
        if (edgeLabelRenderer != null) {
            this.vv.getRenderer().setEdgeLabelRenderer(edgeLabelRenderer);
        }
        this.vv.getRenderContext().setEdgeLabelRenderer(new EdgeLabelRenderer(){
            private JLabel renderer = new JLabel();

            public <T> Component getEdgeLabelRendererComponent(JComponent parent, Object value, Font font, boolean isSelected, T edge) {
                this.renderer.setFont(font);
                if (graphCreator.isEdgeLabelDecorating()) {
                    this.renderer.setOpaque(true);
                    this.renderer.setBackground(Color.WHITE);
                }
                this.renderer.setText(value.toString());
                return this.renderer;
            }

            public boolean isRotateEdgeLabels() {
                return graphCreator.isRotatingEdgeLabels();
            }

            public void setRotateEdgeLabels(boolean rotate) {
            }
        });
        this.vv.getRenderContext().setVertexFontTransformer(new Transformer<V, Font>(){

            public Font transform(V vertex) {
                if (graphCreator.isBold(vertex)) {
                    return VERTEX_BOLD_FONT;
                }
                return VERTEX_PLAIN_FONT;
            }
        });
        this.vv.getRenderContext().setVertexLabelTransformer(new Transformer<V, String>(){

            public String transform(V object) {
                return graphCreator.getVertexName(object);
            }
        });
        Transformer paintTransformer = graphCreator.getVertexPaintTransformer(this.vv);
        if (paintTransformer == null) {
            paintTransformer = new Transformer<V, Paint>(){

                public Paint transform(V vertex) {
                    if (GraphViewer.this.vv.getPickedVertexState().isPicked(vertex)) {
                        return SwingTools.LIGHT_YELLOW;
                    }
                    return SwingTools.LIGHT_BLUE;
                }
            };
        }
        this.vv.getRenderContext().setVertexFillPaintTransformer(paintTransformer);
        this.vv.getRenderContext().setVertexDrawPaintTransformer(new Transformer<V, Paint>(){

            public Paint transform(V vertex) {
                if (GraphViewer.this.vv.getPickedVertexState().isPicked(vertex)) {
                    return SwingTools.DARKEST_YELLOW.darker();
                }
                return SwingTools.DARKEST_BLUE.darker();
            }
        });
        this.vv.setVertexToolTipTransformer(new Transformer<V, String>(){

            public String transform(V vertex) {
                return graphCreator.getVertexToolTip(vertex);
            }
        });
        this.vv.getRenderContext().setVertexShapeTransformer(new ExtendedVertexShapeTransformer<V>(graphCreator));
        Renderer.Vertex<V, E> vertexRenderer = graphCreator.getVertexRenderer();
        if (vertexRenderer != null) {
            this.vv.getRenderer().setVertexRenderer(vertexRenderer);
        }
        this.setDefaultLabelPosition();
        Renderer.VertexLabel<V, E> customVertexLabelRenderer = graphCreator.getVertexLabelRenderer();
        if (customVertexLabelRenderer != null) {
            this.vv.getRenderer().setVertexLabelRenderer(customVertexLabelRenderer);
        }
        this.vv.getRenderContext().setVertexLabelRenderer(new VertexLabelRenderer(){
            private JLabel label = new JLabel();

            public <T> Component getVertexLabelRendererComponent(JComponent parent, Object object, Font font, boolean isSelection, T vertex) {
                this.label.setFont(font);
                if (object != null) {
                    this.label.setText(object.toString());
                } else {
                    this.label.setText("");
                }
                return this.label;
            }
        });
        if (graphCreator.getObjectViewer() == null) {
            this.vv.setBorder(BorderFactory.createBevelBorder(1));
            this.add((Component)this.vv, "Center");
        } else {
            JComponent viewer = graphCreator.getObjectViewer().getViewerComponent();
            if (viewer != null) {
                viewer.setBorder(null);
                this.objectViewerSplitPane = new JSplitPane(1);
                this.objectViewerSplitPane.setResizeWeight(1.0);
                this.objectViewerSplitPane.add((Component)this.vv, 0);
                this.objectViewerSplitPane.add((Component)viewer, 1);
                this.add((Component)this.objectViewerSplitPane, "Center");
            } else {
                this.vv.setBorder(BorderFactory.createBevelBorder(1));
                this.add((Component)this.vv, "Center");
            }
        }
        JComponent controlPanel = this.createControlPanel();
        this.add((Component)new ExtendedJScrollPane(controlPanel), "West");
        this.showEdgeLabels = !graphCreator.showEdgeLabelsDefault();
        this.togglePaintEdgeLabels();
        this.showVertexLabels = !graphCreator.showVertexLabelsDefault();
        this.togglePaintVertexLabels();
        this.layoutSelection.setLayout();
    }

    public LayoutSelection<V, E> getLayoutSelection() {
        return this.layoutSelection;
    }

    private JComponent createControlPanel() {
        if (this.graphMouse != null) {
            this.vv.setGraphMouse((VisualizationViewer.GraphMouse)this.graphMouse);
            this.vv.addKeyListener(this.graphMouse.getModeKeyListener());
            this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        }
        this.transformAction.setEnabled(false);
        this.pickingAction.setEnabled(true);
        this.vv.addGraphMouseListener(new GraphMouseListener<V>(){

            public void graphClicked(V vertex, MouseEvent arg1) {
            }

            public void graphPressed(V arg0, MouseEvent arg1) {
            }

            public void graphReleased(V vertex, MouseEvent arg1) {
                if (GraphViewer.this.currentMode.equals((Object)ModalGraphMouse.Mode.TRANSFORMING) && GraphViewer.this.graphCreator.getObjectViewer() != null) {
                    GraphViewer.this.vv.getPickedVertexState().clear();
                    GraphViewer.this.vv.getPickedVertexState().pick(vertex, true);
                    GraphViewer.this.graphCreator.getObjectViewer().showObject(GraphViewer.this.graphCreator.getObject(vertex));
                }
            }
        });
        JPanel controls = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        controls.setLayout(gbLayout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(4, 4, 4, 4);
        c.weightx = 1.0;
        c.weighty = 0.0;
        ExtendedJToolBar zoomBar = new ExtendedJToolBar();
        zoomBar.setLayout(new FlowLayout(1));
        zoomBar.add(new ZoomInAction(this, IconSize.SMALL));
        zoomBar.add(new ZoomOutAction(this, IconSize.SMALL));
        zoomBar.setBorder(BorderFactory.createTitledBorder("Zoom"));
        c.gridwidth = 0;
        gbLayout.setConstraints(zoomBar, c);
        controls.add(zoomBar);
        ExtendedJToolBar modeBar = new ExtendedJToolBar();
        modeBar.setLayout(new FlowLayout(1));
        modeBar.add(this.transformAction);
        modeBar.add(this.pickingAction);
        modeBar.setBorder(BorderFactory.createTitledBorder("Mode"));
        c.gridwidth = 0;
        gbLayout.setConstraints(modeBar, c);
        controls.add(modeBar);
        c.gridwidth = 0;
        gbLayout.setConstraints(this.layoutSelection, c);
        controls.add(this.layoutSelection);
        JCheckBox nodeLabels = new JCheckBox("Node Labels", this.graphCreator.showVertexLabelsDefault());
        nodeLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphViewer.this.togglePaintVertexLabels();
            }
        });
        c.gridwidth = 0;
        gbLayout.setConstraints(nodeLabels, c);
        controls.add(nodeLabels);
        JCheckBox edgeLabels = new JCheckBox("Edge Labels", this.graphCreator.showEdgeLabelsDefault());
        edgeLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphViewer.this.togglePaintEdgeLabels();
            }
        });
        c.gridwidth = 0;
        gbLayout.setConstraints(edgeLabels, c);
        controls.add(edgeLabels);
        for (int i = 0; i < this.graphCreator.getNumberOfOptionComponents(); ++i) {
            JComponent optionComponent = this.graphCreator.getOptionComponent(this, i);
            if (optionComponent == null) continue;
            c.gridwidth = 0;
            gbLayout.setConstraints(optionComponent, c);
            controls.add(optionComponent);
        }
        JButton imageButton = new JButton("Save Image...");
        imageButton.setToolTipText("Saves an image of the current graph.");
        imageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationViewer tosave = GraphViewer.this.vv;
                ExportDialog exportDialog = new ExportDialog("RapidMiner");
                exportDialog.showExportDialog((Component)GraphViewer.this, "Save Image...", (Component)tosave, "plot");
            }
        });
        c.gridwidth = 0;
        gbLayout.setConstraints(imageButton, c);
        controls.add(imageButton);
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog((Component)GraphViewer.this.vv, GraphViewer.INSTRUCTIONS);
            }
        });
        c.gridwidth = 0;
        gbLayout.setConstraints(help, c);
        controls.add(help);
        JPanel fillPanel = new JPanel();
        c.weighty = 1.0;
        c.gridwidth = 0;
        gbLayout.setConstraints(fillPanel, c);
        controls.add(fillPanel);
        return controls;
    }

    public void updateLayout() {
        this.changeLayout(this.layout, this.layoutSelection.getAnimate(), 0, 0);
    }

    public void changeLayout(final Layout<V, E> newLayout, boolean animate, int desiredWidth, int desiredHeight) {
        MultiLayerTransformer transformer = this.vv.getRenderContext().getMultiLayerTransformer();
        double scale = transformer.getTransformer(Layer.VIEW).getScale();
        if (desiredWidth > 0 && desiredHeight > 0) {
            this.vv.setSize(desiredWidth, desiredHeight);
            try {
                newLayout.setSize(new Dimension(desiredWidth, desiredHeight));
            }
            catch (Exception e) {}
        } else {
            int layoutWidth = (int)((double)this.vv.getWidth() / scale);
            int layoutHeight = (int)((double)this.vv.getHeight() / scale);
            try {
                newLayout.setSize(new Dimension(layoutWidth, layoutHeight));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.layout == null) {
            this.vv.setGraphLayout(newLayout);
        } else if (animate) {
            if (newLayout.getGraph().getEdgeCount() > 0 || newLayout.getGraph().getVertexCount() > 0) {
                try {
                    LayoutTransition lt = new LayoutTransition(this.vv, this.layout, newLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                }
                catch (Throwable e) {
                    this.vv.setGraphLayout(newLayout);
                }
            }
        } else {
            this.vv.setGraphLayout(newLayout);
        }
        this.layout = newLayout;
        this.vv.scaleToLayout(this.scaler);
        double viewX = transformer.getTransformer(Layer.VIEW).getTranslateX();
        double viewY = transformer.getTransformer(Layer.VIEW).getTranslateX();
        double scaleViewX = viewX * scale;
        double scaleViewY = viewY * scale;
        transformer.getTransformer(Layer.VIEW).translate(-scaleViewX, -scaleViewY);
        Thread changeToStaticThread = new Thread(){

            @Override
            public void run() {
                try {
                    19.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (GraphViewer.this.layout.equals(newLayout)) {
                    GraphViewer.this.vv.setGraphLayout((Layout)new StaticLayout(GraphViewer.this.layout.getGraph(), (Transformer)GraphViewer.this.layout));
                }
            }
        };
        changeToStaticThread.start();
    }

    private void setDefaultLabelPosition() {
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
    }

    public void zoomIn() {
        this.scaler.scale(this.vv, 1.1f, this.vv.getCenter());
    }

    public void zoomOut() {
        this.scaler.scale(this.vv, 0.9090909f, this.vv.getCenter());
    }

    public void changeMode(ModalGraphMouse.Mode mode) {
        if (this.graphMouse != null) {
            this.graphMouse.setMode(mode);
        }
        this.currentMode = mode;
        if (mode.equals((Object)ModalGraphMouse.Mode.PICKING)) {
            this.pickingAction.setEnabled(false);
            this.transformAction.setEnabled(true);
        } else {
            this.pickingAction.setEnabled(true);
            this.transformAction.setEnabled(false);
        }
    }

    private void togglePaintEdgeLabels() {
        this.setPaintEdgeLabels(!this.showEdgeLabels);
    }

    public void setPaintEdgeLabels(boolean showEdgeLabels) {
        this.showEdgeLabels = showEdgeLabels;
        if (this.showEdgeLabels) {
            this.vv.getRenderContext().setEdgeLabelTransformer(new Transformer<E, String>(){

                public String transform(E object) {
                    return GraphViewer.this.graphCreator.getEdgeName(object);
                }
            });
        } else {
            this.vv.getRenderContext().setEdgeLabelTransformer(new Transformer<E, String>(){

                public String transform(E object) {
                    return null;
                }
            });
        }
        this.vv.repaint();
    }

    private void togglePaintVertexLabels() {
        this.setPaintVertexLabels(!this.showVertexLabels);
    }

    public void setPaintVertexLabels(boolean showVertexLabels) {
        this.showVertexLabels = showVertexLabels;
        if (this.showVertexLabels) {
            Renderer.Vertex<V, E> vertexRenderer = this.graphCreator.getVertexRenderer();
            if (vertexRenderer != null) {
                this.vv.getRenderer().setVertexRenderer(vertexRenderer);
            }
            this.vv.getRenderContext().setVertexShapeTransformer(new ExtendedVertexShapeTransformer<V>(this.graphCreator));
            this.vv.getRenderContext().setVertexLabelTransformer(new Transformer<V, String>(){

                public String transform(V object) {
                    return GraphViewer.this.graphCreator.getVertexName(object);
                }
            });
        } else {
            this.vv.getRenderer().setVertexRenderer((Renderer.Vertex)new BasicVertexRenderer());
            this.vv.getRenderContext().setVertexShapeTransformer(new BasicVertexShapeTransformer());
            this.vv.getRenderContext().setVertexLabelTransformer(new Transformer<V, String>(){

                public String transform(V object) {
                    return null;
                }
            });
        }
        this.vv.repaint();
    }

    public GraphCreator<V, E> getGraphCreator() {
        return this.graphCreator;
    }

    public Component getVisualizationComponent() {
        return this.vv;
    }

    @Override
    public void prepareRendering() {
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        int height = this.vv.getHeight();
        if (height < 1) {
            height = preferredHeight;
        }
        return height;
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        int width = this.vv.getWidth();
        if (width < 1) {
            width = preferredWidth;
        }
        return width;
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        this.vv.setSize(width, height);
        this.vv.setBorder(null);
        this.changeLayout(this.layout, false, width, height);
        this.vv.paint(graphics);
    }

    public List<ParameterType> getParameterTypes() {
        return new LinkedList<ParameterType>();
    }
}

