/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.gui.graphs.GraphObjectViewer;
import com.rapidminer.gui.graphs.GraphViewer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Paint;
import javax.swing.JComponent;
import org.apache.commons.collections15.Transformer;

public interface GraphCreator<V, E> {
    public static final int EDGE_SHAPE_LINE = 0;
    public static final int EDGE_SHAPE_QUAD_CURVE = 1;
    public static final int EDGE_SHAPE_CUBIC_CURVE = 2;
    public static final int EDGE_SHAPE_BENT_LINE = 3;
    public static final int EDGE_SHAPE_WEDGE = 4;

    public Graph<V, E> createGraph();

    public String getVertexName(V var1);

    public String getVertexToolTip(V var1);

    public String getEdgeName(E var1);

    public double getEdgeStrength(E var1);

    public int getEdgeShape();

    public int getMinLeafHeight();

    public int getMinLeafWidth();

    public boolean isBold(V var1);

    public boolean isRotatingEdgeLabels();

    public Transformer<V, Paint> getVertexPaintTransformer(VisualizationViewer<V, E> var1);

    public Renderer.Vertex<V, E> getVertexRenderer();

    public Renderer.VertexLabel<V, E> getVertexLabelRenderer();

    public Renderer.EdgeLabel<V, E> getEdgeLabelRenderer();

    public boolean isEdgeLabelDecorating();

    public boolean isLeaf(V var1);

    public GraphObjectViewer getObjectViewer();

    public Object getObject(V var1);

    public int getNumberOfOptionComponents();

    public JComponent getOptionComponent(GraphViewer var1, int var2);

    public int getLabelOffset();

    public boolean showEdgeLabelsDefault();

    public boolean showVertexLabelsDefault();
}

