/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.gui.graphs.GraphCreator;
import com.rapidminer.gui.graphs.GraphViewer;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.apache.commons.collections15.Transformer;

public class ExtendedVertexShapeTransformer<V>
implements Transformer<V, Shape> {
    private GraphCreator<V, ?> graphCreator;

    public ExtendedVertexShapeTransformer(GraphCreator<V, ?> graphCreator) {
        this.graphCreator = graphCreator;
    }

    public Shape transform(V object) {
        if (this.graphCreator.isLeaf(object)) {
            String text = this.graphCreator.getVertexName(object);
            Rectangle2D stringBounds = GraphViewer.VERTEX_BOLD_FONT.getStringBounds(text, new FontRenderContext(null, false, false));
            float width = (float)stringBounds.getWidth();
            float height = (float)stringBounds.getHeight();
            int minWidth = this.graphCreator.getMinLeafWidth();
            int minHeight = this.graphCreator.getMinLeafHeight();
            width = Math.max(width, (float)minWidth);
            height = Math.max(height, (float)minHeight);
            return new Rectangle2D.Float(-width / 2.0f - 6.0f, -height / 2.0f - 2.0f, width + 8.0f, height + 4.0f);
        }
        String text = this.graphCreator.getVertexName(object);
        Rectangle2D stringBounds = GraphViewer.VERTEX_PLAIN_FONT.getStringBounds(text, new FontRenderContext(null, false, false));
        float width = (float)stringBounds.getWidth();
        float height = (float)stringBounds.getHeight();
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(-width / 2.0f - 6.0f, -height / 2.0f - 4.0f, width + 10.0f, height + 8.0f, 10.0f, 10.0f);
        return shape;
    }
}

