/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.gui.graphs.GraphObjectViewer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.tools.ObjectVisualizerService;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClusterModelObjectViewer
implements GraphObjectViewer,
ListSelectionListener {
    private static final long serialVersionUID = -1849689229737482745L;
    private DefaultListModel model = new DefaultListModel();
    private JList listComponent = new JList(this.model);
    private Object clusterModel;

    public ClusterModelObjectViewer(Object clusterModel) {
        this.clusterModel = clusterModel;
    }

    @Override
    public JComponent getViewerComponent() {
        this.listComponent.setSelectionMode(0);
        this.listComponent.addListSelectionListener(this);
        this.listComponent.setVisibleRowCount(-1);
        return new ExtendedJScrollPane(this.listComponent);
    }

    @Override
    public void showObject(Object object) {
        this.model.removeAllElements();
        if (object != null) {
            HierarchicalClusterNode node = (HierarchicalClusterNode)object;
            for (Object id : node.getExampleIdsInSubtree()) {
                this.model.addElement(id);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object id;
        if (!e.getValueIsAdjusting() && (id = this.listComponent.getSelectedValue()) != null) {
            ObjectVisualizer visualizer = ObjectVisualizerService.getVisualizerForObject(this.clusterModel);
            visualizer.startVisualization(id);
        }
    }
}

