/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.gui.graphs.ClusterModelObjectViewer;
import com.rapidminer.gui.graphs.GraphCreatorAdaptor;
import com.rapidminer.gui.graphs.GraphObjectViewer;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.Graph;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Factory;

public class ClusterModelGraphCreator
extends GraphCreatorAdaptor {
    private Factory<String> edgeFactory = new Factory<String>(){
        int i = 0;

        public String create() {
            return "E" + this.i++;
        }
    };
    private Factory<String> vertexFactory = new Factory<String>(){
        int i = 0;

        public String create() {
            return "V" + this.i++;
        }
    };
    private HierarchicalClusterModel clusterModel;
    private Map<String, HierarchicalClusterNode> vertexMap = new HashMap<String, HierarchicalClusterNode>();
    private ClusterModelObjectViewer objectViewer;

    public ClusterModelGraphCreator(ClusterModel clusterModel) {
        this(new HierarchicalClusterModel(clusterModel));
    }

    public ClusterModelGraphCreator(HierarchicalClusterModel clusterModel) {
        this.clusterModel = clusterModel;
        this.objectViewer = new ClusterModelObjectViewer(clusterModel);
    }

    @Override
    public Graph<String, String> createGraph() {
        DelegateTree graph = new DelegateTree();
        if (this.clusterModel.getRootNode() == null) {
            return graph;
        }
        HierarchicalClusterNode root = this.clusterModel.getRootNode();
        graph.addVertex((Object)"Root");
        this.vertexMap.put("Root", root);
        for (HierarchicalClusterNode subNode : this.clusterModel.getRootNode().getSubNodes()) {
            this.createGraph((Graph<String, String>)graph, "Root", subNode);
        }
        return graph;
    }

    private void createGraph(Graph<String, String> graph, String parentName, HierarchicalClusterNode node) {
        String childName = (String)this.vertexFactory.create();
        this.vertexMap.put(childName, node);
        graph.addEdge(this.edgeFactory.create(), (Object)parentName, (Object)childName);
        for (HierarchicalClusterNode subNode : node.getSubNodes()) {
            this.createGraph(graph, childName, subNode);
        }
    }

    @Override
    public String getEdgeName(String id) {
        return null;
    }

    @Override
    public String getVertexName(String id) {
        HierarchicalClusterNode node = this.vertexMap.get(id);
        String name = "";
        if (node != null) {
            name = node.getClusterId();
        }
        return name;
    }

    @Override
    public String getVertexToolTip(String id) {
        HierarchicalClusterNode node = this.vertexMap.get(id);
        String tip = "";
        if (node != null) {
            tip = "<html><b>Id:</b>&nbsp;" + node.getClusterId();
        }
        return tip;
    }

    @Override
    public Object getObject(String id) {
        return this.vertexMap.get(id);
    }

    @Override
    public GraphObjectViewer getObjectViewer() {
        return this.objectViewer;
    }

    @Override
    public int getEdgeShape() {
        return 1;
    }
}

