/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.gui.graphs.GraphCreatorAdaptor;
import com.rapidminer.gui.graphs.GraphViewer;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.AssociationRuleFilter;
import com.rapidminer.gui.viewer.AssociationRuleFilterListener;
import com.rapidminer.operator.learner.associations.AssociationRule;
import com.rapidminer.operator.learner.associations.AssociationRules;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.tools.Tools;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.commons.collections15.Factory;

public class AssociationRulesGraphCreator
extends GraphCreatorAdaptor
implements AssociationRuleFilterListener {
    private final Factory<String> edgeFactory = new Factory<String>(){
        int i = 0;

        public String create() {
            return "E" + this.i++;
        }
    };
    private final AssociationRules rules;
    private final Map<String, String> toolTipInfos = new HashMap<String, String>();
    private final List<String> nodeList = new LinkedList<String>();
    private final List<String> edgeList = new LinkedList<String>();
    private final Map<String, List<String>> asPremise = new HashMap<String, List<String>>();
    private final Map<String, List<String>> asConclusion = new HashMap<String, List<String>>();
    private final AssociationRuleFilter filter;
    private DirectedSparseGraph<String, String> graph;
    private GraphViewer<String, String> viewer;

    public AssociationRulesGraphCreator(AssociationRules rules) {
        this.rules = rules;
        this.filter = new AssociationRuleFilter(rules);
        this.filter.setBorder(BorderFactory.createTitledBorder("Filter"));
        this.filter.addAssociationRuleFilterListener(this);
    }

    @Override
    public Graph<String, String> createGraph() {
        this.graph = new DirectedSparseGraph();
        boolean[] allFilter = new boolean[this.rules.getNumberOfRules()];
        for (int i = 0; i < allFilter.length; ++i) {
            allFilter[i] = true;
        }
        this.addRuleNodes(allFilter);
        return this.graph;
    }

    private void addRuleNodes(boolean[] filter) {
        Iterator<String> e = this.edgeList.iterator();
        while (e.hasNext()) {
            this.graph.removeEdge((Object)e.next());
        }
        Iterator<String> n = this.nodeList.iterator();
        while (n.hasNext()) {
            this.graph.removeVertex((Object)n.next());
        }
        this.edgeList.clear();
        this.nodeList.clear();
        this.toolTipInfos.clear();
        this.asPremise.clear();
        this.asConclusion.clear();
        int ruleIndex = 1;
        for (int r = 0; r < this.rules.getNumberOfRules(); ++r) {
            if (filter[r]) {
                AssociationRule rule = this.rules.getRule(r);
                String conjunctionNode = "Rule " + ruleIndex + " (" + Tools.formatNumber(rule.getTotalSupport()) + " / " + Tools.formatNumber(rule.getConfidence()) + ")";
                this.toolTipInfos.put(conjunctionNode, "<html><b>Rule " + ruleIndex + "</b><br>" + SwingTools.addLinebreaks(rule.toPremiseString() + " --> " + rule.toConclusionString()) + "<br><b>Support:</b> " + rule.getTotalSupport() + "<br><b>Confidence:</b> " + rule.getConfidence() + "<br><b>Lift:</b> " + rule.getLift() + "<br><b>Gain:</b> " + rule.getGain() + "<br><b>Conviction:</b> " + rule.getConviction() + "<br><b>Laplace:</b> " + rule.getLaplace() + "<br><b>Ps:</b> " + rule.getPs() + "</html>");
                this.nodeList.add(conjunctionNode);
                Iterator<Item> p = rule.getPremiseItems();
                while (p.hasNext()) {
                    Item premiseItem = p.next();
                    String edgeId = (String)this.edgeFactory.create();
                    this.edgeList.add(edgeId);
                    this.nodeList.add(((Object)premiseItem).toString());
                    this.graph.addEdge((Object)edgeId, (Object)((Object)premiseItem).toString(), (Object)conjunctionNode);
                    List<String> premiseList = this.asPremise.get(((Object)premiseItem).toString());
                    if (premiseList == null) {
                        premiseList = new LinkedList<String>();
                        this.asPremise.put(((Object)premiseItem).toString(), premiseList);
                    }
                    premiseList.add("Rule " + ruleIndex);
                }
                Iterator<Item> c = rule.getConclusionItems();
                while (c.hasNext()) {
                    Item conclusionItem = c.next();
                    String edgeId = (String)this.edgeFactory.create();
                    this.edgeList.add(edgeId);
                    this.nodeList.add(((Object)conclusionItem).toString());
                    this.graph.addEdge((Object)edgeId, (Object)conjunctionNode, (Object)((Object)conclusionItem).toString());
                    List<String> conclusionList = this.asConclusion.get(((Object)conclusionItem).toString());
                    if (conclusionList == null) {
                        conclusionList = new LinkedList<String>();
                        this.asConclusion.put(((Object)conclusionItem).toString(), conclusionList);
                    }
                    conclusionList.add("Rule " + ruleIndex);
                }
            }
            ++ruleIndex;
        }
    }

    @Override
    public boolean isBold(String id) {
        return this.toolTipInfos.get(id) == null;
    }

    @Override
    public boolean isLeaf(String id) {
        return this.toolTipInfos.get(id) != null;
    }

    @Override
    public String getVertexToolTip(String id) {
        String toolTip = this.toolTipInfos.get(id);
        if (toolTip != null) {
            return toolTip;
        }
        return "<html><b>Item:</b> " + id + "<br><b>Premise in Rules:</b> " + (this.asPremise.get(id) == null || this.asPremise.get(id).size() == 0 ? "none" : this.asPremise.get(id)) + "<br><b>Conclusion in Rules:</b> " + (this.asConclusion.get(id) == null || this.asConclusion.get(id).size() == 0 ? "none" : this.asConclusion.get(id)) + "</html>";
    }

    @Override
    public String getEdgeName(String id) {
        return null;
    }

    @Override
    public String getVertexName(String id) {
        return id;
    }

    @Override
    public int getLabelOffset() {
        return -1;
    }

    @Override
    public boolean showEdgeLabelsDefault() {
        return false;
    }

    @Override
    public boolean showVertexLabelsDefault() {
        return true;
    }

    @Override
    public int getEdgeShape() {
        return 1;
    }

    @Override
    public Object getObject(String id) {
        return id;
    }

    @Override
    public int getNumberOfOptionComponents() {
        return 1;
    }

    @Override
    public JComponent getOptionComponent(GraphViewer viewer, int index) {
        if (index == 0) {
            this.viewer = viewer;
            return this.filter;
        }
        return null;
    }

    @Override
    public void setFilter(boolean[] filter) {
        this.addRuleNodes(filter);
        this.viewer.updateLayout();
    }
}

