/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.ConnectPortToRepositoryAction;
import com.rapidminer.gui.actions.StoreInRepositoryAction;
import com.rapidminer.gui.dnd.OperatorTransferHandler;
import com.rapidminer.gui.dnd.ReceivingOperatorTransferHandler;
import com.rapidminer.gui.flow.AutoWireThread;
import com.rapidminer.gui.flow.ExampleSetMetaDataTableModel;
import com.rapidminer.gui.flow.ExtensionButton;
import com.rapidminer.gui.flow.FlowVisualizer;
import com.rapidminer.gui.flow.InterpolationMap;
import com.rapidminer.gui.flow.OverviewPanel;
import com.rapidminer.gui.flow.PanningManager;
import com.rapidminer.gui.flow.ProcessPanel;
import com.rapidminer.gui.tools.PrintingTools;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.ToolTipWindow;
import com.rapidminer.io.process.ProcessXMLFilter;
import com.rapidminer.io.process.ProcessXMLFilterRegistry;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.io.RepositorySource;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortException;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.tools.ClassColorMap;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParentResolvingMap;
import com.rapidminer.tools.StringColorMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessRenderer
extends JPanel {
    private static Orientation ORIENTATION = Orientation.X_AXIS;
    private static ParentResolvingMap<String, Color> GROUP_TO_COLOR_MAP = new StringColorMap();
    private static ParentResolvingMap<Class, Color> IO_CLASS_TO_COLOR_MAP = new ClassColorMap();
    private final transient ToolTipWindow.TipProvider tipProvider = new ToolTipWindow.TipProvider(){

        @Override
        public Object getIdUnder(Point point) {
            if (ProcessRenderer.this.connectingPortSource == null) {
                return ProcessRenderer.this.hoveringPort;
            }
            return null;
        }

        @Override
        public String getTip(Object o) {
            Port port = (Port)o;
            StringBuilder tip = new StringBuilder();
            if (ProcessRenderer.this.displayedChain instanceof ProcessRootOperator) {
                String dest;
                List<String> locations;
                int index;
                if (port.getPorts() == ProcessRenderer.this.displayedChain.getSubprocess(0).getInnerSources()) {
                    index = ProcessRenderer.this.displayedChain.getSubprocess(0).getInnerSources().getAllPorts().indexOf(port);
                    locations = ProcessRenderer.this.displayedChain.getProcess().getContext().getInputRepositoryLocations();
                    if (index >= 0 && index < locations.size()) {
                        dest = locations.get(index);
                        tip.append("Loaded from: ").append(dest).append("<br/>");
                    }
                } else if (port.getPorts() == ProcessRenderer.this.displayedChain.getSubprocess(0).getInnerSinks()) {
                    index = ProcessRenderer.this.displayedChain.getSubprocess(0).getInnerSinks().getAllPorts().indexOf(port);
                    locations = ProcessRenderer.this.displayedChain.getProcess().getContext().getOutputRepositoryLocations();
                    if (index >= 0 && index < locations.size()) {
                        dest = locations.get(index);
                        tip.append("Stored at: ").append(dest).append("<br/>");
                    }
                }
            }
            tip.append("<strong>");
            tip.append(port.getSpec());
            tip.append("</strong> (");
            tip.append(port.getName());
            tip.append(")<br/>");
            tip.append("<em>Meta data:</em> ");
            MetaData metaData = port.getMetaData();
            if (metaData != null) {
                if (metaData instanceof ExampleSetMetaData) {
                    tip.append(((ExampleSetMetaData)metaData).getShortDescription());
                } else {
                    tip.append(metaData.getDescription());
                }
                tip.append("<br/><em>Generated by:</em> ");
                tip.append(metaData.getGenerationHistoryAsHTML());
                tip.append("<br>");
            } else {
                tip.append("-<br/>");
            }
            IOObject data = port.getAnyDataOrNull();
            if (data != null) {
                tip.append("</br><em>Data:</em> ");
                tip.append(data.toString());
                tip.append("<br/>");
            }
            tip.append(port.getDescription());
            if (!port.getErrors().isEmpty()) {
                boolean hasErrors = false;
                boolean hasWarnings = false;
                for (MetaDataError error : port.getErrors()) {
                    if (error.getSeverity() == ProcessSetupError.Severity.ERROR) {
                        hasErrors = true;
                    }
                    if (error.getSeverity() != ProcessSetupError.Severity.WARNING) continue;
                    hasWarnings = true;
                }
                if (hasErrors) {
                    tip.append("<br/><strong style=\"color:red\">");
                    tip.append(port.getErrors().size());
                    tip.append(" error(s):</strong>");
                    for (MetaDataError error : port.getErrors()) {
                        if (error.getSeverity() != ProcessSetupError.Severity.ERROR) continue;
                        tip.append("<br/> ");
                        tip.append(error.getMessage());
                    }
                }
                if (hasWarnings) {
                    tip.append("<br/><strong style=\"color:#FFA500\">");
                    tip.append(port.getErrors().size());
                    tip.append(" warnings(s):</strong>");
                    for (MetaDataError error : port.getErrors()) {
                        if (error.getSeverity() != ProcessSetupError.Severity.WARNING) continue;
                        tip.append("<br/> ");
                        tip.append(error.getMessage());
                    }
                }
            }
            return tip.toString();
        }

        @Override
        public Component getCustomComponent(Object o) {
            Port hoveringPort = (Port)o;
            MetaData metaData = hoveringPort.getMetaData();
            if (metaData != null && metaData instanceof ExampleSetMetaData) {
                return ExampleSetMetaDataTableModel.makeTableForToolTip((ExampleSetMetaData)metaData);
            }
            return null;
        }
    };
    public ResourceAction RENAME_ACTION = new ResourceAction("rename_in_processrenderer", new Object[0]){
        private static final long serialVersionUID = 1L;
        {
            this.setCondition(0, 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ProcessRenderer.this.getSelection().isEmpty()) {
                ProcessRenderer.this.rename(ProcessRenderer.this.getSelection().get(0));
            }
        }
    };
    public ResourceAction SELECT_ALL_ACTION = new ResourceAction("select_all", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ProcessRenderer.this.selectedOperators.clear();
            for (ExecutionUnit unit : ProcessRenderer.this.processes) {
                ProcessRenderer.this.selectedOperators.addAll(unit.getOperators());
            }
            ProcessRenderer.this.mainFrame.selectOperators(ProcessRenderer.this.selectedOperators);
            ProcessRenderer.this.repaint();
        }
    };
    public Action ARRANGE_OPERATORS_ACTION = new ResourceAction(true, "arrange_operators", new Object[0]){
        private static final long serialVersionUID = 4636292007315749350L;

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ExecutionUnit u : ProcessRenderer.this.processes) {
                ProcessRenderer.this.autoArrange(u);
            }
        }
    };
    public Action AUTO_FIT_ACTION = new ResourceAction(true, "auto_fit", new Object[0]){
        private static final long serialVersionUID = 3932329413268066576L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            ProcessRenderer.this.autoFit();
        }
    };
    private final ResourceAction DELETE_SELECTED_CONNECTION = new ResourceAction("delete_selected_connection", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProcessRenderer.this.selectedConnectionSource != null) {
                if (ProcessRenderer.this.selectedConnectionSource.isConnected()) {
                    ProcessRenderer.this.selectedConnectionSource.disconnect();
                    ProcessRenderer.this.repaint();
                }
            } else {
                ((ProcessRenderer)ProcessRenderer.this).mainFrame.getActions().DELETE_OPERATOR_ACTION.actionPerformed(e);
            }
        }
    };
    public final Action INCREASE_PROCESS_LAYOUT_WIDTH_ACTION = new ChangeSizeAction("increase_width", GRID_WIDTH, 0);
    public final Action DECREASE_PROCESS_LAYOUT_WIDTH_ACTION = new ChangeSizeAction("decrease_width", -GRID_WIDTH, 0);
    public final Action INCREASE_PROCESS_LAYOUT_HEIGHT_ACTION = new ChangeSizeAction("increase_height", 0, GRID_HEIGHT);
    public final Action DECREASE_PROCESS_LAYOUT_HEIGHT_ACTION = new ChangeSizeAction("decrease_height", 0, -GRID_HEIGHT);
    private final InterpolationMap nameRolloutInterpolationMap = new InterpolationMap(this);
    private static JLabel DUMMY_LABEL;
    private static int OPERATOR_WIDTH;
    private static int MIN_OPERATOR_HEIGHT;
    private static int PORT_SIZE;
    private static int PADDING;
    private static int WALL_WIDTH;
    private static int GRID_WIDTH;
    private static int GRID_HEIGHT;
    private static int GRID_X_OFFSET;
    private static int GRID_Y_OFFSET;
    private static int GRID_AUTOARRANGE_WIDTH;
    private static int GRID_AUTOARRANGE_HEIGHT;
    private static RenderingHints HI_QUALITY_HINTS;
    private static RenderingHints LOW_QUALITY_HINTS;
    private static ImageIcon IMAGE_WARNING;
    private static ImageIcon IMAGE_BREAKPOINT_WITHIN;
    private static ImageIcon IMAGE_BREAKPOINTS;
    private static ImageIcon IMAGE_BREAKPOINT_BEFORE;
    private static ImageIcon IMAGE_BREAKPOINT_AFTER;
    private static ImageIcon IMAGE_BRANCH;
    private static ImageIcon IMAGE_COMMENT;
    private static ImageIcon OPERATOR_RUNNING;
    private static ImageIcon OPERATOR_READY;
    private static ImageIcon OPERATOR_DIRTY;
    private static ImageIcon OPERATOR_ERROR_ICON;
    private static final long serialVersionUID = 1L;
    private static Color INNER_COLOR;
    private static Color SHADOW_COLOR;
    private static Color LINE_COLOR;
    private static Stroke LINE_STROKE;
    private static Stroke HIGHLIGHT_STROKE;
    private static Stroke SELECTION_RECT_STROKE;
    private static Paint SELECTION_RECT_PAINT;
    private static Color PROCESS_TITLE_COLOR;
    private static Paint SHADOW_TOP_GRADIENT;
    private static Paint SHADOW_LEFT_GRADIENT;
    private static Stroke CONNECTION_LINE_STROKE;
    private static Stroke CONNECTION_HIGHLIGHT_STROKE;
    private static Stroke CONNECTION_COLLECTION_LINE_STROKE;
    private static Stroke CONNECTION_COLLECTION_HIGHLIGHT_STROKE;
    private static Font OPERATOR_FONT;
    protected static final int HEADER_HEIGHT;
    private static final Font PROCESS_FONT;
    private static final Font PORT_FONT;
    private static final Color PORT_NAME_COLOR;
    private static final Color PORT_NAME_SELECTION_COLOR;
    private static final Color ACTIVE_EDGE_COLOR;
    private static final Stroke FRAME_STROKE_SELECTED;
    private static final Stroke FRAME_STROKE_NORMAL;
    private static final Color FRAME_COLOR_SELECTED;
    private static final Color FRAME_COLOR_NORMAL;
    private final transient Map<ExecutionUnit, Dimension> processSizes = new WeakHashMap<ExecutionUnit, Dimension>();
    private final transient Map<Port, Double> portSpacings = new WeakHashMap<Port, Double>();
    private ExecutionUnit[] processes = new ExecutionUnit[0];
    private final transient Map<Operator, Rectangle2D> operatorRects = new WeakHashMap<Operator, Rectangle2D>();
    private static int PORT_OFFSET;
    private Point currentMousePosition = null;
    private Point mousePositionAtDragStart = null;
    private Point mousePositionAtLastEvaluation = null;
    private boolean hasDragged = false;
    private Rectangle2D selectionRectangle = null;
    private Map<Operator, Rectangle2D> draggedOperatorsOrigins;
    private Port draggedPort = null;
    private final LinkedList<Operator> selectedOperators = new LinkedList();
    private Operator hoveringOperator = null;
    private Port hoveringPort = null;
    private OutputPort connectingPortSource = null;
    private int hoveringProcessIndex = -1;
    private Operator dropInsertionPredecessor;
    private OutputPort hoveringConnectionSource;
    private OutputPort selectedConnectionSource;
    private final ProcessPanel processPanel;
    private final MainFrame mainFrame;
    private Point mousePositionRelativeToProcess = null;
    private final List<ExtensionButton> subprocessExtensionButtons = new LinkedList<ExtensionButton>();
    private OperatorChain displayedChain;
    private final ReceivingOperatorTransferHandler transferHandler;
    private final FlowVisualizer flowVisualizer = new FlowVisualizer(this);
    private final transient MouseAdapter MOUSE_HANDLER = new MouseAdapter(){
        private boolean pressHasSelected = false;

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ProcessRenderer.this.currentMousePosition = e.getPoint();
            if (ProcessRenderer.this.flowVisualizer.isActive()) {
                return;
            }
            if (ProcessRenderer.this.connectingPortSource != null) {
                ProcessRenderer.this.repaint();
            }
            ProcessRenderer.this.hoveringProcessIndex = ProcessRenderer.this.getProcessIndexUnder(e.getPoint());
            if (ProcessRenderer.this.hoveringProcessIndex != -1) {
                ProcessRenderer.this.mousePositionRelativeToProcess = ProcessRenderer.this.toProcessSpace(e.getPoint(), ProcessRenderer.this.hoveringProcessIndex);
                int relativeX = (int)ProcessRenderer.this.mousePositionRelativeToProcess.getX();
                int relativeY = (int)ProcessRenderer.this.mousePositionRelativeToProcess.getY();
                OutputPort connectionSourceUnderMouse = ProcessRenderer.this.getPortForConnectorNear(ProcessRenderer.this.mousePositionRelativeToProcess, ProcessRenderer.this.processes[ProcessRenderer.this.hoveringProcessIndex]);
                if (connectionSourceUnderMouse != ProcessRenderer.this.hoveringConnectionSource) {
                    ProcessRenderer.this.hoveringConnectionSource = connectionSourceUnderMouse;
                    ProcessRenderer.this.repaint();
                }
                if (ProcessRenderer.this.checkPortUnder(ProcessRenderer.this.processes[ProcessRenderer.this.hoveringProcessIndex].getInnerSinks(), relativeX, relativeY) || ProcessRenderer.this.checkPortUnder(ProcessRenderer.this.processes[ProcessRenderer.this.hoveringProcessIndex].getInnerSources(), relativeX, relativeY)) {
                    return;
                }
                List<Operator> operators = ProcessRenderer.this.processes[ProcessRenderer.this.hoveringProcessIndex].getOperators();
                ListIterator<Operator> iterator = operators.listIterator(operators.size());
                while (iterator.hasPrevious()) {
                    Operator op = iterator.previous();
                    if (ProcessRenderer.this.checkPortUnder(op.getInputPorts(), relativeX, relativeY) || ProcessRenderer.this.checkPortUnder(op.getOutputPorts(), relativeX, relativeY)) {
                        return;
                    }
                    Rectangle2D rect = ProcessRenderer.this.getOperatorRect(op, true);
                    if (!rect.contains(new Point2D.Double(relativeX, relativeY))) continue;
                    if (ProcessRenderer.this.getHoveringOperator() != op) {
                        ProcessRenderer.this.hoveringPort = null;
                        ProcessRenderer.this.setHoveringOperator(op);
                        ProcessRenderer.this.updateCursor();
                        if (ProcessRenderer.this.getHoveringOperator() instanceof OperatorChain) {
                            ProcessRenderer.this.showStatus("Double-click to zoom, drag to move.");
                        } else {
                            ProcessRenderer.this.showStatus("Drag to move.");
                        }
                        ProcessRenderer.this.repaint();
                    }
                    return;
                }
            }
            if (ProcessRenderer.this.getHoveringOperator() != null) {
                ProcessRenderer.this.setHoveringOperator(null);
                ProcessRenderer.this.updateCursor();
                ProcessRenderer.this.repaint();
            }
            if (ProcessRenderer.this.hoveringPort != null) {
                ProcessRenderer.this.hoveringPort = null;
                ProcessRenderer.this.updateCursor();
                ProcessRenderer.this.repaint();
            }
            ProcessRenderer.this.clearStatus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void mousePressed(MouseEvent e) {
            if (ProcessRenderer.access$3000(ProcessRenderer.this).isActive()) {
                return;
            }
            if (ProcessRenderer.access$3500(ProcessRenderer.this) != null) {
                ProcessRenderer.this.remove(ProcessRenderer.access$3500(ProcessRenderer.this));
            }
            ProcessRenderer.this.requestFocus();
            this.pressHasSelected = false;
            ProcessRenderer.access$3602(ProcessRenderer.this, e.getPoint());
            ProcessRenderer.access$3702(ProcessRenderer.this, e.getPoint());
            ProcessRenderer.access$3802(ProcessRenderer.this, false);
            if (e.isPopupTrigger() && ProcessRenderer.access$3900(ProcessRenderer.this, e)) {
                return;
            }
            if (e.getButton() == 1 && ProcessRenderer.access$900(ProcessRenderer.this) != ProcessRenderer.access$1900(ProcessRenderer.this)) {
                ProcessRenderer.access$902(ProcessRenderer.this, ProcessRenderer.access$1900(ProcessRenderer.this));
                ProcessRenderer.this.repaint();
            }
            if (e.getButton() == 2) {
                ProcessRenderer.this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            if (e.getButton() == 1 && ProcessRenderer.access$100(ProcessRenderer.this) != null) {
                if (e.isAltDown()) {
                    if (ProcessRenderer.access$100(ProcessRenderer.this) instanceof OutputPort) {
                        if (((OutputPort)ProcessRenderer.access$100(ProcessRenderer.this)).isConnected()) {
                            ((OutputPort)ProcessRenderer.access$100(ProcessRenderer.this)).disconnect();
                        }
                    } else if (ProcessRenderer.access$100(ProcessRenderer.this) instanceof InputPort && ((InputPort)ProcessRenderer.access$100(ProcessRenderer.this)).isConnected()) {
                        ((InputPort)ProcessRenderer.access$100(ProcessRenderer.this)).getSource().disconnect();
                    }
                    ProcessRenderer.this.repaint();
                } else if (ProcessRenderer.access$100(ProcessRenderer.this) instanceof OutputPort) {
                    if (ProcessRenderer.access$000(ProcessRenderer.this) == null) {
                        ProcessRenderer.access$002(ProcessRenderer.this, (OutputPort)ProcessRenderer.access$100(ProcessRenderer.this));
                    } else {
                        ProcessRenderer.access$002(ProcessRenderer.this, null);
                    }
                } else if (ProcessRenderer.access$100(ProcessRenderer.this) instanceof InputPort && ProcessRenderer.access$000(ProcessRenderer.this) != null) {
                    try {
                        destOp = ProcessRenderer.access$100(ProcessRenderer.this).getPorts().getOwner().getOperator();
                        hasConnections = ProcessRenderer.access$4000(ProcessRenderer.this, destOp);
                        ProcessRenderer.access$4100(ProcessRenderer.this, ProcessRenderer.access$000(ProcessRenderer.this), (InputPort)ProcessRenderer.access$100(ProcessRenderer.this));
                        if (hasConnections) ** GOTO lbl65
                        sourceOp = ProcessRenderer.access$000(ProcessRenderer.this).getPorts().getOwner().getOperator();
                        if (destOp == ProcessRenderer.access$200(ProcessRenderer.this) || sourceOp == ProcessRenderer.access$200(ProcessRenderer.this)) ** GOTO lbl65
                        destOp.getExecutionUnit().moveToIndex(destOp, destOp.getExecutionUnit().getOperators().indexOf(sourceOp) + 1);
                    }
                    catch (PortException e1) {
                        if (e1.hasRepairOptions()) {
                            e1.showRepairDialog(ProcessRenderer.this);
                        } else {
                            JOptionPane.showMessageDialog(null, e1.getMessage(), "Cannot connect", 0);
                        }
                        ProcessRenderer.this.repaint();
                    }
                    finally {
                        ProcessRenderer.this.repaint();
                        ProcessRenderer.access$002(ProcessRenderer.this, null);
                    }
                }
            } else if (ProcessRenderer.this.getHoveringOperator() == null && !e.isShiftDown() && !e.isControlDown()) {
                ProcessRenderer.access$2200(ProcessRenderer.this, ProcessRenderer.access$200(ProcessRenderer.this), true);
            }
lbl65:
            // 11 sources

            if (ProcessRenderer.access$100(ProcessRenderer.this) != null) {
                ProcessRenderer.access$2200(ProcessRenderer.this, ProcessRenderer.access$100(ProcessRenderer.this).getPorts().getOwner().getOperator(), true);
                this.pressHasSelected = true;
            } else if (ProcessRenderer.this.getHoveringOperator() == null && !e.isShiftDown() && !e.isControlDown()) {
                ProcessRenderer.access$2200(ProcessRenderer.this, ProcessRenderer.access$200(ProcessRenderer.this), true);
                this.pressHasSelected = true;
            }
            if (ProcessRenderer.this.getHoveringOperator() != null) {
                if (!e.isControlDown() && !ProcessRenderer.access$400(ProcessRenderer.this).contains(ProcessRenderer.this.getHoveringOperator())) {
                    ProcessRenderer.access$4200(ProcessRenderer.this, ProcessRenderer.this.getHoveringOperator(), true, e.isShiftDown());
                    this.pressHasSelected = true;
                }
                ProcessRenderer.access$4302(ProcessRenderer.this, new HashMap<K, V>());
                for (Operator op : ProcessRenderer.access$400(ProcessRenderer.this)) {
                    if (op.getExecutionUnit() != ProcessRenderer.this.getHoveringOperator().getExecutionUnit()) continue;
                    ProcessRenderer.access$4300(ProcessRenderer.this).put(op, (Rectangle2D)ProcessRenderer.this.getOperatorRect(op, false).clone());
                }
                ProcessRenderer.access$4400(ProcessRenderer.this).clear();
            } else if (ProcessRenderer.access$100(ProcessRenderer.this) != null) {
                ProcessRenderer.access$4502(ProcessRenderer.this, ProcessRenderer.access$100(ProcessRenderer.this));
            } else {
                ProcessRenderer.access$4602(ProcessRenderer.this, ProcessRenderer.access$4700(ProcessRenderer.this, ProcessRenderer.access$3600(ProcessRenderer.this), e.getPoint()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            if (ProcessRenderer.this.flowVisualizer.isActive()) {
                return;
            }
            if ((e.getModifiers() & 8) != 0) {
                ProcessRenderer.this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (e.isConsumed()) {
                return;
            }
            if (e.isPopupTrigger() && ProcessRenderer.this.showPopupMenu(e)) {
                return;
            }
            try {
                if (ProcessRenderer.this.selectionRectangle != null) {
                    if (ProcessRenderer.this.selectionRectangle.getWidth() > 3.0 && ProcessRenderer.this.selectionRectangle.getHeight() > 3.0) {
                        Point offset;
                        int processIndex = ProcessRenderer.this.getProcessIndexUnder(ProcessRenderer.this.mousePositionAtDragStart);
                        if (processIndex == -1) {
                            processIndex = ProcessRenderer.this.getProcessIndexUnder(e.getPoint());
                        }
                        if (processIndex == -1) {
                            processIndex = ProcessRenderer.this.getProcessIndexUnder(new Point((int)ProcessRenderer.this.selectionRectangle.getCenterX(), (int)ProcessRenderer.this.selectionRectangle.getCenterY()));
                        }
                        if ((offset = ProcessRenderer.this.toProcessSpace(new Point(0, 0), processIndex)) != null) {
                            ProcessRenderer.this.selectionRectangle.setFrame(ProcessRenderer.this.selectionRectangle.getX() + offset.getX(), ProcessRenderer.this.selectionRectangle.getY() + offset.getY(), ProcessRenderer.this.selectionRectangle.getWidth(), ProcessRenderer.this.selectionRectangle.getHeight());
                            if (!e.isShiftDown() && !e.isControlDown() || ProcessRenderer.this.selectedOperators.size() == 1 && ProcessRenderer.this.selectedOperators.get(0) == ProcessRenderer.this.displayedChain) {
                                ProcessRenderer.this.selectedOperators.clear();
                            }
                            for (Operator op : ProcessRenderer.this.processes[processIndex].getOperators()) {
                                Rectangle2D opRect = ProcessRenderer.this.getOperatorRect(op, true);
                                if (!ProcessRenderer.this.selectionRectangle.contains(opRect)) continue;
                                ProcessRenderer.this.selectOperator(op, false);
                            }
                        }
                    }
                    ProcessRenderer.this.selectionRectangle = null;
                } else if (ProcessRenderer.this.hasDragged && ProcessRenderer.this.draggedOperatorsOrigins != null && ProcessRenderer.this.draggedOperatorsOrigins.size() == 1) {
                    ProcessRenderer.this.insertIntoHoveringConnection(ProcessRenderer.this.getHoveringOperator());
                } else if (!ProcessRenderer.this.hasDragged && ProcessRenderer.this.getHoveringOperator() != null && !e.isPopupTrigger() && (e.isControlDown() || ProcessRenderer.this.selectedOperators.contains(ProcessRenderer.this.getHoveringOperator()) && !this.pressHasSelected)) {
                    ProcessRenderer.this.selectOperator(ProcessRenderer.this.getHoveringOperator(), !e.isControlDown(), e.isShiftDown());
                }
                if (ProcessRenderer.this.draggedOperatorsOrigins != null || ProcessRenderer.this.draggedPort != null) {
                    ProcessRenderer.this.displayedChain.getProcess().updateNotify();
                }
            }
            finally {
                ProcessRenderer.this.mousePositionAtDragStart = null;
                ProcessRenderer.this.draggedPort = null;
                ProcessRenderer.this.draggedOperatorsOrigins = null;
                ProcessRenderer.this.hasDragged = false;
            }
            ProcessRenderer.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ProcessRenderer.this.currentMousePosition = e.getPoint();
            if (ProcessRenderer.this.flowVisualizer.isActive()) {
                return;
            }
            if ((e.getModifiers() & 8) != 0 && ProcessRenderer.this.getParent() instanceof JViewport) {
                JViewport jv = (JViewport)ProcessRenderer.this.getParent();
                Point p = jv.getViewPosition();
                int newX = p.x - (e.getX() - ((ProcessRenderer)ProcessRenderer.this).mousePositionAtDragStart.x);
                int newY = p.y - (e.getY() - ((ProcessRenderer)ProcessRenderer.this).mousePositionAtDragStart.y);
                int maxX = ProcessRenderer.this.getWidth() - jv.getWidth();
                int maxY = ProcessRenderer.this.getHeight() - jv.getHeight();
                if (newX < 0) {
                    newX = 0;
                }
                if (newX > maxX) {
                    newX = maxX;
                }
                if (newY < 0) {
                    newY = 0;
                }
                if (newY > maxY) {
                    newY = maxY;
                }
                jv.setViewPosition(new Point(newX, newY));
                return;
            }
            if (ProcessRenderer.this.connectingPortSource != null) {
                ProcessRenderer.this.repaint();
                if (ProcessRenderer.this.connectingPortSource.getPorts().getOwner().getOperator() == ProcessRenderer.this.displayedChain) {
                    ProcessRenderer.this.connectingPortSource = null;
                }
            }
            ProcessRenderer.this.hoveringProcessIndex = ProcessRenderer.this.getProcessIndexUnder(e.getPoint());
            if (ProcessRenderer.this.hoveringProcessIndex != -1) {
                ProcessRenderer.this.mousePositionRelativeToProcess = ProcessRenderer.this.toProcessSpace(e.getPoint(), ProcessRenderer.this.hoveringProcessIndex);
            }
            ProcessRenderer.this.hasDragged = true;
            if (ProcessRenderer.this.draggedOperatorsOrigins != null && !ProcessRenderer.this.draggedOperatorsOrigins.isEmpty()) {
                ExecutionUnit draggingInSubprocess = ((Operator)ProcessRenderer.this.draggedOperatorsOrigins.keySet().iterator().next()).getExecutionUnit();
                if (ProcessRenderer.this.draggedOperatorsOrigins.size() == 1 && ProcessRenderer.this.canBeInsertedIntoConnection(ProcessRenderer.this.getHoveringOperator())) {
                    int pid = ProcessRenderer.this.getIndex(draggingInSubprocess);
                    Point processSpace = ProcessRenderer.this.toProcessSpace(e.getPoint(), pid);
                    ProcessRenderer.this.hoveringConnectionSource = ProcessRenderer.this.getPortForConnectorNear(processSpace, draggingInSubprocess);
                }
                double difX = (double)e.getX() - ProcessRenderer.this.mousePositionAtDragStart.getX();
                double difY = (double)e.getY() - ProcessRenderer.this.mousePositionAtDragStart.getY();
                if (!ProcessRenderer.this.draggedOperatorsOrigins.containsKey(ProcessRenderer.this.getHoveringOperator())) {
                    ProcessRenderer.this.draggedOperatorsOrigins.put(ProcessRenderer.this.getHoveringOperator(), ProcessRenderer.this.getOperatorRect(ProcessRenderer.this.getHoveringOperator(), false));
                }
                double targetX = ((Rectangle2D)ProcessRenderer.this.draggedOperatorsOrigins.get(ProcessRenderer.this.getHoveringOperator())).getX() + difX;
                double targetY = ((Rectangle2D)ProcessRenderer.this.draggedOperatorsOrigins.get(ProcessRenderer.this.getHoveringOperator())).getY() + difY;
                if (targetX < 0.0) {
                    targetX = 0.0;
                }
                if (targetY < 0.0) {
                    targetY = 0.0;
                }
                if (ProcessRenderer.this.isSnapToGrid()) {
                    Point snapped = ProcessRenderer.this.snap(new Point2D.Double(targetX, targetY));
                    targetX = snapped.getX();
                    targetY = snapped.getY();
                }
                difX = targetX - ((Rectangle2D)ProcessRenderer.this.draggedOperatorsOrigins.get(ProcessRenderer.this.getHoveringOperator())).getX();
                difY = targetY - ((Rectangle2D)ProcessRenderer.this.draggedOperatorsOrigins.get(ProcessRenderer.this.getHoveringOperator())).getY();
                double unitWidth = ProcessRenderer.this.getWidth(draggingInSubprocess);
                double unitHeight = ProcessRenderer.this.getHeight(draggingInSubprocess);
                for (Operator op : ProcessRenderer.this.draggedOperatorsOrigins.keySet()) {
                    Rectangle2D origin = (Rectangle2D)ProcessRenderer.this.draggedOperatorsOrigins.get(op);
                    if (origin.getMaxX() + difX >= unitWidth) {
                        difX -= origin.getMaxX() + difX - unitWidth;
                    }
                    if (origin.getMaxY() + difY >= unitHeight) {
                        difY -= origin.getMaxY() + difY - unitHeight;
                    }
                    if (origin.getMinX() + difX < 0.0) {
                        difX -= origin.getMinX() + difX;
                    }
                    if (!(origin.getMinY() + difY < 0.0)) continue;
                    difY -= origin.getMinY() + difY;
                }
                double maxX = 0.0;
                double maxY = 0.0;
                for (Operator op : ProcessRenderer.this.draggedOperatorsOrigins.keySet()) {
                    Rectangle2D origin = (Rectangle2D)ProcessRenderer.this.draggedOperatorsOrigins.get(op);
                    Rectangle2D.Double opPos = new Rectangle2D.Double(origin.getX() + difX, origin.getY() + difY, origin.getWidth(), origin.getHeight());
                    ProcessRenderer.this.setOperatorRect(op, opPos);
                }
                ProcessRenderer.this.ensureWidth(draggingInSubprocess, (int)maxX);
                ProcessRenderer.this.ensureHeight(draggingInSubprocess, (int)maxY);
                ProcessRenderer.this.repaint();
            } else if (ProcessRenderer.this.draggedPort != null && ProcessRenderer.this.draggedPort.getPorts().getOwner().getOperator() == ProcessRenderer.this.displayedChain) {
                double diff = (double)e.getY() - ProcessRenderer.this.mousePositionAtLastEvaluation.getY();
                double shifted = ProcessRenderer.this.shiftPortSpacing(ProcessRenderer.this.draggedPort, diff);
                ProcessRenderer.this.mousePositionAtLastEvaluation.setLocation(ProcessRenderer.this.mousePositionAtLastEvaluation.getX(), ProcessRenderer.this.mousePositionAtLastEvaluation.getY() + shifted);
                ProcessRenderer.this.repaint();
            } else if (ProcessRenderer.this.selectionRectangle != null) {
                ProcessRenderer.this.selectionRectangle = ProcessRenderer.this.getSelectionRectangle(ProcessRenderer.this.mousePositionAtDragStart, e.getPoint());
                ProcessRenderer.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ProcessRenderer.this.flowVisualizer.isActive()) {
                return;
            }
            ProcessRenderer.this.requestFocus();
            if (e.isPopupTrigger() && ProcessRenderer.this.showPopupMenu(e)) {
                return;
            }
            switch (e.getButton()) {
                case 1: {
                    if (e.getClickCount() == 2) {
                        if (ProcessRenderer.this.hoveringPort != null && ProcessRenderer.this.hoveringPort.getPorts().getOwner().getOperator() instanceof ProcessRootOperator) {
                            String loc;
                            RepositoryLocation procLoc = ProcessRenderer.this.displayedChain.getProcess().getRepositoryLocation();
                            RepositoryLocation resolveRelativeTo = null;
                            if (procLoc != null) {
                                resolveRelativeTo = procLoc.parent();
                            }
                            if ((loc = RepositoryLocationChooser.selectLocation(resolveRelativeTo, ProcessRenderer.this)) != null) {
                                int index = ProcessRenderer.this.hoveringPort.getPorts().getAllPorts().indexOf(ProcessRenderer.this.hoveringPort);
                                if (ProcessRenderer.this.hoveringPort instanceof OutputPort) {
                                    ProcessRenderer.this.displayedChain.getProcess().getContext().setInputRepositoryLocation(index, loc);
                                } else {
                                    ProcessRenderer.this.displayedChain.getProcess().getContext().setOutputRepositoryLocation(index, loc);
                                }
                            }
                        } else if (ProcessRenderer.this.getHoveringOperator() != null && ProcessRenderer.this.getHoveringOperator() instanceof OperatorChain) {
                            ProcessRenderer.this.processPanel.showOperatorChain((OperatorChain)ProcessRenderer.this.getHoveringOperator());
                        }
                    }
                    ProcessRenderer.this.repaint();
                    break;
                }
                case 3: {
                    ProcessRenderer.this.connectingPortSource = null;
                    ProcessRenderer.this.repaint();
                }
            }
            ProcessRenderer.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ProcessRenderer.this.mainFrame.getStatusBar().clearSpecialText();
        }
    };
    private final ConnectorShape connectorShape = ConnectorShape.SPLINES;
    private boolean snapToGrid;
    private final OverviewPanel overviewPanel = new OverviewPanel(this);
    private JTextField renameField = null;

    public static void registerAdditionalGroupColors(String groupProperties, String pluginName, ClassLoader classLoader) {
        try {
            GROUP_TO_COLOR_MAP.parseProperties(groupProperties, "group.", ".color", classLoader);
        }
        catch (IOException e) {
            LogService.getRoot().warning("Cannot load operator group colors for plugin " + pluginName + ".");
        }
    }

    public static void registerAdditionalObjectColors(String groupProperties, String pluginName, ClassLoader classLoader) {
        try {
            IO_CLASS_TO_COLOR_MAP.parseProperties(groupProperties, "io.", ".color", classLoader);
        }
        catch (IOException e) {
            LogService.getRoot().warning("Cannot load io object colors for plugin " + pluginName + ".");
        }
    }

    public ProcessRenderer(ProcessPanel processPanel, MainFrame mainFrame) {
        new PanningManager(this);
        ProcessXMLFilterRegistry.registerFilter(new GUIProcessXMLFilter());
        this.mainFrame = mainFrame;
        this.processPanel = processPanel;
        this.setLayout(null);
        this.transferHandler = new ReceivingOperatorTransferHandler(){
            private static final long serialVersionUID = 7526109471182298215L;

            @Override
            public boolean dropNow(List<Operator> newOperators, Point loc) {
                int processIndex;
                ProcessRenderer.this.mainFrame.getStatusBar().clearSpecialText();
                if (newOperators.isEmpty()) {
                    return true;
                }
                List<Operator> selection = ProcessRenderer.this.getSelection();
                if (loc == null && (selection == null || selection.isEmpty() || selection.size() == 1 && selection.get(0) == ProcessRenderer.this.displayedChain)) {
                    loc = ProcessRenderer.this.currentMousePosition;
                }
                if (loc != null) {
                    processIndex = ProcessRenderer.this.getProcessIndexUnder(loc.getLocation());
                } else if (selection != null && !selection.isEmpty()) {
                    processIndex = Arrays.asList(ProcessRenderer.this.processes).indexOf(selection.get(0).getExecutionUnit());
                    if (processIndex == -1) {
                        processIndex = 0;
                    }
                } else {
                    processIndex = 0;
                }
                try {
                    if (processIndex != -1) {
                        if (loc != null) {
                            boolean firstMustBeWired;
                            int firstInsertionIndex;
                            Operator firstOperator = newOperators.get(0);
                            Point dest = ProcessRenderer.this.toProcessSpace(loc, processIndex);
                            boolean isRoot = ProcessRenderer.this.displayedChain instanceof ProcessRootOperator;
                            boolean dropsSource = firstOperator instanceof RepositorySource;
                            if (isRoot && dropsSource && newOperators.size() == 1 && ProcessRenderer.this.checkPortUnder(ProcessRenderer.this.processes[processIndex].getInnerSources(), (int)dest.getX(), (int)dest.getY())) {
                                String location = firstOperator.getParameters().getParameterOrNull("repository_entry");
                                int index = ProcessRenderer.this.hoveringPort.getPorts().getAllPorts().indexOf(ProcessRenderer.this.hoveringPort);
                                ProcessRenderer.this.displayedChain.getProcess().getContext().setInputRepositoryLocation(index, location);
                                return true;
                            }
                            ProcessRenderer.this.operatorRects.put(firstOperator, new Rectangle2D.Double(dest.getX() - (double)(OPERATOR_WIDTH / 2), dest.getY() - (double)(MIN_OPERATOR_HEIGHT / 2), OPERATOR_WIDTH, MIN_OPERATOR_HEIGHT));
                            if (ProcessRenderer.this.hoveringConnectionSource != null && ProcessRenderer.this.canBeInsertedIntoConnection(firstOperator)) {
                                int predecessorIndex = ProcessRenderer.this.processes[processIndex].getOperators().indexOf(ProcessRenderer.this.hoveringConnectionSource.getPorts().getOwner().getOperator());
                                firstInsertionIndex = predecessorIndex != -1 ? predecessorIndex + 1 : this.getDropInsertionIndex(processIndex);
                                ProcessRenderer.this.processes[processIndex].addOperator(firstOperator, firstInsertionIndex);
                                ProcessRenderer.this.insertIntoHoveringConnection(firstOperator);
                                firstMustBeWired = false;
                            } else {
                                firstInsertionIndex = this.getDropInsertionIndex(processIndex);
                                ProcessRenderer.this.processes[processIndex].addOperator(firstOperator, firstInsertionIndex);
                                firstMustBeWired = true;
                            }
                            for (int i = 1; i < newOperators.size(); ++i) {
                                Operator newOp = newOperators.get(i);
                                ProcessRenderer.this.processes[processIndex].addOperator(newOp, firstInsertionIndex + i);
                            }
                            AutoWireThread.autoWireInBackground(newOperators, firstMustBeWired);
                        } else {
                            for (Operator newOp : newOperators) {
                                ProcessRenderer.this.processes[processIndex].addOperator(newOp);
                            }
                            AutoWireThread.autoWireInBackground(newOperators, true);
                            for (Operator newOp : newOperators) {
                                ProcessRenderer.this.getOperatorRect(newOp, true);
                            }
                        }
                        boolean first = true;
                        for (Operator op : newOperators) {
                            ProcessRenderer.this.selectOperator(op, first);
                            first = false;
                        }
                        ProcessRenderer.this.dropInsertionPredecessor = null;
                        return true;
                    }
                    ProcessRenderer.this.dropInsertionPredecessor = null;
                    return false;
                }
                catch (RuntimeException e) {
                    LogService.getRoot().log(Level.WARNING, "During drop: " + e, e);
                    throw e;
                }
            }

            @Override
            protected boolean isDropLocationOk(List<Operator> newOperators, Point loc) {
                if (!ProcessRenderer.this.isEnabled()) {
                    return false;
                }
                if (ProcessRenderer.this.getProcessIndexUnder(loc) == -1) {
                    return false;
                }
                for (Operator newOperator : newOperators) {
                    if (!(newOperator instanceof OperatorChain) || ProcessRenderer.this.displayedChain != newOperator && !((OperatorChain)newOperator).getAllInnerOperators().contains(ProcessRenderer.this.displayedChain)) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected void markDropOver(Point dropPoint) {
                int pid = ProcessRenderer.this.getProcessIndexUnder(dropPoint);
                if (pid != -1) {
                    Point processSpace = ProcessRenderer.this.toProcessSpace(dropPoint, pid);
                    ProcessRenderer.this.hoveringConnectionSource = ProcessRenderer.this.getPortForConnectorNear(processSpace, ProcessRenderer.this.processes[pid]);
                    ProcessRenderer.this.setDropInsertionPredecessor(ProcessRenderer.this.getClosestLeftNeighbour(processSpace, ProcessRenderer.this.processes[pid]));
                }
                ProcessRenderer.this.repaint();
            }

            @Override
            protected List<Operator> getDraggedOperators() {
                return ProcessRenderer.this.getSelection();
            }

            private int getDropInsertionIndex(int processIndex) {
                if (ProcessRenderer.this.dropInsertionPredecessor == null) {
                    return ProcessRenderer.this.processes[processIndex].getOperators().size();
                }
                return ProcessRenderer.this.dropInsertionPredecessor.getExecutionUnit().getOperators().indexOf(ProcessRenderer.this.dropInsertionPredecessor) + 1;
            }

            @Override
            protected void dropEnds() {
            }

            @Override
            protected Process getProcess() {
                return ProcessRenderer.this.displayedChain.getProcess();
            }
        };
        this.setTransferHandler(this.transferHandler);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 8: {
                        if (ProcessRenderer.this.displayedChain != null && ProcessRenderer.this.displayedChain.getParent() != null) {
                            ProcessRenderer.this.mainFrame.selectOperator(ProcessRenderer.this.displayedChain.getParent());
                        }
                        e.consume();
                        break;
                    }
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        if (e.isControlDown()) {
                            ProcessRenderer.this.changeProcessSize(e, ProcessRenderer.this.displayedChain.getSubprocess(0));
                        } else {
                            ProcessRenderer.this.selectInDirection(e);
                        }
                        e.consume();
                        break;
                    }
                    case 10: {
                        Operator selected;
                        if (!ProcessRenderer.this.getSelection().isEmpty() && (selected = ProcessRenderer.this.getSelection().get(0)) instanceof OperatorChain) {
                            ProcessRenderer.this.processPanel.showOperatorChain((OperatorChain)selected);
                        }
                        e.consume();
                    }
                }
            }
        });
        mainFrame.getActions().TOGGLE_BREAKPOINT[1].addToActionMap(this, 0);
        mainFrame.getActions().TOGGLE_ACTIVATION_ITEM.addToActionMap(this, 0);
        this.RENAME_ACTION.addToActionMap(this, 0);
        this.SELECT_ALL_ACTION.addToActionMap(this, 0);
        this.DELETE_SELECTED_CONNECTION.addToActionMap(this, 0);
        OperatorTransferHandler.addToActionMap(this);
        new ToolTipWindow(this.tipProvider, this);
        this.init();
    }

    protected int getIndex(ExecutionUnit executionUnit) {
        for (int i = 0; i < this.processes.length; ++i) {
            if (this.processes[i] != executionUnit) continue;
            return i;
        }
        return -1;
    }

    private void init() {
        this.addMouseMotionListener(this.MOUSE_HANDLER);
        this.addMouseListener(this.MOUSE_HANDLER);
        this.setPreferredSize(new Dimension(1000, 440));
        this.setMinimumSize(new Dimension(100, 100));
        this.setMaximumSize(new Dimension(2000, 2000));
    }

    private void changeProcessSize(KeyEvent e, ExecutionUnit unit) {
        switch (e.getKeyCode()) {
            case 37: {
                this.changeProcessSize(unit, -GRID_WIDTH, 0);
                break;
            }
            case 39: {
                this.changeProcessSize(unit, GRID_WIDTH, 0);
                break;
            }
            case 38: {
                this.changeProcessSize(unit, 0, -GRID_HEIGHT);
                break;
            }
            case 40: {
                this.changeProcessSize(unit, 0, GRID_HEIGHT);
            }
        }
    }

    private void changeProcessSize(ExecutionUnit unit, int dx, int dy) {
        if (unit == null) {
            return;
        }
        Dimension size = this.processSizes.get(unit);
        size = dx == 0 ? new Dimension((int)size.getWidth(), (int)this.getHeight(unit, true) + dy) : new Dimension((int)this.getWidth(unit, true) + dx, (int)size.getHeight());
        this.processSizes.put(unit, size);
        this.balance();
        this.updateComponentSize();
    }

    private void selectInDirection(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (this.getSelection().isEmpty()) {
            for (ExecutionUnit unit : this.processes) {
                if (unit.getNumberOfOperators() <= 0) continue;
                this.selectOperator(unit.getOperators().get(0), true);
            }
        } else {
            Operator current = this.getSelection().get(0);
            if (current.getParent() != this.displayedChain) {
                return;
            }
            Rectangle2D pos = this.getOperatorRect(current, true);
            ExecutionUnit unit = current.getExecutionUnit();
            if (unit == null) {
                return;
            }
            double smallestDistance = Double.POSITIVE_INFINITY;
            Operator closest = null;
            for (Operator other : unit.getOperators()) {
                double dy;
                double dx;
                double dist;
                Rectangle2D otherPos = this.getOperatorRect(other, true);
                boolean ok = false;
                switch (keyCode) {
                    case 37: {
                        ok = otherPos.getMinX() < pos.getMinX();
                        break;
                    }
                    case 39: {
                        ok = otherPos.getMaxX() > pos.getMaxX();
                        break;
                    }
                    case 38: {
                        ok = otherPos.getMinY() < pos.getMinY();
                        break;
                    }
                    case 40: {
                        boolean bl = ok = otherPos.getMaxY() > pos.getMaxY();
                    }
                }
                if (!ok || !((dist = (dx = otherPos.getCenterX() - pos.getCenterX()) * dx + (dy = otherPos.getCenterY() - pos.getCenterY()) * dy) < smallestDistance)) continue;
                smallestDistance = dist;
                closest = other;
            }
            if (closest != null) {
                this.selectOperator(closest, !e.isShiftDown());
            }
        }
    }

    protected void showOperatorChain(OperatorChain op) {
        ExecutionUnit[] processes;
        this.displayedChain = op;
        if (op == null) {
            processes = new ExecutionUnit[]{};
        } else {
            processes = new ExecutionUnit[op.getNumberOfSubprocesses()];
            for (int i = 0; i < processes.length; ++i) {
                processes[i] = op.getSubprocess(i);
            }
        }
        this.showProcesses(processes);
    }

    private void showProcesses(ExecutionUnit[] processes) {
        this.processes = processes;
        this.setInitialSizes(processes);
        this.setupExtensionButtons();
        this.updateComponentSize();
        this.repaint();
    }

    private void setupExtensionButtons() {
        for (ExtensionButton button : this.subprocessExtensionButtons) {
            this.remove(button);
        }
        this.subprocessExtensionButtons.clear();
        if (this.displayedChain.areSubprocessesExtendable()) {
            for (int index = 0; index < this.processes.length; ++index) {
                double width = this.getWidth(this.processes[index]) + 1.0;
                Point loc = this.fromProcessSpace(new Point(0, 0), index);
                if (index == 0) {
                    ExtensionButton addButton2 = new ExtensionButton(this.displayedChain, -1, true);
                    addButton2.setBounds((int)(loc.getX() - addButton2.getPreferredSize().getWidth() + 1.0), (int)(loc.getY() - 1.0), (int)addButton2.getPreferredSize().getWidth(), (int)addButton2.getPreferredSize().getHeight());
                    this.subprocessExtensionButtons.add(addButton2);
                    this.add(addButton2);
                }
                ExtensionButton addButton = new ExtensionButton(this.displayedChain, index, true);
                addButton.setBounds((int)(loc.getX() + width), (int)(loc.getY() - 1.0), (int)addButton.getPreferredSize().getWidth(), (int)addButton.getPreferredSize().getHeight());
                this.subprocessExtensionButtons.add(addButton);
                this.add(addButton);
                if (this.processes.length <= 1) continue;
                ExtensionButton deleteButton = new ExtensionButton(this.displayedChain, index, false);
                deleteButton.setBounds((int)(loc.getX() + width), (int)(loc.getY() + (double)addButton.getHeight() - 1.0), (int)deleteButton.getPreferredSize().getWidth(), (int)deleteButton.getPreferredSize().getHeight());
                this.subprocessExtensionButtons.add(deleteButton);
                this.add(deleteButton);
            }
        }
    }

    private void updateExtensionButtons() {
        for (ExtensionButton button : this.subprocessExtensionButtons) {
            Point loc;
            int subprocessIndex = button.getSubprocessIndex();
            if (subprocessIndex >= 0) {
                loc = this.fromProcessSpace(new Point(0, 0), subprocessIndex);
                double width = this.getWidth(this.processes[subprocessIndex]) + 1.0;
                button.setBounds((int)(loc.getX() + width), (int)loc.getY() + (button.isAdd() ? 0 : button.getHeight()) - 1, (int)button.getPreferredSize().getWidth(), (int)button.getPreferredSize().getHeight());
                continue;
            }
            loc = this.fromProcessSpace(new Point(0, 0), 0);
            button.setBounds((int)loc.getX() - button.getWidth(), (int)loc.getY() + (button.isAdd() ? 0 : button.getHeight()) - 1, (int)button.getPreferredSize().getWidth(), (int)button.getPreferredSize().getHeight());
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        boolean bl = this.snapToGrid = !"false".equals(System.getProperty("rapidminer.gui.snap_to_grid"));
        if (this.draggedOperatorsOrigins != null || this.connectingPortSource != null) {
            ((Graphics2D)graphics).setRenderingHints(LOW_QUALITY_HINTS);
        } else {
            ((Graphics2D)graphics).setRenderingHints(HI_QUALITY_HINTS);
        }
        this.render((Graphics2D)graphics);
    }

    Rectangle2D getOperatorRect(Operator op, boolean autoPositionIfMissing) {
        Rectangle2D rect = this.operatorRects.get(op);
        if (rect == null && autoPositionIfMissing) {
            if (op.getInputPorts().getNumberOfPorts() > 0 && op.getOutputPorts().getNumberOfPorts() > 0 && ((InputPort)op.getInputPorts().getPortByIndex(0)).isConnected() && ((OutputPort)op.getOutputPorts().getPortByIndex(0)).isConnected()) {
                boolean dependenciesOk = true;
                Operator sourceOp = ((InputPort)op.getInputPorts().getPortByIndex(0)).getSource().getPorts().getOwner().getOperator();
                Operator destOp = ((OutputPort)op.getOutputPorts().getPortByIndex(0)).getDestination().getPorts().getOwner().getOperator();
                dependenciesOk &= sourceOp == this.displayedChain || this.operatorRects.containsKey(sourceOp);
                if (dependenciesOk &= destOp == this.displayedChain || this.operatorRects.containsKey(destOp)) {
                    Point sourcePos = this.getPortLocation(((InputPort)op.getInputPorts().getPortByIndex(0)).getSource());
                    Point destPos = this.getPortLocation(((OutputPort)op.getOutputPorts().getPortByIndex(0)).getDestination());
                    rect = new Rectangle2D.Double((((Point2D)sourcePos).getX() + ((Point2D)destPos).getX()) / 2.0 - (double)(OPERATOR_WIDTH / 2), (((Point2D)sourcePos).getY() + ((Point2D)destPos).getY()) / 2.0 - (double)PORT_OFFSET, OPERATOR_WIDTH, MIN_OPERATOR_HEIGHT);
                    this.setOperatorRect(op, rect);
                }
            }
            if (rect == null) {
                int index = 0;
                ExecutionUnit unit = op.getExecutionUnit();
                if (unit != null) {
                    index = unit.getOperators().indexOf(op);
                }
                rect = this.autoPosition(op, index);
            }
        }
        return rect;
    }

    private void setOperatorRect(Operator operator, Rectangle2D rect) {
        if (rect == null) {
            throw new NullPointerException("rect is null");
        }
        this.operatorRects.put(operator, rect);
        Dimension processSize = this.processSizes.get(operator.getExecutionUnit());
        if (processSize != null) {
            boolean needsResize = false;
            if (processSize.getWidth() < rect.getMaxX() + (double)PADDING) {
                processSize.setSize(rect.getMaxX() + (double)PADDING, processSize.getHeight());
                needsResize = true;
            }
            if (processSize.getHeight() < rect.getMaxY() + (double)PADDING) {
                processSize.setSize(processSize.getWidth(), rect.getMaxY() + (double)PADDING);
                needsResize = true;
            }
            if (needsResize) {
                this.updateComponentSize();
            }
        }
    }

    private double getPortSpacing(Port port) {
        Double d = this.portSpacings.get(port);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private double shiftPortSpacing(Port port, double delta) {
        double diff;
        Ports<? extends Port> ports = port.getPorts();
        int myIndex = ports.getAllPorts().indexOf(port);
        Double oldD = this.portSpacings.get(port);
        double old = oldD == null ? 0.0 : oldD;
        double newY = old + delta;
        if (this.isSnapToGrid()) {
            newY = Math.floor(newY / ((double)PORT_SIZE * 3.0 / 2.0)) * (double)(PORT_SIZE * 3 / 2);
        }
        if ((diff = newY - old) == 0.0) {
            return 0.0;
        }
        if (diff > 0.0) {
            for (int i = myIndex + 1; i < ports.getNumberOfPorts(); ++i) {
                Port other = ports.getPortByIndex(i);
                double otherSpacing = this.getPortSpacing(other);
                if (!(otherSpacing < diff)) {
                    this.portSpacings.put(other, otherSpacing - diff);
                    break;
                }
                this.portSpacings.remove(other);
            }
            this.portSpacings.put(port, old + diff);
            Point bottomPortPos = this.getPortLocation(ports.getPortByIndex(ports.getNumberOfPorts() - 1));
            double height = this.getHeight(ports.getOwner().getConnectionContext()) - (double)PADDING;
            if (bottomPortPos.getY() > height) {
                double tooMuch = bottomPortPos.getY() - height;
                this.portSpacings.put(port, old + (diff -= tooMuch));
            }
            return diff;
        }
        if (diff < 0.0) {
            double actuallyRemoved = 0.0;
            for (int i = myIndex; i >= 0; --i) {
                Port other = ports.getPortByIndex(i);
                double otherSpacing = this.getPortSpacing(other);
                if (otherSpacing < -diff) {
                    actuallyRemoved += this.getPortSpacing(other);
                } else {
                    this.portSpacings.put(other, otherSpacing + diff);
                    actuallyRemoved = -diff;
                    break;
                }
                this.portSpacings.remove(other);
            }
            if (ports.getNumberOfPorts() > myIndex + 1) {
                Port other = ports.getPortByIndex(myIndex + 1);
                this.portSpacings.put(other, this.getPortSpacing(other) + actuallyRemoved);
            }
            return -actuallyRemoved;
        }
        return 0.0;
    }

    private Point getPortLocation(Port port) {
        Point point;
        if (port.getPorts() == null) {
            return new Point(0, 0);
        }
        Operator op = port.getPorts().getOwner().getOperator();
        int index = port.getPorts().getAllPorts().indexOf(port);
        int addOffset = 0;
        for (int i = 0; i <= index; ++i) {
            addOffset = (int)((double)addOffset + this.getPortSpacing(port.getPorts().getPortByIndex(i)));
        }
        if (op == this.displayedChain) {
            ExecutionUnit process = port.getPorts().getOwner().getConnectionContext();
            point = port instanceof OutputPort ? new Point(0, MIN_OPERATOR_HEIGHT / 2 + PORT_OFFSET + index * PORT_SIZE * 3 / 2 + addOffset) : new Point((int)this.getWidth(process), MIN_OPERATOR_HEIGHT / 2 + PORT_OFFSET + index * PORT_SIZE * 3 / 2 + addOffset);
        } else {
            ExecutionUnit process = op.getExecutionUnit();
            Rectangle2D opRect = this.getOperatorRect(op, true);
            point = port instanceof InputPort ? new Point((int)opRect.getX(), (int)opRect.getY() + PORT_OFFSET + index * PORT_SIZE * 3 / 2 + addOffset) : new Point((int)opRect.getMaxX(), (int)opRect.getY() + PORT_OFFSET + index * PORT_SIZE * 3 / 2 + addOffset);
        }
        return point;
    }

    public void renderSubprocess(int index, Graphics2D g) {
        double width = this.getWidth(this.processes[index]);
        double height = this.getHeight(this.processes[index]);
        Rectangle2D.Double frame = new Rectangle2D.Double(0.0, 0.0, width, height);
        g.setPaint(INNER_COLOR);
        g.fill(frame);
        g.setColor(PROCESS_TITLE_COLOR);
        g.setFont(PROCESS_FONT);
        g.drawString(this.processes[index].getName(), PADDING + 2, PROCESS_FONT.getSize() + PADDING);
        g.setPaint(SHADOW_TOP_GRADIENT);
        g.fill(new Rectangle2D.Double(0.0, 0.0, PADDING, height));
        GeneralPath top = new GeneralPath();
        int shadowWidth = PADDING;
        top.moveTo(0.0f, 0.0f);
        top.lineTo(width, 0.0);
        top.lineTo(width, (double)shadowWidth);
        top.lineTo(shadowWidth, shadowWidth);
        top.closePath();
        g.setPaint(SHADOW_LEFT_GRADIENT);
        g.fill(top);
        g.setPaint(LINE_COLOR);
        g.setStroke(LINE_STROKE);
        g.draw(frame);
        for (Operator operator : this.processes[index].getOperators()) {
            if (this.selectedOperators.contains(operator)) continue;
            this.renderOperator(operator, g);
        }
        Iterator<Operator> selectionIterator = this.selectedOperators.descendingIterator();
        while (selectionIterator.hasNext()) {
            Operator op = selectionIterator.next();
            if (!this.processes[index].getOperators().contains(op)) continue;
            this.renderOperator(op, g);
        }
        this.renderPorts(this.processes[index].getInnerSources(), null, g, true);
        this.renderPorts(this.processes[index].getInnerSinks(), null, g, true);
        this.renderConnections(this.processes[index].getInnerSources(), g);
        this.flowVisualizer.render(g, this.processes[index]);
    }

    private void renderPorts(Ports<? extends Port> ports, Color baseColor, Graphics2D g, boolean enabled) {
        boolean input = ports instanceof InputPorts;
        g.setStroke(LINE_STROKE);
        for (Port port : ports.getAllPorts()) {
            Arc2D.Double ellipseBoth;
            Arc2D.Double ellipseBottom;
            Arc2D.Double ellipseTop;
            int startAngle;
            boolean hasError = !port.getErrors().isEmpty();
            Point location = this.getPortLocation(port);
            double x = location.getX();
            double y = location.getY();
            if (input) {
                startAngle = 90;
                ellipseTop = new Arc2D.Double(new Rectangle2D.Double(x - (double)(PORT_SIZE / 2), y - (double)(PORT_SIZE / 2), PORT_SIZE, PORT_SIZE), startAngle, 90.0, 2);
                ellipseBottom = new Arc2D.Double(new Rectangle2D.Double(x - (double)(PORT_SIZE / 2), y - (double)(PORT_SIZE / 2), PORT_SIZE, PORT_SIZE), startAngle + 90, 90.0, 2);
                ellipseBoth = new Arc2D.Double(new Rectangle2D.Double(x - (double)(PORT_SIZE / 2), y - (double)(PORT_SIZE / 2), PORT_SIZE, PORT_SIZE), startAngle, 180.0, 2);
            } else {
                startAngle = 270;
                ellipseBottom = new Arc2D.Double(new Rectangle2D.Double(x - (double)(PORT_SIZE / 2), y - (double)(PORT_SIZE / 2), PORT_SIZE, PORT_SIZE), startAngle, 90.0, 2);
                ellipseTop = new Arc2D.Double(new Rectangle2D.Double(x - (double)(PORT_SIZE / 2), y - (double)(PORT_SIZE / 2), PORT_SIZE, PORT_SIZE), startAngle + 90, 90.0, 2);
                ellipseBoth = new Arc2D.Double(new Rectangle2D.Double(x - (double)(PORT_SIZE / 2), y - (double)(PORT_SIZE / 2), PORT_SIZE, PORT_SIZE), startAngle, 180.0, 2);
            }
            Color line = Color.DARK_GRAY;
            Color fill = Color.WHITE;
            if (enabled) {
                fill = !hasError ? this.getColorFor(port, false, Color.WHITE) : Color.RED;
                g.setColor(fill);
                if (port instanceof OutputPort) {
                    g.fill(ellipseBoth);
                }
                if (port instanceof InputPort) {
                    g.fill(ellipseTop);
                    InputPort inPort = (InputPort)port;
                    Iterator<Precondition> i$ = inPort.getAllPreconditions().iterator();
                    if (i$.hasNext()) {
                        Precondition precondition = i$.next();
                        g.setColor(ProcessRenderer.getColorFor(precondition.getExpectedMetaData()));
                    }
                    g.fill(ellipseBottom);
                }
                g.setColor(line);
                if (this.hoveringPort == port) {
                    g.setStroke(HIGHLIGHT_STROKE);
                } else {
                    g.setStroke(LINE_STROKE);
                }
                g.draw(ellipseBoth);
            } else {
                g.setColor(fill);
                g.fill(ellipseBoth);
                g.setColor(line);
                g.draw(ellipseBoth);
            }
            g.setFont(PORT_FONT);
            Rectangle2D strBounds = PORT_FONT.getStringBounds(port.getShortName(), g.getFontRenderContext());
            int xt = input ? PORT_SIZE / 2 : -((int)strBounds.getWidth()) - 3;
            if (hasError) {
                g.setColor(Color.RED);
                g.setFont(PORT_FONT.deriveFont(1));
            } else if (baseColor == null) {
                if (port == this.hoveringPort) {
                    g.setColor(PORT_NAME_SELECTION_COLOR);
                } else {
                    g.setColor(PORT_NAME_COLOR);
                }
            } else if (port == this.hoveringPort) {
                g.setPaint(baseColor.darker());
            } else {
                g.setPaint(baseColor.darker().darker());
            }
            g.drawString(port.getShortName(), (int)x + xt, (int)(y + strBounds.getHeight() / 2.0 - 2.0));
        }
    }

    private ImageIcon getIcon(Operator operator, ImageIcon icon) {
        if (operator.isEnabled() && this.isEnabled()) {
            return icon;
        }
        return (ImageIcon)UIManager.getLookAndFeel().getDisabledIcon(DUMMY_LABEL, icon);
    }

    private void renderOperator(Operator operator, Graphics2D g) {
        Shape bodyShape;
        double headerWidth;
        Rectangle2D frame = this.getOperatorRect(operator, true);
        double height = Math.max(MIN_OPERATOR_HEIGHT, 40 + PORT_SIZE * 3 / 2 * Math.max(operator.getInputPorts().getNumberOfPorts(), operator.getOutputPorts().getNumberOfPorts()));
        if (frame.getHeight() != height) {
            frame.setRect(frame.getX(), frame.getY(), frame.getWidth(), height);
        }
        double headerHeight = HEADER_HEIGHT;
        double nameRollout = this.nameRolloutInterpolationMap.getValue(operator);
        if (nameRollout > 0.0) {
            Rectangle2D nameBounds = OPERATOR_FONT.getStringBounds(operator.getName(), g.getFontRenderContext());
            headerWidth = nameBounds.getWidth() + 6.0;
            if (headerWidth > frame.getWidth()) {
                double dif = headerWidth - frame.getWidth();
                headerWidth = frame.getWidth() + nameRollout * dif;
                GeneralPath path = new GeneralPath();
                path.moveTo(frame.getMinX(), frame.getMinY());
                path.lineTo(frame.getMinX() + headerWidth, frame.getMinY());
                path.lineTo(frame.getMinX() + headerWidth, frame.getMinY() + headerHeight);
                path.lineTo(frame.getMaxX(), frame.getMinY() + headerHeight);
                path.lineTo(frame.getMaxX(), frame.getMaxY());
                path.lineTo(frame.getMinX(), frame.getMaxY());
                path.closePath();
                bodyShape = path;
            } else {
                headerWidth = frame.getWidth();
                bodyShape = frame;
            }
        } else {
            headerWidth = frame.getWidth();
            bodyShape = frame;
        }
        if (!this.selectedOperators.isEmpty() && operator == this.selectedOperators.get(0) || this.dropInsertionPredecessor == operator) {
            Rectangle2D.Double shadow = new Rectangle2D.Double(frame.getX() + 5.0, frame.getY() + 5.0, frame.getWidth(), frame.getHeight());
            GeneralPath bottom = new GeneralPath();
            bottom.moveTo(((RectangularShape)shadow).getX(), frame.getMaxY());
            bottom.lineTo(frame.getMaxX(), frame.getMaxY());
            bottom.lineTo(shadow.getMaxX(), shadow.getMaxY());
            bottom.lineTo(shadow.getMinX(), shadow.getMaxY());
            bottom.closePath();
            g.setPaint(new GradientPaint((float)frame.getX(), (float)frame.getMaxY(), Color.gray, (float)frame.getX(), (float)shadow.getMaxY(), INNER_COLOR));
            g.fill(bottom);
            GeneralPath right = new GeneralPath();
            right.moveTo(frame.getMaxX(), shadow.getMinY());
            right.lineTo(shadow.getMaxX(), shadow.getMinY());
            right.lineTo(shadow.getMaxX(), shadow.getMaxY());
            right.lineTo(frame.getMaxX(), frame.getMaxY());
            right.closePath();
            g.setPaint(new GradientPaint((float)frame.getMaxX(), (float)((RectangularShape)shadow).getY(), Color.gray, (float)shadow.getMaxX(), (float)((RectangularShape)shadow).getY(), INNER_COLOR));
            g.fill(right);
        }
        Color baseColor = GROUP_TO_COLOR_MAP.get(operator.getOperatorDescription().getGroup());
        if (!operator.isEnabled() || !this.isEnabled()) {
            baseColor = Color.LIGHT_GRAY;
        }
        g.setPaint(baseColor);
        g.fill(frame);
        Rectangle2D.Double bar = new Rectangle2D.Double(frame.getX(), frame.getY(), headerWidth, headerHeight);
        Color c0 = new Color(baseColor.getRed() - 25, baseColor.getGreen() - 25, baseColor.getBlue() - 25);
        Color c1 = baseColor;
        Rectangle2D[] regions = this.splitHorizontalBar(bar, 0.0, 0.2, 0.6);
        GradientPaint gp = new GradientPaint(0.0f, (float)regions[0].getMinY(), c0, 0.0f, (float)regions[0].getMaxX(), c1);
        g.setPaint(gp);
        g.fill(regions[0]);
        gp = new GradientPaint(0.0f, (float)regions[1].getMinY(), c1, 0.0f, (float)regions[1].getMaxY(), Color.WHITE);
        g.setPaint(gp);
        g.fill(regions[1]);
        gp = new GradientPaint(0.0f, (float)regions[2].getMinY(), Color.WHITE, 0.0f, (float)regions[2].getMaxY(), c1);
        g.setPaint(gp);
        g.fill(regions[2]);
        gp = new GradientPaint(0.0f, (float)regions[3].getMinY(), c1, 0.0f, (float)regions[3].getMaxY(), c0.darker());
        g.setPaint(gp);
        g.fill(regions[3]);
        g.setPaint(LINE_COLOR);
        g.setStroke(LINE_STROKE);
        if (this.selectedOperators.contains(operator) || operator == this.dropInsertionPredecessor) {
            g.setPaint(FRAME_COLOR_SELECTED);
            g.setStroke(FRAME_STROKE_SELECTED);
        } else {
            g.setPaint(FRAME_COLOR_NORMAL);
            g.setStroke(FRAME_STROKE_NORMAL);
        }
        g.draw(bodyShape);
        g.setFont(OPERATOR_FONT);
        if (operator.isEnabled()) {
            if (operator == this.getHoveringOperator()) {
                g.setPaint(baseColor.darker());
            } else if (this.selectedOperators.contains(operator)) {
                g.setPaint(baseColor.darker());
            } else {
                g.setPaint(baseColor.darker().darker());
            }
        } else {
            g.setPaint(baseColor.darker().darker());
        }
        g.drawString(this.fitString(operator.getName(), g, (int)headerWidth - 3), (int)frame.getX() + 4, (int)(frame.getY() + (double)OPERATOR_FONT.getSize() + 1.0));
        ImageIcon icon = operator.getOperatorDescription().getIcon();
        if (icon != null) {
            if (!operator.isEnabled()) {
                icon = this.getIcon(operator, icon);
            }
            icon.paintIcon(this, g, (int)(frame.getX() + frame.getWidth() / 2.0 - (double)(icon.getIconWidth() / 2)), (int)(frame.getY() + headerHeight + (height - headerHeight - 10.0) / 2.0 - (double)(icon.getIconHeight() / 2)));
        }
        this.renderConnections(operator.getOutputPorts(), g);
        this.renderPorts(operator.getInputPorts(), baseColor, g, operator.isEnabled());
        this.renderPorts(operator.getOutputPorts(), baseColor, g, operator.isEnabled());
        int iconX = (int)frame.getX() + 3;
        ImageIcon opIcon = operator.isRunning() ? OPERATOR_RUNNING : (!operator.isDirty() ? OPERATOR_READY : (!operator.getErrorList().isEmpty() ? OPERATOR_ERROR_ICON : OPERATOR_DIRTY));
        this.getIcon(operator, opIcon).paintIcon(this, g, iconX, (int)(frame.getY() + frame.getHeight() - (double)opIcon.getIconHeight() - 1.0));
        iconX += opIcon.getIconWidth() + 1;
        if (!operator.getErrorList().isEmpty()) {
            this.getIcon(operator, IMAGE_WARNING).paintIcon(this, g, iconX, (int)(frame.getY() + frame.getHeight() - (double)IMAGE_WARNING.getIconHeight() - 1.0));
        }
        iconX += IMAGE_WARNING.getIconWidth() + 1;
        if (operator.hasBreakpoint()) {
            ImageIcon breakpointIcon = operator.getNumberOfBreakpoints() == 1 ? (operator.hasBreakpoint(0) ? IMAGE_BREAKPOINT_BEFORE : (operator.hasBreakpoint(1) ? IMAGE_BREAKPOINT_AFTER : IMAGE_BREAKPOINT_WITHIN)) : IMAGE_BREAKPOINTS;
            this.getIcon(operator, breakpointIcon).paintIcon(this, g, iconX, (int)(frame.getY() + frame.getHeight() - (double)breakpointIcon.getIconHeight() - 1.0));
        }
        iconX += IMAGE_BREAKPOINTS.getIconWidth() + 1;
        if (operator.getUserDescription() != null && operator.getUserDescription().length() > 0) {
            this.getIcon(operator, IMAGE_COMMENT).paintIcon(this, g, iconX, (int)(frame.getY() + frame.getHeight() - (double)IMAGE_COMMENT.getIconHeight() - 1.0));
        }
        iconX += IMAGE_COMMENT.getIconWidth() + 1;
        if (operator instanceof OperatorChain) {
            this.getIcon(operator, IMAGE_BRANCH).paintIcon(this, g, iconX, (int)(frame.getY() + frame.getHeight() - (double)IMAGE_BRANCH.getIconHeight() - 1.0));
        }
        iconX += IMAGE_BRANCH.getIconWidth() + 1;
    }

    private Rectangle2D[] splitHorizontalBar(RectangularShape bar, double a, double b, double c) {
        Rectangle2D[] result = new Rectangle2D[4];
        double y0 = bar.getMinY();
        double y1 = Math.rint(y0 + bar.getHeight() * a);
        double y2 = Math.rint(y0 + bar.getHeight() * b);
        double y3 = Math.rint(y0 + bar.getHeight() * c);
        result[0] = new Rectangle2D.Double(bar.getMinX(), bar.getMinY(), bar.getWidth(), y1 - y0);
        result[1] = new Rectangle2D.Double(bar.getMinX(), y1, bar.getWidth(), y2 - y1);
        result[2] = new Rectangle2D.Double(bar.getMinX(), y2, bar.getWidth(), y3 - y2);
        result[3] = new Rectangle2D.Double(bar.getMinX(), y3, bar.getWidth(), bar.getMaxY() - y3);
        return result;
    }

    private Color getColorFor(Port port, boolean alwaysDark, Color defaultColor) {
        if (!this.isEnabled()) {
            return Color.LIGHT_GRAY;
        }
        IOObject data = port.getAnyDataOrNull();
        if (data != null) {
            if (data instanceof IOObjectCollection) {
                return IO_CLASS_TO_COLOR_MAP.get(((IOObjectCollection)data).getElementClass(true));
            }
            return IO_CLASS_TO_COLOR_MAP.get(data.getClass());
        }
        if (port.getMetaData() != null) {
            MetaData md = port.getMetaData();
            return ProcessRenderer.getColorFor(md);
        }
        return defaultColor;
    }

    public static Color getColorFor(MetaData md) {
        if (md == null) {
            return Color.WHITE;
        }
        if (md instanceof CollectionMetaData) {
            MetaData elementMetaDataRecursive = ((CollectionMetaData)md).getElementMetaDataRecursive();
            if (elementMetaDataRecursive != null) {
                return IO_CLASS_TO_COLOR_MAP.get(elementMetaDataRecursive.getObjectClass());
            }
            return IO_CLASS_TO_COLOR_MAP.get(IOObject.class);
        }
        return IO_CLASS_TO_COLOR_MAP.get(md.getObjectClass());
    }

    private void renderConnections(OutputPorts ports, Graphics2D g) {
        for (int i = 0; i < ports.getNumberOfPorts(); ++i) {
            OutputPort from = (OutputPort)ports.getPortByIndex(i);
            InputPort to = from.getDestination();
            g.setColor(this.getColorFor(from, true, Color.LIGHT_GRAY));
            if (to != null) {
                if (from.getMetaData() instanceof CollectionMetaData) {
                    if (from == this.hoveringPort || to == this.hoveringPort || from == this.hoveringConnectionSource || from == this.selectedConnectionSource) {
                        g.setStroke(CONNECTION_COLLECTION_HIGHLIGHT_STROKE);
                    } else {
                        g.setStroke(CONNECTION_COLLECTION_LINE_STROKE);
                    }
                    g.draw(this.createConnector(from, to));
                    g.setColor(Color.white);
                    g.setStroke(LINE_STROKE);
                    g.draw(this.createConnector(from, to));
                } else {
                    if (from == this.hoveringPort || to == this.hoveringPort || from == this.hoveringConnectionSource || from == this.selectedConnectionSource) {
                        g.setStroke(CONNECTION_HIGHLIGHT_STROKE);
                    } else {
                        g.setStroke(CONNECTION_LINE_STROKE);
                    }
                    g.draw(this.createConnector(from, to));
                }
            }
            if (this.connectingPortSource != from || this.mousePositionRelativeToProcess == null) continue;
            g.setColor(ACTIVE_EDGE_COLOR);
            Point fromLoc = this.getPortLocation(this.connectingPortSource);
            g.draw(new Line2D.Double(((Point2D)fromLoc).getX() + (double)(PORT_SIZE / 2), ((Point2D)fromLoc).getY(), this.mousePositionRelativeToProcess.getX(), this.mousePositionRelativeToProcess.getY()));
        }
    }

    public void render(Graphics2D graphics) {
        if (this.processes == null || this.processes.length == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(0, -1);
        g.translate(0, PADDING);
        block8: for (int i = 0; i < this.processes.length; ++i) {
            switch (ORIENTATION) {
                case X_AXIS: {
                    g.translate(WALL_WIDTH, 0);
                    break;
                }
                case Y_AXIS: {
                    g.translate(0, PADDING);
                }
            }
            this.renderSubprocess(i, g);
            switch (ORIENTATION) {
                case X_AXIS: {
                    g.translate(this.getWidth(this.processes[i]) + (double)WALL_WIDTH, 0.0);
                    continue block8;
                }
                case Y_AXIS: {
                    g.translate(0.0, this.getHeight(this.processes[i]) + (double)PADDING);
                }
            }
        }
        g.translate(0, PADDING);
        if (this.selectionRectangle != null) {
            Graphics2D selG = (Graphics2D)graphics.create();
            selG.setPaint(SELECTION_RECT_PAINT);
            selG.setStroke(SELECTION_RECT_STROKE);
            selG.draw(this.selectionRectangle);
            selG.dispose();
        }
        g.dispose();
    }

    private void selectOperator(Operator op, boolean clear) {
        this.selectOperator(op, clear, false);
    }

    private void selectOperator(Operator op, boolean clear, boolean range) {
        boolean changed = false;
        if ((clear || op == null) && !this.selectedOperators.isEmpty()) {
            changed = true;
            if (!range) {
                this.selectedOperators.clear();
            } else {
                Operator last = null;
                if (!this.selectedOperators.isEmpty()) {
                    last = this.selectedOperators.getLast();
                }
                this.selectedOperators.clear();
                if (last != null) {
                    this.selectedOperators.add(last);
                }
            }
        }
        if (range) {
            int lastIndex = -1;
            boolean sameUnit = true;
            if (!this.selectedOperators.isEmpty()) {
                Operator lastSelected = this.selectedOperators.getLast();
                if (lastSelected.getExecutionUnit() == null) {
                    sameUnit = false;
                } else {
                    lastIndex = lastSelected.getExecutionUnit().getOperators().indexOf(lastSelected);
                    if (lastSelected.getExecutionUnit() != op.getExecutionUnit()) {
                        sameUnit = false;
                    }
                }
            }
            if (sameUnit) {
                int index = op.getExecutionUnit().getOperators().indexOf(op);
                if (lastIndex < index) {
                    for (int i = lastIndex + 1; i <= index; ++i) {
                        this.selectedOperators.add(op.getExecutionUnit().getOperators().get(i));
                    }
                } else if (lastIndex > index) {
                    for (int i = lastIndex - 1; i >= index; --i) {
                        this.selectedOperators.add(op.getExecutionUnit().getOperators().get(i));
                    }
                }
            }
        } else {
            boolean contains = this.selectedOperators.contains(op);
            if (op != null) {
                if (!contains) {
                    this.selectedOperators.add(op);
                    changed = true;
                } else if (!clear) {
                    this.selectedOperators.remove(op);
                    changed = true;
                }
            }
        }
        if (changed) {
            this.mainFrame.selectOperators(this.selectedOperators);
        }
        this.repaint();
    }

    public List<Operator> getSelection() {
        return this.selectedOperators;
    }

    public void setSelection(List<Operator> selectedOperators) {
        if (!this.selectedOperators.equals(selectedOperators)) {
            this.selectedOperators.clear();
            this.selectedOperators.addAll(selectedOperators);
            this.repaint();
        }
    }

    private boolean showPopupMenu(final MouseEvent e) {
        if (this.connectingPortSource != null) {
            return false;
        }
        JPopupMenu menu = new JPopupMenu();
        if (this.hoveringPort != null) {
            List<QuickFix> fixes;
            final IOObject data = this.hoveringPort.getAnyDataOrNull();
            if (data != null && data instanceof ResultObject) {
                JMenuItem showResult = new JMenuItem(new ResourceAction(true, "show_port_data", new Object[]{((ResultObject)data).getName()}){
                    private static final long serialVersionUID = -6557085878445788274L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        data.setSource(ProcessRenderer.this.hoveringPort.getPorts().getOwner().getOperator().getName());
                        ProcessRenderer.this.mainFrame.getResultDisplay().showResult((ResultObject)data);
                    }
                });
                menu.add(showResult);
                menu.add(new StoreInRepositoryAction(data));
                menu.addSeparator();
            }
            if (!(fixes = this.hoveringPort.collectQuickFixes()).isEmpty()) {
                ResourceMenu fixMenu = new ResourceMenu("quick_fixes");
                for (QuickFix fix : fixes) {
                    fixMenu.add(fix.getAction());
                }
                menu.add(fixMenu);
            }
            if (this.hoveringPort.isConnected()) {
                menu.add(new ResourceAction(true, "disconnect", new Object[0]){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ProcessRenderer.this.hoveringPort != null && ProcessRenderer.this.hoveringPort.isConnected()) {
                            if (ProcessRenderer.this.hoveringPort instanceof OutputPort) {
                                ((OutputPort)ProcessRenderer.this.hoveringPort).disconnect();
                            } else {
                                ((InputPort)ProcessRenderer.this.hoveringPort).getSource().disconnect();
                            }
                        }
                    }
                });
            }
            if (this.displayedChain instanceof ProcessRootOperator && (this.hoveringPort.getPorts() == this.displayedChain.getSubprocess(0).getInnerSources() || this.hoveringPort.getPorts() == this.displayedChain.getSubprocess(0).getInnerSinks())) {
                menu.add(new ConnectPortToRepositoryAction(this.hoveringPort));
            }
        } else {
            this.mainFrame.getActions().addToOperatorPopupMenu(menu, this.RENAME_ACTION);
            if (this.getHoveringOperator() == null) {
                menu.addSeparator();
                ResourceMenu orderMenu = new ResourceMenu("execution_order");
                orderMenu.add(this.flowVisualizer.ALTER_EXECUTION_ORDER.createMenuItem());
                orderMenu.add(this.flowVisualizer.SHOW_EXECUTION_ORDER);
                menu.add(orderMenu);
                ResourceMenu layoutMenu = new ResourceMenu("process_layout");
                layoutMenu.add(new ResourceAction("arrange_operators", new Object[0]){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int index = ProcessRenderer.this.getProcessIndexUnder(e.getPoint());
                        if (index == -1) {
                            for (ExecutionUnit u : ProcessRenderer.this.processes) {
                                ProcessRenderer.this.autoArrange(u);
                            }
                        } else {
                            ProcessRenderer.this.autoArrange(ProcessRenderer.this.processes[index]);
                        }
                    }
                });
                layoutMenu.add(this.AUTO_FIT_ACTION);
                if (this.hoveringProcessIndex != -1) {
                    layoutMenu.add(this.INCREASE_PROCESS_LAYOUT_WIDTH_ACTION);
                    layoutMenu.add(this.DECREASE_PROCESS_LAYOUT_WIDTH_ACTION);
                    layoutMenu.add(this.INCREASE_PROCESS_LAYOUT_HEIGHT_ACTION);
                    layoutMenu.add(this.DECREASE_PROCESS_LAYOUT_HEIGHT_ACTION);
                }
                menu.add(layoutMenu);
                menu.addSeparator();
                String name = "Process";
                if (this.displayedChain.getProcess().getProcessLocation() != null) {
                    name = this.displayedChain.getProcess().getProcessLocation().getShortName();
                }
                menu.add(PrintingTools.makeExportPrintMenu(this, name));
            }
            if (this.getHoveringOperator() != null) {
                boolean first = true;
                for (OutputPort port : this.getHoveringOperator().getOutputPorts().getAllPorts()) {
                    final IOObject data = port.getAnyDataOrNull();
                    if (data == null || !(data instanceof ResultObject)) continue;
                    if (first) {
                        menu.addSeparator();
                        first = false;
                    }
                    JMenuItem showResult = new JMenuItem(new ResourceAction(true, "show_port_data", new Object[]{((ResultObject)data).getName()}){
                        private static final long serialVersionUID = -6557085878445788274L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            data.setSource(ProcessRenderer.this.getHoveringOperator().getName());
                            ProcessRenderer.this.mainFrame.getResultDisplay().showResult((ResultObject)data);
                        }
                    });
                    menu.add(showResult);
                }
            }
        }
        if (menu.getSubElements().length > 0) {
            menu.show(this, e.getX(), e.getY());
        }
        return true;
    }

    private Shape createConnector(Port fromPort, Port toPort) {
        Point2D from = this.getPortLocation(fromPort);
        Point2D to = this.getPortLocation(toPort);
        from = new Point2D.Double(from.getX() + (double)(PORT_SIZE / 2), from.getY());
        to = new Point2D.Double(to.getX() - (double)(PORT_SIZE / 2), to.getY());
        int delta = 10;
        switch (this.connectorShape) {
            case LINEAR: {
                return new Line2D.Double(from, to);
            }
            case ORTHOGONAL: {
                GeneralPath connector = new GeneralPath();
                double sourceIndex = fromPort.getPorts().getAllPorts().indexOf(fromPort);
                double destIndex = -toPort.getPorts().getAllPorts().indexOf(toPort);
                int totalNumPorts = Math.max(fromPort.getPorts().getNumberOfPorts(), toPort.getPorts().getNumberOfPorts());
                double freeSpace = to.getX() - from.getX() - (double)(2 * delta);
                double centerX = (from.getX() + to.getX()) / 2.0 + 0.5 * freeSpace * ((sourceIndex + destIndex + 1.0) / (double)totalNumPorts - 0.5);
                connector.moveTo(from.getX() + 1.0, from.getY());
                if (to.getX() >= from.getX() + (double)(2 * delta)) {
                    if (to.getY() != from.getY()) {
                        connector.lineTo(centerX, from.getY());
                        connector.lineTo(centerX, to.getY());
                    }
                } else {
                    connector.lineTo(from.getX() + (double)delta, from.getY());
                    connector.lineTo(from.getX() + (double)delta, (from.getY() + to.getY()) / 2.0);
                    connector.lineTo(to.getX() - (double)delta, (from.getY() + to.getY()) / 2.0);
                    connector.lineTo(to.getX() - (double)delta, to.getY());
                }
                connector.lineTo(to.getX() - 1.0, to.getY());
                return connector;
            }
            case SPLINES: {
                GeneralPath connector = new GeneralPath();
                connector.moveTo(from.getX() + 1.0, from.getY());
                double cx = (from.getX() + to.getX()) / 2.0;
                double cy = (from.getY() + to.getY()) / 2.0;
                if (to.getX() >= from.getX() + (double)(2 * delta)) {
                    connector.curveTo(cx, from.getY(), cx, from.getY(), cx, cy);
                    connector.curveTo(cx, to.getY(), cx, to.getY(), to.getX() - 1.0, to.getY());
                } else {
                    connector.curveTo(from.getX() + (double)delta, from.getY(), from.getX() + (double)delta, cy, cx, cy);
                    connector.curveTo(to.getX() - (double)delta, cy, to.getX() - (double)delta, to.getY(), to.getX() - 1.0, to.getY());
                }
                return connector;
            }
        }
        return null;
    }

    private OutputPort getPortForConnectorNear(Point p, ExecutionUnit unit) {
        LinkedList candidates = new LinkedList();
        candidates.addAll(unit.getInnerSources().getAllPorts());
        for (Operator op : unit.getOperators()) {
            candidates.addAll(op.getOutputPorts().getAllPorts());
        }
        BasicStroke thickStroke = new BasicStroke(5.0f);
        for (OutputPort port : candidates) {
            Shape connector;
            Shape thick;
            if (!port.isConnected() || !(thick = thickStroke.createStrokedShape(connector = this.createConnector(port, port.getDestination()))).contains(p)) continue;
            return port;
        }
        return null;
    }

    private double getWidth(ExecutionUnit executionUnit) {
        return this.getWidth(executionUnit, true);
    }

    private void setInitialSizes(ExecutionUnit[] units) {
        Dimension frameSize = this.getParent() instanceof JViewport ? this.getParent().getSize() : this.getSize();
        for (ExecutionUnit unit : units) {
            Dimension size = this.processSizes.get(unit);
            if (size != null) continue;
            size = new Dimension((int)(frameSize.getWidth() / (double)this.processes.length - (double)(WALL_WIDTH * 2)), (int)(frameSize.getHeight() - (double)(2 * PADDING)));
            this.processSizes.put(unit, size);
        }
    }

    private double getWidth(ExecutionUnit executionUnit, boolean fill) {
        double totalWidth;
        double viewportWidth;
        double free;
        Dimension size = this.processSizes.get(executionUnit);
        double width = size.getWidth();
        if (fill && this.getParent() instanceof JViewport && (free = (viewportWidth = (double)((JViewport)this.getParent()).getWidth()) - (totalWidth = this.getTotalWidth(false))) > 0.0) {
            switch (ORIENTATION) {
                case Y_AXIS: {
                    width += free;
                    break;
                }
                case X_AXIS: {
                    width += (double)((int)free / this.processes.length);
                }
            }
        }
        return width;
    }

    private double getHeight(ExecutionUnit executionUnit) {
        return this.getHeight(executionUnit, true);
    }

    private double getTotalHeight() {
        return this.getTotalHeight(true);
    }

    private double getHeight(ExecutionUnit executionUnit, boolean fill) {
        double viewportHeight;
        double free;
        Dimension size = this.processSizes.get(executionUnit);
        double height = size.getHeight();
        if (fill && this.getParent() instanceof JViewport && (free = (viewportHeight = (double)((JViewport)this.getParent()).getHeight()) - this.getTotalHeight(false)) > 0.0) {
            switch (ORIENTATION) {
                case X_AXIS: {
                    height += free;
                    break;
                }
                case Y_AXIS: {
                    height += free / (double)this.processes.length;
                }
            }
        }
        return height;
    }

    private double getTotalWidth() {
        return this.getTotalWidth(true);
    }

    private double getTotalWidth(boolean fill) {
        double width = 0.0;
        block4: for (ExecutionUnit u : this.processes) {
            double w = this.getWidth(u, fill) + (double)(2 * WALL_WIDTH);
            switch (ORIENTATION) {
                case X_AXIS: {
                    width += w;
                    continue block4;
                }
                case Y_AXIS: {
                    if (!(w > width)) continue block4;
                    width = w;
                }
            }
        }
        return width;
    }

    private double getTotalHeight(boolean fill) {
        double height = 0.0;
        block4: for (ExecutionUnit u : this.processes) {
            double h = this.getHeight(u, fill) + (double)(2 * PADDING);
            switch (ORIENTATION) {
                case X_AXIS: {
                    if (!(h > height)) continue block4;
                    height = h;
                    continue block4;
                }
                case Y_AXIS: {
                    height += h;
                }
            }
        }
        return height;
    }

    private void setWidth(ExecutionUnit executionUnit, double width) {
        Dimension old = this.processSizes.get(executionUnit);
        old.setSize(width, old.getHeight());
        this.updateComponentSize();
    }

    private void setHeight(ExecutionUnit executionUnit, double height) {
        Dimension old = this.processSizes.get(executionUnit);
        old.setSize(old.getWidth(), height);
        this.updateComponentSize();
    }

    private void ensureWidth(ExecutionUnit executionUnit, int width) {
        Dimension old = this.processSizes.get(executionUnit);
        if ((double)width > old.getWidth()) {
            old.setSize((double)width, old.getHeight());
            this.balance();
            this.updateComponentSize();
        }
    }

    private void ensureHeight(ExecutionUnit executionUnit, int height) {
        Dimension old = this.processSizes.get(executionUnit);
        if ((double)height > old.getHeight()) {
            old.setSize(old.getWidth(), (double)height);
            this.balance();
            this.updateComponentSize();
        }
    }

    private Rectangle2D autoPosition(Operator op, int index) {
        int maxPerRow = (int)Math.max(1.0, Math.floor(this.getWidth(op.getExecutionUnit(), true) / (double)GRID_AUTOARRANGE_WIDTH));
        int col = index % maxPerRow;
        int row = index / maxPerRow;
        Rectangle2D old = this.operatorRects.get(op);
        Rectangle2D.Double rect = new Rectangle2D.Double(col * GRID_AUTOARRANGE_WIDTH + GRID_X_OFFSET, GRID_AUTOARRANGE_HEIGHT * row + GRID_Y_OFFSET, old != null ? old.getWidth() : (double)OPERATOR_WIDTH, old != null ? old.getHeight() : (double)MIN_OPERATOR_HEIGHT);
        this.setOperatorRect(op, rect);
        return rect;
    }

    private void autoArrange(ExecutionUnit process) {
        List<Operator> sorted = process.getOperators();
        int i = 0;
        for (Operator op : sorted) {
            this.autoPosition(op, i++);
        }
        this.autoFit(process, true);
        process.getEnclosingOperator().getProcess().updateNotify();
    }

    private void autoFit(ExecutionUnit process, boolean balance) {
        double w = 0.0;
        double h = 0.0;
        for (Operator op : process.getOperators()) {
            Rectangle2D bounds = this.getOperatorRect(op, true);
            if (bounds.getMaxX() > w) {
                w = bounds.getMaxX();
            }
            if (!(bounds.getMaxY() > h)) continue;
            h = bounds.getMaxY();
        }
        for (Port port : process.getInnerSources().getAllPorts()) {
            h = Math.max(h, this.getPortLocation(port).getY());
        }
        for (Port port : process.getInnerSinks().getAllPorts()) {
            h = Math.max(h, this.getPortLocation(port).getY());
        }
        this.setWidth(process, (int)(w + (double)(3 * PADDING)));
        this.setHeight(process, (int)(h + (double)(3 * PADDING)));
        if (balance) {
            this.balance();
            this.repaint();
        }
        this.updateExtensionButtons();
    }

    private void autoFit() {
        for (ExecutionUnit unit : this.processes) {
            this.autoFit(unit, false);
        }
        this.balance();
        this.repaint();
        this.updateExtensionButtons();
    }

    private void balance() {
        switch (ORIENTATION) {
            case X_AXIS: {
                this.balanceHeights();
                break;
            }
            case Y_AXIS: {
                this.balanceWidths();
            }
        }
    }

    private void balanceHeights() {
        double height = 0.0;
        for (ExecutionUnit p : this.processes) {
            double h = this.getHeight(p);
            if (!(h > height)) continue;
            height = h;
        }
        for (ExecutionUnit p : this.processes) {
            this.setHeight(p, height);
        }
    }

    private void balanceWidths() {
        double width = 0.0;
        for (ExecutionUnit p : this.processes) {
            double w = this.getWidth(p);
            if (!(w > width)) continue;
            width = w;
        }
        for (ExecutionUnit p : this.processes) {
            this.setWidth(p, width);
        }
    }

    private void updateComponentSize() {
        Dimension newSize = new Dimension((int)this.getTotalWidth(), (int)this.getTotalHeight());
        this.updateExtensionButtons();
        if (!newSize.equals(this.getPreferredSize())) {
            this.setPreferredSize(newSize);
            this.revalidate();
        }
    }

    int getProcessIndexUnder(Point2D p) {
        switch (ORIENTATION) {
            case X_AXIS: {
                if (p.getY() < (double)PADDING || p.getY() > this.getTotalHeight()) {
                    return -1;
                }
                int xOffset = 0;
                for (int i = 0; i < this.processes.length; ++i) {
                    int relativeX = (int)p.getX() - (xOffset += WALL_WIDTH);
                    if (relativeX >= 0 && (double)relativeX <= this.getWidth(this.processes[i])) {
                        return i;
                    }
                    xOffset = (int)((double)xOffset + ((double)WALL_WIDTH + this.getWidth(this.processes[i])));
                }
                break;
            }
            case Y_AXIS: {
                if (p.getX() < (double)WALL_WIDTH || p.getX() > (double)WALL_WIDTH + this.getTotalWidth()) {
                    return -1;
                }
                int yOffset = 0;
                for (int i = 0; i < this.processes.length; ++i) {
                    int relativeY = (int)p.getY() - yOffset;
                    if (relativeY >= 0 && (double)relativeY <= this.getHeight(this.processes[i])) {
                        return i;
                    }
                    yOffset = (int)((double)yOffset + ((double)PADDING + this.getHeight(this.processes[i])));
                }
                break;
            }
        }
        return -1;
    }

    private Point fromProcessSpace(Point p, int processIndex) {
        switch (ORIENTATION) {
            case X_AXIS: {
                double xOffset = 0.0;
                for (int i = 0; i < this.processes.length; ++i) {
                    xOffset += (double)WALL_WIDTH;
                    if (i == processIndex) {
                        return new Point((int)(p.getX() + xOffset), (int)(p.getY() + (double)PADDING));
                    }
                    xOffset += (double)WALL_WIDTH + this.getWidth(this.processes[i]);
                }
                break;
            }
            case Y_AXIS: {
                double yOffset = 0.0;
                for (int i = 0; i < this.processes.length; ++i) {
                    if (i == processIndex) {
                        return new Point((int)(p.getX() + (double)WALL_WIDTH), (int)(p.getY() + yOffset + (double)PADDING));
                    }
                    yOffset += (double)PADDING + this.getHeight(this.processes[i]);
                }
                break;
            }
        }
        return null;
    }

    Point toProcessSpace(Point p, int processIndex) {
        switch (ORIENTATION) {
            case X_AXIS: {
                int xOffset = 0;
                for (int i = 0; i < this.processes.length; ++i) {
                    xOffset += WALL_WIDTH;
                    if (i == processIndex) {
                        return new Point((int)p.getX() - xOffset, (int)p.getY() - PADDING);
                    }
                    xOffset = (int)((double)xOffset + ((double)WALL_WIDTH + this.getWidth(this.processes[i])));
                }
                break;
            }
            case Y_AXIS: {
                int yOffset = 0;
                for (int i = 0; i < this.processes.length; ++i) {
                    if (i == processIndex) {
                        return new Point((int)p.getX() - WALL_WIDTH, (int)p.getY() - yOffset - PADDING);
                    }
                    yOffset = (int)((double)yOffset + ((double)PADDING + this.getHeight(this.processes[i])));
                }
                break;
            }
        }
        return null;
    }

    private Operator getClosestLeftNeighbour(Point2D p, ExecutionUnit unit) {
        Operator closest = null;
        double minDist = Double.POSITIVE_INFINITY;
        for (Operator op : unit.getOperators()) {
            double dy;
            double dx;
            double dist;
            Rectangle2D rect = this.getOperatorRect(op, true);
            if (rect.getMaxX() >= p.getX() || !((dist = (dx = rect.getMaxX() - p.getX()) * dx + (dy = rect.getMaxY() - p.getY()) * dy) < minDist)) continue;
            minDist = dist;
            closest = op;
        }
        return closest;
    }

    private void showStatus(String msg) {
        RapidMinerGUI.getMainFrame().getStatusBar().setSpecialText(msg);
    }

    private void clearStatus() {
        RapidMinerGUI.getMainFrame().getStatusBar().clearSpecialText();
    }

    private void updateCursor() {
        if (this.getHoveringOperator() != null || this.hoveringPort != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private Rectangle2D getSelectionRectangle(Point dragStart, Point2D e) {
        if (dragStart == null) {
            return null;
        }
        return new Rectangle2D.Double(Math.min(dragStart.getX(), e.getX()), Math.min(dragStart.getY(), e.getY()), Math.abs(dragStart.getX() - e.getX()), Math.abs(dragStart.getY() - e.getY()));
    }

    public void processUpdated() {
        if (this.displayedChain.getNumberOfSubprocesses() != this.processes.length) {
            this.showOperatorChain(this.displayedChain);
        }
        this.repaint();
    }

    private Point snap(Point2D point) {
        int snappedX = (int)point.getX() - GRID_X_OFFSET;
        int factor = (snappedX + GRID_WIDTH / 2) / GRID_WIDTH;
        snappedX /= GRID_WIDTH;
        snappedX = factor * GRID_WIDTH + GRID_X_OFFSET;
        int snappedY = (int)point.getY() - GRID_Y_OFFSET;
        factor = (snappedY + GRID_HEIGHT / 2) / GRID_HEIGHT;
        snappedY /= GRID_HEIGHT;
        snappedY = factor * GRID_HEIGHT + GRID_Y_OFFSET;
        return new Point(snappedX, snappedY);
    }

    private boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    private String fitString(String string, Graphics2D g, int maxWidth) {
        Rectangle2D bounds = g.getFont().getStringBounds(string, g.getFontRenderContext());
        if (bounds.getWidth() < (double)maxWidth) {
            return string;
        }
        while (true) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!(g.getFont().getStringBounds(stringBuilder.append(string).append("...").toString(), g.getFontRenderContext()).getWidth() > (double)maxWidth)) break;
            if (string.length() == 0) {
                return "...";
            }
            string = string.substring(0, string.length() - 1);
        }
        return string + "...";
    }

    private boolean canBeInsertedIntoConnection(Operator operator) {
        if (operator == null) {
            return false;
        }
        boolean hasFreeInput = false;
        for (Port port : operator.getInputPorts().getAllPorts()) {
            if (port.isConnected()) continue;
            hasFreeInput = true;
            break;
        }
        if (!hasFreeInput) {
            return false;
        }
        for (Port port : operator.getOutputPorts().getAllPorts()) {
            if (port.isConnected()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoHoveringConnection(Operator operator) {
        if (this.hoveringConnectionSource == null) {
            return;
        }
        InputPort oldDest = this.hoveringConnectionSource.getDestination();
        oldDest.lock();
        this.hoveringConnectionSource.lock();
        try {
            InputPort bestInputPort = null;
            MetaData md = this.hoveringConnectionSource.getMetaData();
            if (md != null) {
                for (InputPort inCandidate : operator.getInputPorts().getAllPorts()) {
                    if (inCandidate.isConnected() || !inCandidate.isInputCompatible(md, CompatibilityLevel.PRE_VERSION_5)) continue;
                    bestInputPort = inCandidate;
                    break;
                }
            } else {
                for (InputPort inCandidate : operator.getInputPorts().getAllPorts()) {
                    if (inCandidate.isConnected()) continue;
                    bestInputPort = inCandidate;
                    break;
                }
            }
            if (bestInputPort != null) {
                this.hoveringConnectionSource.disconnect();
                this.connect(this.hoveringConnectionSource, bestInputPort);
                if (this.mainFrame.VALIDATE_AUTOMATICALLY_ACTION.isSelected()) {
                    this.hoveringConnectionSource.getPorts().getOwner().getOperator().transformMetaData();
                    operator.transformMetaData();
                }
                OutputPort bestOutput = null;
                for (OutputPort outCandidate : operator.getOutputPorts().getAllPorts()) {
                    if (outCandidate.isConnected() || (md = outCandidate.getMetaData()) == null || !oldDest.isInputCompatible(md, CompatibilityLevel.PRE_VERSION_5)) continue;
                    bestOutput = outCandidate;
                    break;
                }
                if (bestOutput == null) {
                    for (OutputPort outCandidate : operator.getOutputPorts().getAllPorts()) {
                        if (outCandidate.isConnected()) continue;
                        bestOutput = outCandidate;
                        break;
                    }
                }
                if (bestOutput != null) {
                    this.connect(bestOutput, oldDest);
                }
            }
        }
        finally {
            oldDest.unlock();
            this.hoveringConnectionSource.unlock();
            this.hoveringConnectionSource = null;
        }
    }

    public OverviewPanel getOverviewPanel() {
        return this.overviewPanel;
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.overviewPanel != null) {
            this.overviewPanel.repaint();
        }
    }

    private void rename(final Operator op) {
        int processIndex = this.getIndex(op.getExecutionUnit());
        if (processIndex == -1) {
            String name = SwingTools.showInputDialog("rename_operator", op.getName(), new Object[0]);
            if (name != null && name.length() > 0) {
                op.rename(name);
            }
            return;
        }
        this.renameField = new JTextField(10);
        Rectangle2D rect = this.getOperatorRect(op, false);
        double rollout = this.nameRolloutInterpolationMap.getValue(op);
        int width = 0;
        if (rollout > 0.0) {
            width = (int)OPERATOR_FONT.getStringBounds(op.getName(), ((Graphics2D)this.getGraphics()).getFontRenderContext()).getWidth();
        }
        width = Math.max(width, OPERATOR_WIDTH);
        this.renameField.setText(op.getName());
        this.renameField.selectAll();
        Point p = this.fromProcessSpace(new Point((int)rect.getX(), (int)rect.getY()), processIndex);
        this.renameField.setBounds((int)p.getX(), (int)p.getY() - 4, width + 1, 21);
        this.renameField.setFont(OPERATOR_FONT);
        this.add(this.renameField);
        this.renameField.requestFocus();
        this.renameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProcessRenderer.this.renameField != null) {
                    String name = ProcessRenderer.this.renameField.getText().trim();
                    if (name.length() > 0) {
                        op.rename(name);
                    }
                    ProcessRenderer.this.remove(ProcessRenderer.this.renameField);
                    ProcessRenderer.this.renameField = null;
                    ProcessRenderer.this.repaint();
                }
            }
        });
        this.renameField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ProcessRenderer.this.renameField != null) {
                    String name = ProcessRenderer.this.renameField.getText().trim();
                    if (name.length() > 0) {
                        op.rename(name);
                    }
                    ProcessRenderer.this.remove(ProcessRenderer.this.renameField);
                    ProcessRenderer.this.renameField = null;
                    ProcessRenderer.this.repaint();
                }
            }
        });
        this.renameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ProcessRenderer.this.remove(ProcessRenderer.this.renameField);
                    ProcessRenderer.this.renameField = null;
                    ProcessRenderer.this.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.repaint();
    }

    public void setHoveringOperator(Operator hoveringOperator) {
        if (hoveringOperator != this.hoveringOperator) {
            if (this.hoveringOperator != null) {
                this.nameRolloutInterpolationMap.rollIn(this.hoveringOperator);
            }
            if (hoveringOperator != null) {
                this.nameRolloutInterpolationMap.rollOut(hoveringOperator);
            }
        }
        this.hoveringOperator = hoveringOperator;
    }

    public Operator getHoveringOperator() {
        return this.hoveringOperator;
    }

    private void setDropInsertionPredecessor(Operator closestLeftNeighbour) {
        this.dropInsertionPredecessor = closestLeftNeighbour;
        if (this.dropInsertionPredecessor != null) {
            this.mainFrame.getStatusBar().setSpecialText("Operator will be inserted after " + this.dropInsertionPredecessor);
        } else {
            this.mainFrame.getStatusBar().setSpecialText("Operator will be inserted as the last operator in this process.");
        }
    }

    private boolean hasConnections(Operator op) {
        for (Port port : op.getInputPorts().getAllPorts()) {
            if (!port.isConnected()) continue;
            return true;
        }
        for (Port port : op.getOutputPorts().getAllPorts()) {
            if (!port.isConnected()) continue;
            return true;
        }
        return false;
    }

    public FlowVisualizer getFlowVisualizer() {
        return this.flowVisualizer;
    }

    public OperatorChain getDisplayedChain() {
        return this.displayedChain;
    }

    private void connect(OutputPort out, InputPort in) {
        Operator outOp;
        out.connectTo(in);
        Operator inOp = in.getPorts().getOwner().getOperator();
        if (!inOp.isEnabled()) {
            inOp.setEnabled(true);
        }
        if (!(outOp = out.getPorts().getOwner().getOperator()).isEnabled()) {
            outOp.setEnabled(true);
        }
    }

    private boolean checkPortUnder(Ports<? extends Port> ports, int x, int y) {
        for (Port port : ports.getAllPorts()) {
            int dy;
            int dx;
            Point location = this.getPortLocation(port);
            if (location == null || (dx = (int)((Point2D)location).getX() - x) * dx + (dy = (int)((Point2D)location).getY() - y) * dy >= 3 * PORT_SIZE * PORT_SIZE / 2) continue;
            if (this.hoveringPort != port) {
                this.hoveringPort = port;
                if (this.hoveringPort instanceof OutputPort) {
                    this.showStatus("Click to connect, ALT to disconnect.");
                }
                this.setHoveringOperator(null);
                this.updateCursor();
                this.repaint();
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Point access$3702(ProcessRenderer x0, Point x1) {
        x0.mousePositionAtLastEvaluation = x1;
        return x0.mousePositionAtLastEvaluation;
    }

    static /* synthetic */ OutputPort access$902(ProcessRenderer x0, OutputPort x1) {
        x0.selectedConnectionSource = x1;
        return x0.selectedConnectionSource;
    }

    static /* synthetic */ boolean access$4000(ProcessRenderer x0, Operator x1) {
        return x0.hasConnections(x1);
    }

    static /* synthetic */ void access$4100(ProcessRenderer x0, OutputPort x1, InputPort x2) {
        x0.connect(x1, x2);
    }

    static /* synthetic */ InterpolationMap access$4400(ProcessRenderer x0) {
        return x0.nameRolloutInterpolationMap;
    }

    static {
        try {
            GROUP_TO_COLOR_MAP.parseProperties("com/rapidminer/resources/groups.properties", "group.", ".color", OperatorDescription.class.getClassLoader());
            IO_CLASS_TO_COLOR_MAP.parseProperties("com/rapidminer/resources/groups.properties", "io.", ".color", OperatorDescription.class.getClassLoader());
        }
        catch (IOException e) {
            LogService.getRoot().warning("Cannot load operator group colors.");
        }
        DUMMY_LABEL = new JLabel();
        OPERATOR_WIDTH = 90;
        MIN_OPERATOR_HEIGHT = 60;
        PORT_SIZE = 12;
        PADDING = 10;
        WALL_WIDTH = 25;
        GRID_WIDTH = OPERATOR_WIDTH * 3 / 4;
        GRID_HEIGHT = MIN_OPERATOR_HEIGHT * 3 / 4;
        GRID_X_OFFSET = OPERATOR_WIDTH / 2;
        GRID_Y_OFFSET = MIN_OPERATOR_HEIGHT / 2;
        GRID_AUTOARRANGE_WIDTH = OPERATOR_WIDTH * 3 / 2;
        GRID_AUTOARRANGE_HEIGHT = MIN_OPERATOR_HEIGHT * 3 / 2;
        HI_QUALITY_HINTS = new RenderingHints(null);
        LOW_QUALITY_HINTS = new RenderingHints(null);
        HI_QUALITY_HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        HI_QUALITY_HINTS.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        LOW_QUALITY_HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        LOW_QUALITY_HINTS.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        IMAGE_WARNING = SwingTools.createIcon("16/sign_warning.png");
        IMAGE_BREAKPOINT_WITHIN = SwingTools.createIcon("16/breakpoint.png");
        IMAGE_BREAKPOINTS = SwingTools.createIcon("16/breakpoints.png");
        IMAGE_BREAKPOINT_BEFORE = SwingTools.createIcon("16/breakpoint_up.png");
        IMAGE_BREAKPOINT_AFTER = SwingTools.createIcon("16/breakpoint_down.png");
        IMAGE_BRANCH = SwingTools.createIcon("16/elements_selection.png");
        IMAGE_COMMENT = SwingTools.createIcon("16/document_text.png");
        OPERATOR_RUNNING = SwingTools.createIcon("16/bullet_triangle_glass_green.png");
        OPERATOR_READY = SwingTools.createIcon("16/bullet_ball_glass_green.png");
        OPERATOR_DIRTY = SwingTools.createIcon("16/bullet_ball_glass_yellow.png");
        OPERATOR_ERROR_ICON = SwingTools.createIcon("16/bullet_ball_glass_red.png");
        INNER_COLOR = Color.WHITE;
        SHADOW_COLOR = Color.LIGHT_GRAY;
        LINE_COLOR = Color.DARK_GRAY;
        LINE_STROKE = new BasicStroke(1.0f, 1, 1);
        HIGHLIGHT_STROKE = new BasicStroke(2.0f, 1, 1);
        SELECTION_RECT_STROKE = new BasicStroke(1.0f, 1, 1, 5.0f, new float[]{2.0f, 2.0f}, 0.0f);
        SELECTION_RECT_PAINT = Color.GRAY;
        PROCESS_TITLE_COLOR = SHADOW_COLOR;
        SHADOW_TOP_GRADIENT = new GradientPaint(0.0f, 0.0f, SHADOW_COLOR, PADDING, 0.0f, Color.WHITE);
        SHADOW_LEFT_GRADIENT = new GradientPaint(0.0f, 0.0f, SHADOW_COLOR, 0.0f, PADDING, Color.WHITE);
        CONNECTION_LINE_STROKE = new BasicStroke(1.3f, 1, 1);
        CONNECTION_HIGHLIGHT_STROKE = new BasicStroke(2.2f, 1, 1);
        CONNECTION_COLLECTION_LINE_STROKE = new BasicStroke(3.0f, 1, 1);
        CONNECTION_COLLECTION_HIGHLIGHT_STROKE = new BasicStroke(4.0f, 1, 1);
        OPERATOR_FONT = new Font("Dialog", 1, 11);
        HEADER_HEIGHT = OPERATOR_FONT.getSize() + 7;
        PROCESS_FONT = new Font("Dialog", 1, 12);
        PORT_FONT = new Font("Dialog", 0, 9);
        PORT_NAME_COLOR = Color.DARK_GRAY;
        PORT_NAME_SELECTION_COLOR = Color.GRAY;
        ACTIVE_EDGE_COLOR = SwingTools.RAPID_I_ORANGE;
        FRAME_STROKE_SELECTED = new BasicStroke(1.5f, 1, 1);
        FRAME_STROKE_NORMAL = new BasicStroke(1.0f, 1, 1);
        FRAME_COLOR_SELECTED = SwingTools.RAPID_I_ORANGE;
        FRAME_COLOR_NORMAL = LINE_COLOR;
        PORT_OFFSET = OPERATOR_FONT.getSize() + 6 + PORT_SIZE;
    }

    private class GUIProcessXMLFilter
    implements ProcessXMLFilter {
        private GUIProcessXMLFilter() {
        }

        @Override
        public void operatorExported(Operator op, Element opElement) {
            Rectangle2D bounds = ProcessRenderer.this.getOperatorRect(op, false);
            if (bounds != null) {
                opElement.setAttribute("x", "" + (int)bounds.getX());
                opElement.setAttribute("y", "" + (int)bounds.getY());
                opElement.setAttribute("width", "" + (int)bounds.getWidth());
                opElement.setAttribute("height", "" + (int)bounds.getHeight());
            }
        }

        @Override
        public void executionUnitExported(ExecutionUnit process, Element element) {
            Element spacingElement;
            Dimension size = (Dimension)ProcessRenderer.this.processSizes.get(process);
            if (size != null) {
                element.setAttribute("width", "" + (int)size.getWidth());
                element.setAttribute("height", "" + (int)size.getHeight());
            }
            for (Port port : process.getInnerSources().getAllPorts()) {
                spacingElement = element.getOwnerDocument().createElement("portSpacing");
                spacingElement.setAttribute("port", "source_" + port.getName());
                spacingElement.setAttribute("spacing", "" + (int)ProcessRenderer.this.getPortSpacing(port));
                element.appendChild(spacingElement);
            }
            for (Port port : process.getInnerSinks().getAllPorts()) {
                spacingElement = element.getOwnerDocument().createElement("portSpacing");
                spacingElement.setAttribute("port", "sink_" + port.getName());
                spacingElement.setAttribute("spacing", "" + (int)ProcessRenderer.this.getPortSpacing(port));
                element.appendChild(spacingElement);
            }
        }

        @Override
        public void operatorImported(Operator op, Element opElement) {
            String x = opElement.getAttribute("x");
            String y = opElement.getAttribute("y");
            String w = opElement.getAttribute("width");
            String h = opElement.getAttribute("height");
            if (x != null && x.length() > 0) {
                try {
                    ProcessRenderer.this.setOperatorRect(op, new Rectangle2D.Double(Double.parseDouble(x), Double.parseDouble(y), Double.parseDouble(w), Double.parseDouble(h)));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        @Override
        public void executionUnitImported(ExecutionUnit process, Element element) {
            Element psElement;
            int i;
            String w = element.getAttribute("width");
            String h = element.getAttribute("height");
            try {
                if (w != null && w.length() > 0) {
                    ProcessRenderer.this.processSizes.put(process, new Dimension((int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            NodeList children = element.getChildNodes();
            block6: for (Port port : process.getInnerSources().getAllPorts()) {
                for (i = 0; i < children.getLength(); ++i) {
                    if (!(children.item(i) instanceof Element) || !"portSpacing".equals(((Element)children.item(i)).getTagName())) continue;
                    psElement = (Element)children.item(i);
                    if (!("source_" + port.getName()).equals(psElement.getAttribute("port"))) continue;
                    try {
                        ProcessRenderer.this.portSpacings.put(port, Double.valueOf(Integer.parseInt(psElement.getAttribute("spacing"))));
                    }
                    catch (NumberFormatException e) {}
                    continue block6;
                }
            }
            block8: for (Port port : process.getInnerSinks().getAllPorts()) {
                for (i = 0; i < children.getLength(); ++i) {
                    if (!(children.item(i) instanceof Element) || !"portSpacing".equals(((Element)children.item(i)).getTagName())) continue;
                    psElement = (Element)children.item(i);
                    if (!("sink_" + port.getName()).equals(psElement.getAttribute("port"))) continue;
                    try {
                        ProcessRenderer.this.portSpacings.put(port, Double.valueOf(Integer.parseInt(psElement.getAttribute("spacing"))));
                    }
                    catch (NumberFormatException e) {}
                    continue block8;
                }
            }
        }
    }

    private static enum ConnectorShape {
        LINEAR,
        ORTHOGONAL,
        SPLINES;

    }

    private class ChangeSizeAction
    extends ResourceAction {
        private static final long serialVersionUID = 1L;
        private final int dx;
        private final int dy;

        private ChangeSizeAction(String key, int dx, int dy) {
            super("processrenderer." + key, new Object[0]);
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProcessRenderer.this.hoveringProcessIndex == -1) {
                return;
            }
            ExecutionUnit unit = ProcessRenderer.this.processes[ProcessRenderer.this.hoveringProcessIndex];
            ProcessRenderer.this.changeProcessSize(unit, this.dx, this.dy);
        }
    }

    private static enum Orientation {
        X_AXIS,
        Y_AXIS;

    }
}

