/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.Process;
import com.rapidminer.gui.tools.ParentButtonModel;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;

public class ProcessParentButtonModel
implements ParentButtonModel<Operator> {
    private Process process;

    public ProcessParentButtonModel(Process process) {
        this.process = process;
    }

    private List<Operator> getChildren(OperatorChain chain) {
        LinkedList<Operator> children = new LinkedList<Operator>();
        for (ExecutionUnit executionUnit : chain.getSubprocesses()) {
            children.addAll(executionUnit.getOperators());
        }
        return children;
    }

    @Override
    public Operator getChild(Operator node, int index) {
        if (node instanceof OperatorChain) {
            return this.getChildren((OperatorChain)node).get(index);
        }
        return null;
    }

    @Override
    public int getNumberOfChildren(Operator node) {
        if (node instanceof OperatorChain) {
            return this.getChildren((OperatorChain)node).size();
        }
        return 0;
    }

    @Override
    public Operator getParent(Operator child) {
        return child.getParent();
    }

    @Override
    public Operator getRoot() {
        if (this.process != null) {
            return this.process.getRootOperator();
        }
        return null;
    }

    @Override
    public String toString(Operator node) {
        return node.getName();
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    @Override
    public Icon getIcon(Operator node) {
        return node.getOperatorDescription().getSmallIcon();
    }
}

