/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.actions.AutoWireAction;
import com.rapidminer.gui.flow.ProcessButtonBar;
import com.rapidminer.gui.flow.ProcessRenderer;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.PrintingTools;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.gui.tools.components.DropDownButton;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ProcessPanel
extends JPanel
implements Dockable,
ProcessEditor {
    private static final long serialVersionUID = -4419160224916991497L;
    private final ProcessRenderer renderer;
    private final ProcessButtonBar processButtonBar;
    private OperatorChain operatorChain;
    public static final String PROCESS_PANEL_DOCK_KEY = "process_panel";
    private final DockKey DOCK_KEY = new ResourceDockKey("process_panel");

    public ProcessPanel(MainFrame mainFrame) {
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.processButtonBar = new ProcessButtonBar(mainFrame);
        this.renderer = new ProcessRenderer(this, mainFrame);
        this.renderer.setBackground(SwingTools.LIGHTEST_BLUE);
        ViewToolBar toolBar = new ViewToolBar();
        toolBar.add(this.processButtonBar);
        AutoWireAction autoWireAction = new AutoWireAction(mainFrame, "wire", CompatibilityLevel.PRE_VERSION_5, false, true);
        DropDownButton autoWireDropDownButton = DropDownButton.makeDropDownButton(autoWireAction);
        autoWireDropDownButton.add(autoWireAction);
        autoWireDropDownButton.add(new AutoWireAction(mainFrame, "wire_recursive", CompatibilityLevel.PRE_VERSION_5, true, true));
        autoWireDropDownButton.add(new AutoWireAction(mainFrame, "rewire", CompatibilityLevel.PRE_VERSION_5, false, false));
        autoWireDropDownButton.add(new AutoWireAction(mainFrame, "rewire_recursive", CompatibilityLevel.PRE_VERSION_5, true, false));
        autoWireDropDownButton.addToToolBar(toolBar, 1);
        toolBar.add((Component)this.renderer.getFlowVisualizer().SHOW_ORDER_TOGGLEBUTTON, 1);
        toolBar.add(this.renderer.ARRANGE_OPERATORS_ACTION, 1);
        toolBar.add(this.renderer.AUTO_FIT_ACTION, 1);
        String name = "process";
        if (mainFrame.getActions().getProcess() != null && mainFrame.getActions().getProcess().getProcessLocation() != null) {
            name = mainFrame.getActions().getProcess().getProcessLocation().getShortName();
        }
        DropDownButton exportDropDownButton = PrintingTools.makeExportPrintDropDownButton(this.renderer, name);
        exportDropDownButton.addToToolBar(toolBar, 1);
        this.setLayout(new BorderLayout());
        this.add((Component)toolBar, "North");
        JScrollPane scrollPane = new JScrollPane(this.renderer);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    public void showOperatorChain(OperatorChain operatorChain) {
        this.operatorChain = operatorChain;
        if (operatorChain == null) {
            this.processButtonBar.setSelectedNode(null);
            this.renderer.showOperatorChain(null);
        } else {
            this.renderer.showOperatorChain(operatorChain);
            this.processButtonBar.setSelectedNode(operatorChain);
            StringBuilder b = new StringBuilder("<html><strong>");
            b.append(operatorChain.getName());
            b.append("</strong>&nbsp;<emph>(");
            b.append(operatorChain.getOperatorDescription().getName());
            b.append(")</emph><br/>");
            b.append("Subprocesses: ");
            boolean first = true;
            for (ExecutionUnit executionUnit : operatorChain.getSubprocesses()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append("<em>");
                b.append(executionUnit.getName());
                b.append("</em> (");
                b.append(executionUnit.getOperators().size());
                b.append(" operators)");
            }
            b.append("</html>");
        }
    }

    @Override
    public void setSelection(List<Operator> selection) {
        Operator first;
        Operator operator = first = selection.isEmpty() ? null : selection.get(0);
        if (first != null) {
            this.processButtonBar.addToHistory(first);
        }
        if (((Object)this.renderer.getSelection()).equals(selection)) {
            return;
        }
        if (first == null) {
            this.showOperatorChain(null);
        } else {
            OperatorChain target = first instanceof OperatorChain ? (OperatorChain)first : first.getParent();
            this.showOperatorChain(target);
            this.renderer.setSelection(selection);
        }
    }

    @Override
    public void processChanged(Process process) {
        this.processButtonBar.clearHistory();
    }

    @Override
    public void processUpdated(Process process) {
        this.renderer.processUpdated();
        this.processButtonBar.setSelectedNode(this.operatorChain);
    }

    public ProcessRenderer getProcessRenderer() {
        return this.renderer;
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }
}

