/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PanningManager
implements AWTEventListener {
    private static final int PAN_DELAY = 50;
    private static final int PAN_STEP_SIZE = 20;
    private JComponent target;
    private Point mouseOnScreenPoint;
    private Timer timer = new Timer(50, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PanningManager.this.scrollNow();
        }
    });

    public PanningManager(JComponent target) {
        this.target = target;
        this.timer.setRepeats(true);
        this.timer.start();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (!SwingUtilities.isDescendingFrom(me.getComponent(), this.target)) {
                return;
            }
            if (me.getID() == 502) {
                this.mouseOnScreenPoint = null;
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (me.getID() == 506 && me.getComponent() == this.target) {
                this.mouseOnScreenPoint = me.getLocationOnScreen();
            } else if (me.getID() == 501 && me.getComponent() == this.target) {
                this.mouseOnScreenPoint = me.getLocationOnScreen();
                this.timer.start();
            }
        }
    }

    private void scrollNow() {
        if (this.mouseOnScreenPoint != null) {
            Point origin = this.target.getLocationOnScreen();
            Point relative = new Point(this.mouseOnScreenPoint.x - origin.x, this.mouseOnScreenPoint.y - origin.y);
            Rectangle visibleRect = this.target.getVisibleRect();
            if (!visibleRect.contains(relative)) {
                int destX = relative.x;
                if (relative.getX() < visibleRect.getMinX()) {
                    destX = (int)visibleRect.getMinX() - 20;
                }
                if (relative.getX() > visibleRect.getMaxX()) {
                    destX = (int)visibleRect.getMaxX() + 20;
                }
                int destY = relative.y;
                if (relative.getY() < visibleRect.getMinY()) {
                    destY = (int)visibleRect.getMinY() - 20;
                }
                if (relative.getY() > visibleRect.getMaxY()) {
                    destY = (int)visibleRect.getMaxY() + 20;
                }
                this.target.scrollRectToVisible(new Rectangle(new Point(destX, destY)));
            }
        }
    }
}

