/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.flow.ProcessRenderer;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class OverviewPanel
extends JPanel
implements Dockable {
    private static final long serialVersionUID = 1L;
    private static final Color FILL_COLOR = new Color(140, 140, 200, 30);
    private static final Color DRAW_COLOR = new Color(140, 140, 200);
    private final ProcessRenderer processRenderer;
    private Point dragStartMousePos;
    private Rectangle dragStartRect;
    private double scale = 1.0;
    public static final String OVERVIEW_DOCK_KEY = "overview";
    private final DockKey DOCK_KEY = new ResourceDockKey("overview");

    public OverviewPanel(ProcessRenderer processRenderer) {
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.processRenderer = processRenderer;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OverviewPanel.this.dragStartMousePos = e.getPoint();
                OverviewPanel.this.dragStartRect = OverviewPanel.this.processRenderer.getVisibleRect();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double diffX = ((double)e.getX() - OverviewPanel.this.dragStartMousePos.getX()) / OverviewPanel.this.scale;
                double diffY = ((double)e.getY() - OverviewPanel.this.dragStartMousePos.getY()) / OverviewPanel.this.scale;
                OverviewPanel.this.processRenderer.scrollRectToVisible(new Rectangle((int)(OverviewPanel.this.dragStartRect.getX() + diffX), (int)(OverviewPanel.this.dragStartRect.getY() + diffY), (int)OverviewPanel.this.dragStartRect.getWidth(), (int)OverviewPanel.this.dragStartRect.getHeight()));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        double scaleX = (double)this.getWidth() / (double)this.processRenderer.getWidth();
        double scaleY = (double)this.getHeight() / (double)this.processRenderer.getHeight();
        this.scale = Math.min(scaleX, scaleY);
        double scaledW = (double)this.processRenderer.getWidth() * this.scale;
        double scaledH = (double)this.processRenderer.getHeight() * this.scale;
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(((double)this.getWidth() - scaledW) / 2.0, ((double)this.getHeight() - scaledH) / 2.0);
        g.scale(this.scale, this.scale);
        this.processRenderer.paintComponent(g);
        g.setStroke(new BasicStroke((int)(1.0 / this.scale)));
        Rectangle visibleRect = this.processRenderer.getVisibleRect();
        Rectangle drawRect = new Rectangle((int)visibleRect.getX(), (int)visibleRect.getY(), (int)visibleRect.getWidth() - 1, (int)visibleRect.getHeight() - 1);
        g.setColor(FILL_COLOR);
        g.fill(drawRect);
        g.setColor(DRAW_COLOR);
        g.draw(drawRect);
        g.dispose();
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }
}

