/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.operator.Operator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Timer;

public class InterpolationMap {
    private static final long DELAY = 300L;
    private static final long INTERVAL = 500L;
    private static final int REPAINT_DELAY = 50;
    private final Component component;
    private final Map<Operator, InterpolatedValue> map = new HashMap<Operator, InterpolatedValue>();
    private final Timer timer = new Timer(50, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            InterpolationMap.this.fireRepaint();
        }
    });

    public InterpolationMap(Component component) {
        this.component = component;
        this.timer.setRepeats(false);
    }

    protected void fireRepaint() {
        this.component.repaint();
        this.cleanUp();
        if (!this.map.isEmpty() && !this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void rollOut(Operator operator) {
        this.map.put(operator, new InterpolatedValue(true, 1.0));
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void rollIn(Operator operator) {
        this.map.put(operator, new InterpolatedValue(false, this.getValue(operator)));
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public double getValue(Operator op) {
        InterpolatedValue val = this.map.get(op);
        if (val == null) {
            return 0.0;
        }
        double value = val.getValue();
        return value;
    }

    private void cleanUp() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Operator, InterpolatedValue>> i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Operator, InterpolatedValue> entry = i.next();
            if (!entry.getValue().isDone(now)) continue;
            i.remove();
        }
    }

    public void clear() {
        this.map.clear();
    }

    private static class InterpolatedValue {
        private final long startTime = System.currentTimeMillis();
        private final boolean up;
        private double extensionValue = 1.0;

        private InterpolatedValue(boolean up, double extensionValue) {
            this.up = up;
            this.extensionValue = extensionValue;
        }

        private double getValue() {
            long now = System.currentTimeMillis();
            if (this.up) {
                if (now < this.startTime + 300L) {
                    return 0.0;
                }
                if (now > this.startTime + 300L + 500L) {
                    return this.extensionValue;
                }
                return this.extensionValue * this.damp(((double)now - (double)this.startTime - 300.0) / 500.0);
            }
            if (now < this.startTime) {
                return this.extensionValue;
            }
            if (now > this.startTime + 500L) {
                return 0.0;
            }
            return this.extensionValue - this.extensionValue * this.damp(((double)now - (double)this.startTime) / 500.0);
        }

        private boolean isDone(long now) {
            return !this.up && now > this.startTime + 500L;
        }

        private double damp(double value) {
            return Math.sqrt(value);
        }
    }
}

