/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.gui.actions.ToggleAction;
import com.rapidminer.gui.flow.ProcessRenderer;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.InputPort;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;

public class FlowVisualizer {
    private static final Stroke FLOW_STROKE = new BasicStroke(10.0f, 1, 1);
    private static final Font FLOW_FONT = new Font("Dialog", 1, 18);
    private static final Stroke LINE_STROKE = new BasicStroke(1.0f, 1, 1);
    private static final Stroke HIGHLIGHT_STROKE = new BasicStroke(2.0f, 1, 1);
    private static final Color PASSIVE_COLOR = new Color(0, 0, 0, 50);
    private static final Color FLOW_COLOR = new Color(SwingTools.RAPID_I_ORANGE.getRed(), SwingTools.RAPID_I_ORANGE.getGreen(), SwingTools.RAPID_I_ORANGE.getBlue(), 150);
    public final ToggleAction ALTER_EXECUTION_ORDER = new ToggleAction(true, "render_execution_order", new Object[0]){
        private static final long serialVersionUID = -8333670355512143502L;

        @Override
        public void actionToggled(ActionEvent e) {
            FlowVisualizer.this.setActive(this.isSelected());
            FlowVisualizer.this.processRenderer.repaint();
        }
    };
    protected JToggleButton SHOW_ORDER_TOGGLEBUTTON = this.ALTER_EXECUTION_ORDER.createToggleButton();
    public final Action SHOW_EXECUTION_ORDER = new ResourceAction("show_execution_order", new Object[0]){
        private static final long serialVersionUID = 3932329413268066576L;

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowVisualizer.this.setActive(true);
            FlowVisualizer.this.processRenderer.repaint();
            StringBuilder b = new StringBuilder();
            for (ExecutionUnit unit : FlowVisualizer.this.processRenderer.getDisplayedChain().getSubprocesses()) {
                b.append("<strong>").append(unit.getName()).append("</strong><br/><ol>");
                for (Operator op : unit.topologicalSort()) {
                    b.append("<li>").append(op.getName()).append("</li>");
                }
                b.append("</ol>");
            }
            SwingTools.showLongMessage("execution_order_info", b.toString());
            FlowVisualizer.this.setActive(FlowVisualizer.this.ALTER_EXECUTION_ORDER.isSelected());
            FlowVisualizer.this.processRenderer.repaint();
        }
    };
    private final Action BRING_TO_FRONT = new ResourceAction("bring_operator_to_front", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowVisualizer.this.hoveringOperator != null) {
                FlowVisualizer.this.hoveringOperator.getExecutionUnit().moveToIndex(FlowVisualizer.this.hoveringOperator, 0);
            }
        }
    };
    private boolean active = false;
    private final ProcessRenderer processRenderer;
    private Operator startOperator;
    private Operator endOperator;
    private Operator hoveringOperator;
    private Collection<Operator> dependentOps;

    public FlowVisualizer(ProcessRenderer processRenderer2) {
        this.processRenderer = processRenderer2;
        this.installListeners();
        this.SHOW_ORDER_TOGGLEBUTTON.setText(null);
    }

    private void installListeners() {
        this.processRenderer.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FlowVisualizer.this.isActive()) {
                    if (FlowVisualizer.this.showPopupMenu(e)) {
                        return;
                    }
                    Operator op = FlowVisualizer.this.findOperator(e.getPoint());
                    switch (e.getButton()) {
                        case 1: {
                            if (FlowVisualizer.this.startOperator == null) {
                                if (op == FlowVisualizer.this.startOperator) break;
                                FlowVisualizer.this.startOperator = op;
                                FlowVisualizer.this.dependentOps = null;
                                FlowVisualizer.this.recomputeDependentOperators();
                                FlowVisualizer.this.processRenderer.repaint();
                                break;
                            }
                            if (FlowVisualizer.this.dependentOps == null) break;
                            FlowVisualizer.this.startOperator.getExecutionUnit().bringToFront(FlowVisualizer.this.dependentOps, FlowVisualizer.this.startOperator);
                            FlowVisualizer.this.startOperator = (FlowVisualizer.this.endOperator = null);
                            FlowVisualizer.this.dependentOps = null;
                            FlowVisualizer.this.processRenderer.repaint();
                            break;
                        }
                        case 3: {
                            FlowVisualizer.this.startOperator = (FlowVisualizer.this.endOperator = null);
                            FlowVisualizer.this.dependentOps = null;
                            FlowVisualizer.this.processRenderer.repaint();
                        }
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (FlowVisualizer.this.isActive() && FlowVisualizer.this.showPopupMenu(e)) {
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (FlowVisualizer.this.isActive() && FlowVisualizer.this.showPopupMenu(e)) {
                    return;
                }
            }
        });
        this.processRenderer.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (FlowVisualizer.this.isActive()) {
                    FlowVisualizer.this.hoveringOperator = FlowVisualizer.this.findOperator(e.getPoint());
                    if (FlowVisualizer.this.startOperator != null && FlowVisualizer.this.hoveringOperator != FlowVisualizer.this.startOperator) {
                        FlowVisualizer.this.endOperator = FlowVisualizer.this.hoveringOperator;
                        FlowVisualizer.this.recomputeDependentOperators();
                        FlowVisualizer.this.processRenderer.repaint();
                    }
                }
            }
        });
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void render(Graphics2D g, ExecutionUnit process) {
        if (this.active) {
            LinkedList<Operator> operators = new LinkedList<Operator>(process.getOperators());
            if (this.dependentOps != null) {
                operators.removeAll(this.dependentOps);
                int insertionIndex = operators.indexOf(this.startOperator) + 1;
                for (Operator depOp : this.dependentOps) {
                    operators.add(insertionIndex++, depOp);
                }
            }
            Point2D lastPoint = null;
            g.setStroke(FLOW_STROKE);
            for (Operator op : operators) {
                if (!op.isEnabled()) continue;
                Rectangle2D r = this.processRenderer.getOperatorRect(op, true);
                if (this.startOperator == null || this.dependentOps != null && this.dependentOps.contains(op)) {
                    g.setColor(FLOW_COLOR);
                } else {
                    g.setColor(PASSIVE_COLOR);
                }
                if (lastPoint != null) {
                    g.draw(new Line2D.Double(lastPoint.getX(), lastPoint.getY(), r.getCenterX(), r.getCenterY()));
                }
                lastPoint = new Point2D.Double(r.getCenterX(), r.getCenterY());
            }
            int i = 0;
            g.setStroke(LINE_STROKE);
            g.setFont(FLOW_FONT);
            boolean illegalStart = operators.indexOf(this.endOperator) < operators.indexOf(this.startOperator);
            for (Operator op : operators) {
                if (!op.isEnabled()) continue;
                ++i;
                Rectangle2D r = this.processRenderer.getOperatorRect(op, true);
                int size = 30;
                double y = r.getMinY() + (double)ProcessRenderer.HEADER_HEIGHT + (r.getHeight() - (double)ProcessRenderer.HEADER_HEIGHT - 10.0) / 2.0;
                Ellipse2D.Double circle = new Ellipse2D.Double(r.getCenterX() - (double)(size / 2), y - (double)(size / 2), size, size);
                if (illegalStart && op == this.endOperator) {
                    g.setColor(Color.red);
                } else if (op == this.startOperator || op == this.endOperator) {
                    g.setColor(SwingTools.LIGHT_BLUE);
                } else if (this.dependentOps != null && this.dependentOps.contains(op)) {
                    g.setColor(SwingTools.LIGHT_BLUE);
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fill(circle);
                if (op == this.hoveringOperator || this.startOperator == null || this.startOperator == op || this.dependentOps != null && this.dependentOps.contains(op)) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.LIGHT_GRAY);
                }
                if (op == this.hoveringOperator) {
                    g.setStroke(HIGHLIGHT_STROKE);
                } else {
                    g.setStroke(LINE_STROKE);
                }
                g.draw(circle);
                String label = "" + i;
                Rectangle2D bounds = FLOW_FONT.getStringBounds(label, g.getFontRenderContext());
                g.drawString(label, (float)(r.getCenterX() - bounds.getWidth() / 2.0), (float)(y - bounds.getHeight() / 2.0 - bounds.getY()));
            }
        }
    }

    private Collection<Operator> getDependingOperators(Operator enclosingOperator, int startIndex, int endIndex, List<Operator> topologicallySortedCandidates) {
        if (endIndex <= startIndex) {
            return Collections.emptyList();
        }
        HashSet<Operator> foundDependingOperators = new HashSet<Operator>();
        HashSet<Operator> completedOperators = new HashSet<Operator>();
        Operator stopWhenReaching = topologicallySortedCandidates.get(startIndex);
        foundDependingOperators.add(topologicallySortedCandidates.get(endIndex));
        for (int opIndex = endIndex; opIndex > startIndex; --opIndex) {
            Operator op = topologicallySortedCandidates.get(opIndex);
            completedOperators.add(op);
            if (!foundDependingOperators.contains(op)) continue;
            for (InputPort in : op.getInputPorts().getAllPorts()) {
                int predecessorIndex;
                Operator predecessor;
                if (!in.isConnected() || (predecessor = in.getSource().getPorts().getOwner().getOperator()) == enclosingOperator || completedOperators.contains(predecessor) || predecessor == stopWhenReaching || (predecessorIndex = topologicallySortedCandidates.indexOf(predecessor)) <= startIndex) continue;
                foundDependingOperators.add(predecessor);
            }
        }
        LinkedList<Operator> orderedResult = new LinkedList<Operator>();
        for (Operator op : topologicallySortedCandidates) {
            if (!foundDependingOperators.contains(op)) continue;
            orderedResult.add(op);
        }
        return orderedResult;
    }

    public Operator findOperator(Point point) {
        int processIndex = this.processRenderer.getProcessIndexUnder(point);
        if (processIndex != -1) {
            Point mousePositionRelativeToProcess = this.processRenderer.toProcessSpace(point, processIndex);
            for (Operator op : this.processRenderer.getDisplayedChain().getSubprocess(processIndex).getOperators()) {
                Rectangle2D rect = this.processRenderer.getOperatorRect(op, true);
                if (!rect.contains(new Point2D.Double(mousePositionRelativeToProcess.x, mousePositionRelativeToProcess.y))) continue;
                return op;
            }
        }
        return null;
    }

    private void recomputeDependentOperators() {
        if (this.startOperator == null || this.endOperator == null) {
            this.dependentOps = null;
        } else {
            ExecutionUnit unit = this.startOperator.getExecutionUnit();
            if (this.endOperator.getExecutionUnit() != unit) {
                this.dependentOps = null;
                return;
            }
            List<Operator> operators = unit.getOperators();
            this.dependentOps = this.getDependingOperators(this.processRenderer.getDisplayedChain(), operators.indexOf(this.startOperator), operators.indexOf(this.endOperator), operators);
        }
    }

    private boolean showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.hoveringOperator != null) {
                JPopupMenu menu = new JPopupMenu();
                menu.add(this.BRING_TO_FRONT);
                menu.show(this.processRenderer, e.getX(), e.getY());
                return true;
            }
            return false;
        }
        return false;
    }
}

